/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSTestWrapper;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestWrapper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SymlinkBaseTest;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestSymlinkHdfs
extends SymlinkBaseTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestSymlinkHdfs.class);
    protected static MiniDFSCluster cluster;
    protected static WebHdfsFileSystem webhdfs;
    protected static DistributedFileSystem dfs;

    public TestSymlinkHdfs() {
        GenericTestUtils.setLogLevel((Logger)NameNode.stateChangeLog, (Level)Level.ALL);
    }

    protected String getScheme() {
        return "hdfs";
    }

    protected String testBaseDir1() throws IOException {
        return "/test1";
    }

    protected String testBaseDir2() throws IOException {
        return "/test2";
    }

    protected URI testURI() {
        return cluster.getURI(0);
    }

    protected IOException unwrapException(IOException e) {
        if (e instanceof RemoteException) {
            return ((RemoteException)((Object)e)).unwrapRemoteException();
        }
        return e;
    }

    @BeforeClass
    public static void beforeClassSetup() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.permissions.umask-mode", "000");
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 0);
        cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        webhdfs = WebHdfsTestUtil.getWebHdfsFileSystem((Configuration)conf, "webhdfs");
        dfs = cluster.getFileSystem();
    }

    @AfterClass
    public static void afterClassTeardown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{webhdfs});
    }

    @Test(timeout=10000L)
    public void testLinkAcrossFileSystems() throws IOException {
        Path localDir = new Path("file://" + wrapper.getAbsoluteTestRootDir() + "/test");
        Path localFile = new Path("file://" + wrapper.getAbsoluteTestRootDir() + "/test/file");
        Path link = new Path(this.testBaseDir1(), "linkToFile");
        FSTestWrapper localWrapper = wrapper.getLocalFSWrapper();
        localWrapper.delete(localDir, true);
        localWrapper.mkdir(localDir, FileContext.DEFAULT_PERM, true);
        localWrapper.setWorkingDirectory(localDir);
        Assert.assertEquals((Object)localDir, (Object)localWrapper.getWorkingDirectory());
        TestSymlinkHdfs.createAndWriteFile((FSTestWrapper)localWrapper, (Path)localFile);
        wrapper.createSymlink(localFile, link, false);
        TestSymlinkHdfs.readFile((Path)link);
        Assert.assertEquals((long)16384L, (long)wrapper.getFileStatus(link).getLen());
    }

    @Test(timeout=10000L)
    public void testRenameAcrossFileSystemsViaLink() throws IOException {
        Path localDir = new Path("file://" + wrapper.getAbsoluteTestRootDir() + "/test");
        Path hdfsFile = new Path(this.testBaseDir1(), "file");
        Path link = new Path(this.testBaseDir1(), "link");
        Path hdfsFileNew = new Path(this.testBaseDir1(), "fileNew");
        Path hdfsFileNewViaLink = new Path(link, "fileNew");
        FSTestWrapper localWrapper = wrapper.getLocalFSWrapper();
        localWrapper.delete(localDir, true);
        localWrapper.mkdir(localDir, FileContext.DEFAULT_PERM, true);
        localWrapper.setWorkingDirectory(localDir);
        TestSymlinkHdfs.createAndWriteFile((Path)hdfsFile);
        wrapper.createSymlink(localDir, link, false);
        try {
            wrapper.rename(hdfsFile, hdfsFileNewViaLink, new Options.Rename[0]);
            Assert.fail((String)"Renamed across file systems");
        }
        catch (InvalidPathException invalidPathException) {
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Wrong FS: ", (Throwable)e);
        }
        TestSymlinkHdfs.createAndWriteFile((Path)hdfsFileNewViaLink);
        try {
            wrapper.rename(hdfsFileNewViaLink, hdfsFileNew, new Options.Rename[0]);
            Assert.fail((String)"Renamed across file systems");
        }
        catch (InvalidPathException e) {
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Wrong FS: ", (Throwable)e);
        }
    }

    @Test(timeout=10000L)
    public void testCreateLinkToSlash() throws IOException {
        Path dir = new Path(this.testBaseDir1());
        Path file = new Path(this.testBaseDir1(), "file");
        Path link = new Path(this.testBaseDir1(), "linkToSlash");
        Path fileViaLink = new Path(this.testBaseDir1() + "/linkToSlash" + this.testBaseDir1() + "/file");
        TestSymlinkHdfs.createAndWriteFile((Path)file);
        wrapper.setWorkingDirectory(dir);
        wrapper.createSymlink(new Path("/"), link, false);
        TestSymlinkHdfs.readFile((Path)fileViaLink);
        Assert.assertEquals((long)16384L, (long)wrapper.getFileStatus(fileViaLink).getLen());
        if (wrapper instanceof FileContextTestWrapper) {
            FSTestWrapper localWrapper = wrapper.getLocalFSWrapper();
            Path linkQual = new Path(cluster.getURI(0).toString(), fileViaLink);
            Assert.assertEquals((long)16384L, (long)localWrapper.getFileStatus(linkQual).getLen());
        }
    }

    @Test(timeout=10000L)
    public void testSetPermissionAffectsTarget() throws IOException {
        Path file = new Path(this.testBaseDir1(), "file");
        Path dir = new Path(this.testBaseDir2());
        Path linkToFile = new Path(this.testBaseDir1(), "linkToFile");
        Path linkToDir = new Path(this.testBaseDir1(), "linkToDir");
        TestSymlinkHdfs.createAndWriteFile((Path)file);
        wrapper.createSymlink(file, linkToFile, false);
        wrapper.createSymlink(dir, linkToDir, false);
        FsPermission perms = wrapper.getFileLinkStatus(linkToFile).getPermission();
        wrapper.setPermission(linkToFile, new FsPermission(436));
        wrapper.setOwner(linkToFile, "user", "group");
        Assert.assertEquals((Object)perms, (Object)wrapper.getFileLinkStatus(linkToFile).getPermission());
        FileStatus stat = wrapper.getFileStatus(file);
        Assert.assertEquals((long)436L, (long)stat.getPermission().toShort());
        Assert.assertEquals((Object)"user", (Object)stat.getOwner());
        Assert.assertEquals((Object)"group", (Object)stat.getGroup());
        Assert.assertEquals((Object)stat.getPermission(), (Object)wrapper.getFileStatus(linkToFile).getPermission());
        perms = wrapper.getFileLinkStatus(linkToDir).getPermission();
        wrapper.setPermission(linkToDir, new FsPermission(436));
        wrapper.setOwner(linkToDir, "user", "group");
        Assert.assertEquals((Object)perms, (Object)wrapper.getFileLinkStatus(linkToDir).getPermission());
        stat = wrapper.getFileStatus(dir);
        Assert.assertEquals((long)436L, (long)stat.getPermission().toShort());
        Assert.assertEquals((Object)"user", (Object)stat.getOwner());
        Assert.assertEquals((Object)"group", (Object)stat.getGroup());
        Assert.assertEquals((Object)stat.getPermission(), (Object)wrapper.getFileStatus(linkToDir).getPermission());
    }

    @Test(timeout=10000L)
    public void testCreateWithPartQualPathFails() throws IOException {
        Path fileWoAuth = new Path("hdfs:///test/file");
        Path linkWoAuth = new Path("hdfs:///test/link");
        try {
            TestSymlinkHdfs.createAndWriteFile((Path)fileWoAuth);
            Assert.fail((String)"HDFS requires URIs with schemes have an authority");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            wrapper.createSymlink(new Path("foo"), linkWoAuth, false);
            Assert.fail((String)"HDFS requires URIs with schemes have an authority");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void testSetReplication() throws IOException {
        Path file = new Path(this.testBaseDir1(), "file");
        Path link = new Path(this.testBaseDir1(), "linkToFile");
        TestSymlinkHdfs.createAndWriteFile((Path)file);
        wrapper.createSymlink(file, link, false);
        wrapper.setReplication(link, (short)2);
        Assert.assertEquals((long)0L, (long)wrapper.getFileLinkStatus(link).getReplication());
        Assert.assertEquals((long)2L, (long)wrapper.getFileStatus(link).getReplication());
        Assert.assertEquals((long)2L, (long)wrapper.getFileStatus(file).getReplication());
    }

    @Test(timeout=10000L)
    public void testCreateLinkMaxPathLink() throws IOException {
        int i;
        Path dir = new Path(this.testBaseDir1());
        Path file = new Path(this.testBaseDir1(), "file");
        int maxPathLen = 8000;
        int dirLen = dir.toString().length() + 1;
        int len = 8000 - dirLen;
        StringBuilder sb = new StringBuilder("");
        for (i = 0; i < len / 10; ++i) {
            sb.append("0123456789");
        }
        for (i = 0; i < len % 10; ++i) {
            sb.append("x");
        }
        Path link = new Path(sb.toString());
        Assert.assertEquals((long)8000L, (long)(dirLen + link.toString().length()));
        TestSymlinkHdfs.createAndWriteFile((Path)file);
        wrapper.setWorkingDirectory(dir);
        wrapper.createSymlink(file, link, false);
        TestSymlinkHdfs.readFile((Path)link);
        link = new Path(sb.toString() + "x");
        try {
            wrapper.createSymlink(file, link, false);
            Assert.fail((String)"Path name should be too long");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void testLinkOwner() throws IOException {
        Path file = new Path(this.testBaseDir1(), "file");
        Path link = new Path(this.testBaseDir1(), "symlinkToFile");
        TestSymlinkHdfs.createAndWriteFile((Path)file);
        wrapper.createSymlink(file, link, false);
        FileStatus statFile = wrapper.getFileStatus(file);
        FileStatus statLink = wrapper.getFileStatus(link);
        Assert.assertEquals((Object)statLink.getOwner(), (Object)statFile.getOwner());
    }

    @Test(timeout=10000L)
    public void testWebHDFS() throws IOException {
        Path file = new Path(this.testBaseDir1(), "file");
        Path link = new Path(this.testBaseDir1(), "linkToFile");
        TestSymlinkHdfs.createAndWriteFile((Path)file);
        webhdfs.createSymlink(file, link, false);
        wrapper.setReplication(link, (short)2);
        Assert.assertEquals((long)0L, (long)wrapper.getFileLinkStatus(link).getReplication());
        Assert.assertEquals((long)2L, (long)wrapper.getFileStatus(link).getReplication());
        Assert.assertEquals((long)2L, (long)wrapper.getFileStatus(file).getReplication());
    }

    @Test(timeout=10000L)
    public void testQuota() throws IOException {
        Path dir = new Path(this.testBaseDir1());
        dfs.setQuota(dir, 3L, Long.MAX_VALUE);
        Path file = new Path(dir, "file");
        TestSymlinkHdfs.createAndWriteFile((Path)file);
        Path link1 = new Path(dir, "link1");
        wrapper.createSymlink(file, link1, false);
        try {
            Path link2 = new Path(dir, "link2");
            wrapper.createSymlink(file, link2, false);
            Assert.fail((String)"Created symlink despite quota violation");
        }
        catch (QuotaExceededException quotaExceededException) {
            // empty catch block
        }
    }
}

