/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.metrics.RBFMetrics;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MultipleDestinationMountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.router.Quota;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterClientProtocol;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUsage;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterServiceState;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.impl.DisabledNameserviceStoreImpl;
import org.apache.hadoop.hdfs.server.federation.store.impl.MountTableStoreImpl;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MockStateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.tools.federation.RouterAdmin;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.Whitebox;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRouterAdminCLI {
    private static StateStoreDFSCluster cluster;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static StateStoreService stateStore;
    private static RouterAdmin admin;
    private static RouterClient client;
    private static Router router;
    private static final String TEST_USER = "test-user";
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ByteArrayOutputStream err = new ByteArrayOutputStream();
    private static final PrintStream OLD_OUT;
    private static final PrintStream OLD_ERR;

    @BeforeClass
    public static void globalSetUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 1, MultipleDestinationMountTableResolver.class);
        Configuration conf = new RouterConfigBuilder().stateStore().metrics().admin().rpc().quota().safemode().build();
        cluster.addRouterOverrides(conf);
        cluster.startRouters();
        routerContext = cluster.getRandomRouter();
        router = routerContext.getRouter();
        stateStore = router.getStateStore();
        Configuration routerConf = new Configuration();
        InetSocketAddress routerSocket = router.getAdminServerAddress();
        routerConf.setSocketAddr("dfs.federation.router.admin-address", routerSocket);
        admin = new RouterAdmin(routerConf);
        client = routerContext.getAdminClient();
        ActiveNamenodeResolver membership = router.getNamenodeResolver();
        membership.registerNamenode(FederationTestUtils.createNamenodeReport("ns0", "nn1", HAServiceProtocol.HAServiceState.ACTIVE));
        membership.registerNamenode(FederationTestUtils.createNamenodeReport("ns1", "nn1", HAServiceProtocol.HAServiceState.ACTIVE));
        stateStore.refreshCaches(true);
        Quota quota = (Quota)Mockito.spy((Object)routerContext.getRouter().createRpcServer().getQuotaModule());
        ((Quota)Mockito.doNothing().when((Object)quota)).setQuota(Mockito.anyString(), Mockito.anyLong(), Mockito.anyLong(), (StorageType)Mockito.any(), Mockito.anyBoolean());
        Whitebox.setInternalState((Object)routerContext.getRouter().getRpcServer(), (String)"quotaCall", (Object)quota);
        RouterRpcServer spyRpcServer = (RouterRpcServer)Mockito.spy((Object)routerContext.getRouter().createRpcServer());
        Whitebox.setInternalState((Object)routerContext.getRouter(), (String)"rpcServer", (Object)spyRpcServer);
        ((RouterRpcServer)Mockito.doReturn(null).when((Object)spyRpcServer)).getFileInfo(Mockito.anyString());
    }

    @AfterClass
    public static void tearDownCluster() {
        cluster.stopRouter(routerContext);
        cluster.shutdown();
        cluster = null;
    }

    @After
    public void tearDown() {
        System.setOut(OLD_OUT);
        System.setErr(OLD_ERR);
    }

    @Test
    public void testAddMountTable() throws Exception {
        String nsId = "ns0,ns1";
        String src = "/test-addmounttable";
        String dest = "/addmounttable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        List destinations = mountTable.getDestinations();
        Assert.assertEquals((long)2L, (long)destinations.size());
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)"ns0", (Object)((RemoteLocation)destinations.get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)destinations.get(0)).getDest());
        Assert.assertEquals((Object)"ns1", (Object)((RemoteLocation)destinations.get(1)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)destinations.get(1)).getDest());
        Assert.assertFalse((boolean)mountTable.isReadOnly());
        Assert.assertFalse((boolean)mountTable.isFaultTolerant());
        dest = dest + "-new";
        argv = new String[]{"-add", src, nsId, dest, "-readonly", "-faulttolerant", "-order", "HASH_ALL"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((long)4L, (long)mountTable.getDestinations().size());
        RemoteLocation loc2 = (RemoteLocation)mountTable.getDestinations().get(2);
        Assert.assertEquals((Object)"ns0", (Object)loc2.getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)loc2.getDest());
        RemoteLocation loc3 = (RemoteLocation)mountTable.getDestinations().get(3);
        Assert.assertEquals((Object)"ns1", (Object)loc3.getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)loc3.getDest());
        Assert.assertTrue((boolean)mountTable.isReadOnly());
        Assert.assertTrue((boolean)mountTable.isFaultTolerant());
    }

    @Test
    public void testAddMountTableNotNormalized() throws Exception {
        String nsId = "ns0";
        String src = "/test-addmounttable-notnormalized";
        String srcWithSlash = src + "/";
        String dest = "/addmounttable-notnormalized";
        String[] argv = new String[]{"-add", srcWithSlash, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        List destinations = mountTable.getDestinations();
        Assert.assertEquals((long)1L, (long)destinations.size());
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)destinations.get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)destinations.get(0)).getDest());
        Assert.assertFalse((boolean)mountTable.isReadOnly());
        Assert.assertFalse((boolean)mountTable.isFaultTolerant());
        dest = dest + "-new";
        argv = new String[]{"-add", srcWithSlash, nsId, dest, "-readonly"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((long)2L, (long)mountTable.getDestinations().size());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(1)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(1)).getDest());
        Assert.assertTrue((boolean)mountTable.isReadOnly());
    }

    @Test
    public void testAddOrderMountTable() throws Exception {
        this.testAddOrderMountTable(DestinationOrder.HASH);
        this.testAddOrderMountTable(DestinationOrder.LOCAL);
        this.testAddOrderMountTable(DestinationOrder.RANDOM);
        this.testAddOrderMountTable(DestinationOrder.HASH_ALL);
        this.testAddOrderMountTable(DestinationOrder.SPACE);
    }

    @Test
    public void testAddOrderErrorMsg() throws Exception {
        DestinationOrder order = DestinationOrder.HASH;
        String mnt = "/newAdd1" + order;
        String nsId = "ns0,ns1";
        String dest = "/changAdd";
        String[] argv1 = new String[]{"-add", mnt, "ns0,ns1", "/changAdd", "-order", order.toString()};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv1));
        String[] argv = new String[]{"-add", mnt, "ns0,ns1", "/changAdd", "-orde", order.toString()};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
    }

    private void testAddOrderMountTable(DestinationOrder order) throws Exception {
        String mnt = "/" + order;
        String nsId = "ns0,ns1";
        String dest = "/";
        String[] argv = new String[]{"-add", mnt, "ns0,ns1", "/", "-order", order.toString()};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        MountTableManager mountTable = client.getMountTableManager();
        GetMountTableEntriesRequest request = GetMountTableEntriesRequest.newInstance((String)mnt);
        GetMountTableEntriesResponse response = mountTable.getMountTableEntries(request);
        List entries = response.getEntries();
        Assert.assertEquals((long)1L, (long)entries.size());
        Assert.assertEquals((long)2L, (long)((MountTable)entries.get(0)).getDestinations().size());
        Assert.assertEquals((Object)order, (Object)((MountTable)response.getEntries().get(0)).getDestOrder());
    }

    @Test
    public void testListMountTable() throws Exception {
        String nsId = "ns0";
        String src = "/test-lsmounttable";
        String srcWithSlash = src + "/";
        String dest = "/lsmounttable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        System.setOut(new PrintStream(this.out));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        argv = new String[]{"-ls", src};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        String response = this.out.toString();
        Assert.assertTrue((String)("Wrong response: " + response), (boolean)response.contains(src));
        argv = new String[]{"-ls", srcWithSlash};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        response = this.out.toString();
        Assert.assertTrue((String)("Wrong response: " + response), (boolean)response.contains(src));
        argv = new String[]{"-ls", srcWithSlash, "check", "check2"};
        System.setErr(new PrintStream(this.err));
        ToolRunner.run((Tool)admin, (String[])argv);
        response = this.err.toString();
        Assert.assertTrue((String)("Wrong response: " + response), (boolean)response.contains("Too many arguments, Max=2 argument allowed"));
        this.out.reset();
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)"/");
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        argv = new String[]{"-ls"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        response = this.out.toString();
        Assert.assertTrue((String)("Wrong response: " + response), (boolean)response.contains(src));
        for (MountTable entry : getResponse.getEntries()) {
            Assert.assertTrue((String)("Wrong response: " + response), (boolean)response.contains(entry.getSourcePath()));
        }
    }

    @Test
    public void testListWithDetails() throws Exception {
        String[] argv = new String[]{"-add", "/testLsWithDetails", "ns0,ns1", "/dest", "-order", "HASH_ALL", "-readonly", "-faulttolerant"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        System.setOut(new PrintStream(this.out));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        argv = new String[]{"-ls", "-d", "/testLsWithDetails"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        String response = this.out.toString();
        Assert.assertTrue((boolean)response.contains("Read-Only"));
        Assert.assertTrue((boolean)response.contains("Fault-Tolerant"));
        this.out.reset();
        argv = new String[]{"-ls", "-d"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        response = this.out.toString();
        Assert.assertTrue((String)("Wrong response: " + response), (boolean)response.contains("Read-Only"));
        Assert.assertTrue((String)("Wrong response: " + response), (boolean)response.contains("Fault-Tolerant"));
    }

    @Test
    public void testListNestedMountTable() throws Exception {
        String dir1 = "/test-ls";
        String dir2 = "/test-ls-longger";
        String[] nsIdList = new String[]{"ns0", "ns1", "ns2", "ns3", "ns3"};
        String[] sourceList = new String[]{dir1, dir1 + "/subdir1", dir2, dir2 + "/subdir1", dir2 + "/subdir2"};
        String[] destList = new String[]{"/test-ls", "/test-ls/subdir1", "/ls", "/ls/subdir1", "/ls/subdir2"};
        for (int i = 0; i < nsIdList.length; ++i) {
            String[] argv = new String[]{"-add", sourceList[i], nsIdList[i], destList[i]};
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        }
        System.setOut(new PrintStream(this.out));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        String[] argv = new String[]{"-ls", dir1};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        String outStr = this.out.toString();
        Assert.assertTrue((boolean)this.out.toString().contains(dir1 + "/subdir1"));
        Assert.assertFalse((boolean)this.out.toString().contains(dir2));
        argv = new String[]{"-ls", dir2};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains(dir2 + "/subdir1"));
        Assert.assertTrue((boolean)this.out.toString().contains(dir2 + "/subdir2"));
    }

    @Test
    public void testRemoveMountTable() throws Exception {
        String nsId = "ns0";
        String src = "/test-rmmounttable";
        String dest = "/rmmounttable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        argv = new String[]{"-rm", src};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        Assert.assertEquals((long)0L, (long)getResponse.getEntries().size());
        String invalidPath = "/invalid";
        System.setOut(new PrintStream(this.out));
        argv = new String[]{"-rm", invalidPath};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains("Cannot remove mount point " + invalidPath));
    }

    @Test
    public void testMultiArgsRemoveMountTable() throws Exception {
        String nsId = "ns0";
        String src1 = "/test-rmmounttable1";
        String src2 = "/test-rmmounttable2";
        String dest1 = "/rmmounttable1";
        String dest2 = "/rmmounttable2";
        String[] argv = new String[]{"-add", src1, nsId, dest1};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-add", src2, nsId, dest2};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src1);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        getRequest = GetMountTableEntriesRequest.newInstance((String)src2);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        Assert.assertEquals((Object)src1, (Object)mountTable.getSourcePath());
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src2, (Object)mountTable.getSourcePath());
        argv = new String[]{"-rm", src1, src2};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        Assert.assertEquals((long)0L, (long)getResponse.getEntries().size());
    }

    @Test
    public void testRemoveMountTableNotNormalized() throws Exception {
        String nsId = "ns0";
        String src = "/test-rmmounttable-notnormalized";
        String srcWithSlash = src + "/";
        String dest = "/rmmounttable-notnormalized";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        argv = new String[]{"-rm", srcWithSlash};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        Assert.assertEquals((long)0L, (long)getResponse.getEntries().size());
    }

    @Test
    public void testMountTableDefaultACL() throws Exception {
        String[] argv = new String[]{"-add", "/testpath0", "ns0", "/testdir0"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)"/testpath0");
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String group = ugi.getGroups().isEmpty() ? ugi.getShortUserName() : ugi.getPrimaryGroupName();
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)mountTable.getOwnerName());
        Assert.assertEquals((Object)group, (Object)mountTable.getGroupName());
        Assert.assertEquals((long)493L, (long)mountTable.getMode().toShort());
    }

    @Test
    public void testMountTablePermissions() throws Exception {
        System.setOut(new PrintStream(this.out));
        String[] argv = new String[]{"-add", "/testpath2-1", "ns0", "/testdir2-1", "-owner", TEST_USER, "-group", TEST_USER, "-mode", "0455"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        String superUser = UserGroupInformation.getCurrentUser().getShortUserName();
        UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)TEST_USER);
        UserGroupInformation.setLoginUser((UserGroupInformation)remoteUser);
        this.verifyExecutionResult("/testpath2-1", true, -1, -1);
        argv = new String[]{"-add", "/testpath2-2", "ns0", "/testdir2-2", "-owner", TEST_USER, "-group", TEST_USER, "-mode", "0255"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        this.verifyExecutionResult("/testpath2-2", false, -1, 0);
        argv = new String[]{"-add", "/testpath2-3", "ns0", "/testdir2-3", "-owner", TEST_USER, "-group", TEST_USER, "-mode", "0755"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        this.verifyExecutionResult("/testpath2-3", true, 0, 0);
        remoteUser = UserGroupInformation.createRemoteUser((String)superUser);
        UserGroupInformation.setLoginUser((UserGroupInformation)remoteUser);
    }

    private void verifyExecutionResult(String mount, boolean canRead, int addCommandCode, int rmCommandCode) throws Exception {
        String[] argv = null;
        stateStore.loadCache(MountTableStoreImpl.class, true);
        this.out.reset();
        argv = new String[]{"-ls", mount};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertEquals((Object)canRead, (Object)this.out.toString().contains(mount));
        argv = new String[]{"-add", mount, "ns0", mount + "newdir"};
        Assert.assertEquals((long)addCommandCode, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        argv = new String[]{"-rm", mount};
        Assert.assertEquals((long)rmCommandCode, (long)ToolRunner.run((Tool)admin, (String[])argv));
    }

    @Test
    public void testInvalidArgumentMessage() throws Exception {
        String nsId = "ns0";
        String src = "/testSource";
        System.setOut(new PrintStream(this.out));
        String[] argv = new String[]{"-add", src, nsId};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((String)("Wrong message: " + this.out), (boolean)this.out.toString().contains("\t[-add <source> <nameservice1, nameservice2, ...> <destination> [-readonly] [-faulttolerant] [-order HASH|LOCAL|RANDOM|HASH_ALL|SPACE] -owner <owner> -group <group> -mode <mode>]"));
        this.out.reset();
        argv = new String[]{"-update", src, nsId};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((String)("Wrong message: " + this.out), (boolean)this.out.toString().contains("\t[-update <source> [<nameservice1, nameservice2, ...> <destination>] [-readonly true|false] [-faulttolerant true|false] [-order HASH|LOCAL|RANDOM|HASH_ALL|SPACE] -owner <owner> -group <group> -mode <mode>]"));
        this.out.reset();
        argv = new String[]{"-rm"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains("\t[-rm <source>]"));
        this.out.reset();
        argv = new String[]{"-setQuota", src};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains("\t[-setQuota <path> -nsQuota <nsQuota> -ssQuota <quota in bytes or quota size string>]"));
        this.out.reset();
        argv = new String[]{"-clrQuota"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains("\t[-clrQuota <path>]"));
        this.out.reset();
        argv = new String[]{"-safemode"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains("\t[-safemode enter | leave | get]"));
        this.out.reset();
        argv = new String[]{"-nameservice", nsId};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains("\t[-nameservice enable | disable <nameservice>]"));
        this.out.reset();
        argv = new String[]{"-getDestination"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains("\t[-getDestination <path>]"));
        this.out.reset();
        argv = new String[]{"-refreshRouterArgs"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains("\t[-refreshRouterArgs <host:ipc_port> <key> [arg1..argn]]"));
        this.out.reset();
        argv = new String[]{"-Random"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        String expected = "Usage: hdfs dfsrouteradmin :\n\t[-add <source> <nameservice1, nameservice2, ...> <destination> [-readonly] [-faulttolerant] [-order HASH|LOCAL|RANDOM|HASH_ALL|SPACE] -owner <owner> -group <group> -mode <mode>]\n\t[-update <source> [<nameservice1, nameservice2, ...> <destination>] [-readonly true|false] [-faulttolerant true|false] [-order HASH|LOCAL|RANDOM|HASH_ALL|SPACE] -owner <owner> -group <group> -mode <mode>]\n\t[-rm <source>]\n\t[-ls [-d] <path>]\n\t[-getDestination <path>]\n\t[-setQuota <path> -nsQuota <nsQuota> -ssQuota <quota in bytes or quota size string>]\n\t[-setStorageTypeQuota <path> -storageType <storage type> <quota in bytes or quota size string>]\n\t[-clrQuota <path>]\n\t[-clrStorageTypeQuota <path>]\n\t[-dumpState]\n\t[-safemode enter | leave | get]\n\t[-nameservice enable | disable <nameservice>]\n\t[-getDisabledNameservices]\n\t[-refresh]\n\t[-refreshRouterArgs <host:ipc_port> <key> [arg1..argn]]";
        Assert.assertTrue((String)("Wrong message: " + this.out), (boolean)this.out.toString().contains(expected));
        this.out.reset();
    }

    @Test
    public void testWrongArgumentsWhenSetStorageTypeQuota() throws Exception {
        String src = "/type-QuotaMounttable";
        System.setErr(new PrintStream(this.err));
        String[] argv = new String[]{"-setStorageTypeQuota", src, "check", "c2", "c3"};
        ToolRunner.run((Tool)admin, (String[])argv);
        Assert.assertTrue((boolean)this.err.toString().contains("Invalid argument : check"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetStorageTypeQuota() throws Exception {
        String nsId = "ns0";
        String src = "/type-QuotaMounttable";
        String dest = "/type-QuotaMounttable";
        try {
            this.addMountTable(src, nsId, dest);
            MountTable mountTable = this.getMountTable(src).get(0);
            RouterQuotaUsage quotaUsage = mountTable.getQuota();
            for (StorageType t : StorageType.values()) {
                Assert.assertEquals((long)0L, (long)quotaUsage.getTypeConsumed(t));
                Assert.assertEquals((long)-1L, (long)quotaUsage.getTypeQuota(t));
            }
            long ssQuota = 100L;
            this.setStorageTypeQuota(src, ssQuota, StorageType.DISK);
            mountTable = this.getMountTable(src).get(0);
            quotaUsage = mountTable.getQuota();
            Assert.assertEquals((long)ssQuota, (long)quotaUsage.getTypeQuota(StorageType.DISK));
        }
        finally {
            this.rmMountTable(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClearStorageTypeQuota() throws Exception {
        String nsId = "ns0";
        String src = "/type-QuotaMounttable";
        String src1 = "/type-QuotaMounttable1";
        String dest = "/type-QuotaMounttable";
        String dest1 = "/type-QuotaMounttable1";
        long ssQuota = 100L;
        try {
            this.addMountTable(src, nsId, dest);
            this.addMountTable(src1, nsId, dest1);
            this.setStorageTypeQuota(src, ssQuota, StorageType.DISK);
            Assert.assertEquals((long)ssQuota, (long)this.getMountTable(src).get(0).getQuota().getTypeQuota(StorageType.DISK));
            this.setStorageTypeQuota(src1, ssQuota, StorageType.DISK);
            Assert.assertEquals((long)ssQuota, (long)this.getMountTable(src1).get(0).getQuota().getTypeQuota(StorageType.DISK));
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-clrStorageTypeQuota", src, src1}));
            stateStore.loadCache(MountTableStoreImpl.class, true);
            List<MountTable> mountTables = this.getMountTable("/");
            for (int i = 0; i < 2; ++i) {
                MountTable mountTable = mountTables.get(i);
                RouterQuotaUsage quotaUsage = mountTable.getQuota();
                for (StorageType t : StorageType.values()) {
                    Assert.assertEquals((long)0L, (long)quotaUsage.getTypeConsumed(t));
                    Assert.assertEquals((long)-1L, (long)quotaUsage.getTypeQuota(t));
                }
            }
        }
        finally {
            this.rmMountTable(src);
            this.rmMountTable(src1);
        }
    }

    @Test
    public void testSetAndClearQuota() throws Exception {
        String nsId = "ns0";
        String src = "/test-QuotaMounttable";
        String src1 = "/test-QuotaMounttable1";
        String dest = "/QuotaMounttable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        RouterQuotaUsage quotaUsage = mountTable.getQuota();
        Assert.assertEquals((long)0L, (long)quotaUsage.getFileAndDirectoryCount());
        Assert.assertEquals((long)-1L, (long)quotaUsage.getQuota());
        Assert.assertEquals((long)0L, (long)quotaUsage.getSpaceConsumed());
        Assert.assertEquals((long)-1L, (long)quotaUsage.getSpaceQuota());
        long nsQuota = 50L;
        long ssQuota = 100L;
        argv = new String[]{"-setQuota", src, "-nsQuota", String.valueOf(nsQuota), "-ssQuota", String.valueOf(ssQuota)};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        quotaUsage = mountTable.getQuota();
        Assert.assertEquals((long)nsQuota, (long)quotaUsage.getQuota());
        Assert.assertEquals((long)ssQuota, (long)quotaUsage.getSpaceQuota());
        String newSsQuota = "2m";
        argv = new String[]{"-setQuota", src, "-ssQuota", newSsQuota};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        quotaUsage = mountTable.getQuota();
        Assert.assertEquals((long)nsQuota, (long)quotaUsage.getQuota());
        Assert.assertEquals((long)0x200000L, (long)quotaUsage.getSpaceQuota());
        argv = new String[]{"-clrQuota", src};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        quotaUsage = mountTable.getQuota();
        Assert.assertEquals((long)-1L, (long)quotaUsage.getQuota());
        Assert.assertEquals((long)-1L, (long)quotaUsage.getSpaceQuota());
        String dest1 = "/QuotaMounttable1";
        argv = new String[]{"-add", src1, nsId, dest1};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        argv = new String[]{"-setQuota", src, "-nsQuota", String.valueOf(nsQuota), "-ssQuota", String.valueOf(ssQuota)};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-setQuota", src1, "-nsQuota", String.valueOf(nsQuota), "-ssQuota", String.valueOf(ssQuota)};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        argv = new String[]{"-clrQuota", src, src1};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getRequest = GetMountTableEntriesRequest.newInstance((String)"/");
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        for (int i = 0; i < 2; ++i) {
            mountTable = (MountTable)getResponse.getEntries().get(i);
            quotaUsage = mountTable.getQuota();
            Assert.assertEquals((long)-1L, (long)quotaUsage.getQuota());
            Assert.assertEquals((long)-1L, (long)quotaUsage.getSpaceQuota());
        }
        System.setErr(new PrintStream(this.err));
        argv = new String[]{"-setQuota", src, "check", "check2"};
        ToolRunner.run((Tool)admin, (String[])argv);
        Assert.assertTrue((boolean)this.err.toString().contains("Invalid argument : check"));
    }

    @Test
    public void testManageSafeMode() throws Exception {
        this.waitState(RouterServiceState.RUNNING);
        Assert.assertFalse((boolean)routerContext.getRouter().getSafemodeService().isInSafeMode());
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "enter"}));
        Assert.assertEquals((Object)RouterServiceState.SAFEMODE, (Object)routerContext.getRouter().getRouterState());
        Assert.assertTrue((boolean)routerContext.getRouter().getSafemodeService().isInSafeMode());
        System.setOut(new PrintStream(this.out));
        System.setErr(new PrintStream(this.err));
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "get"}));
        Assert.assertTrue((boolean)this.out.toString().contains("true"));
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "leave"}));
        Assert.assertEquals((Object)RouterServiceState.RUNNING, (Object)routerContext.getRouter().getRouterState());
        Assert.assertFalse((boolean)routerContext.getRouter().getSafemodeService().isInSafeMode());
        this.out.reset();
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "get"}));
        Assert.assertTrue((boolean)this.out.toString().contains("false"));
        this.out.reset();
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "get", "-random", "check"}));
        Assert.assertTrue((String)this.err.toString(), (boolean)this.err.toString().contains("safemode: Too many arguments, Max=1 argument allowed only"));
        this.err.reset();
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "check"}));
        Assert.assertTrue((String)this.err.toString(), (boolean)this.err.toString().contains("safemode: Invalid argument: check"));
        this.err.reset();
    }

    @Test
    public void testSafeModeStatus() throws Exception {
        this.waitState(RouterServiceState.RUNNING);
        Assert.assertFalse((boolean)routerContext.getRouter().getSafemodeService().isInSafeMode());
        RouterClientProtocol clientProtocol = routerContext.getRouter().getRpcServer().getClientProtocolModule();
        Assert.assertEquals((Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)clientProtocol.getHAServiceState());
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "enter"}));
        RBFMetrics metrics = router.getMetrics();
        String jsonString = metrics.getRouterStatus();
        String result = router.getNamenodeMetrics().getSafemode();
        Assert.assertTrue((String)("Wrong safe mode message: " + result), (boolean)result.startsWith("Safe mode is ON."));
        Assert.assertEquals((Object)RouterServiceState.SAFEMODE.toString(), (Object)jsonString);
        Assert.assertTrue((boolean)routerContext.getRouter().getSafemodeService().isInSafeMode());
        Assert.assertEquals((Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)clientProtocol.getHAServiceState());
        System.setOut(new PrintStream(this.out));
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "leave"}));
        jsonString = metrics.getRouterStatus();
        result = router.getNamenodeMetrics().getSafemode();
        Assert.assertEquals((String)("Wrong safe mode message: " + result), (Object)"", (Object)result);
        Assert.assertEquals((Object)RouterServiceState.RUNNING.toString(), (Object)jsonString);
        Assert.assertFalse((boolean)routerContext.getRouter().getSafemodeService().isInSafeMode());
        Assert.assertEquals((Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)clientProtocol.getHAServiceState());
        this.out.reset();
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "get"}));
        Assert.assertTrue((boolean)this.out.toString().contains("false"));
    }

    @Test
    public void testSafeModePermission() throws Exception {
        this.waitState(RouterServiceState.RUNNING);
        Assert.assertFalse((boolean)routerContext.getRouter().getSafemodeService().isInSafeMode());
        UserGroupInformation superUser = UserGroupInformation.createRemoteUser((String)UserGroupInformation.getCurrentUser().getShortUserName());
        UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)TEST_USER);
        try {
            UserGroupInformation.setLoginUser((UserGroupInformation)remoteUser);
            Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "enter"}));
            UserGroupInformation.setLoginUser((UserGroupInformation)superUser);
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "enter"}));
            UserGroupInformation.setLoginUser((UserGroupInformation)remoteUser);
            Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "leave"}));
            UserGroupInformation.setLoginUser((UserGroupInformation)superUser);
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "leave"}));
        }
        finally {
            UserGroupInformation.setLoginUser((UserGroupInformation)superUser);
        }
    }

    @Test
    public void testCreateInvalidEntry() throws Exception {
        String[] argv = new String[]{"-add", "test-createInvalidEntry", "ns0", "/createInvalidEntry"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-add", "/test-createInvalidEntry", "ns0", "createInvalidEntry"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-add", null, "ns0", "/createInvalidEntry"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-add", "/test-createInvalidEntry", "ns0", null};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-add", "", "ns0", "/createInvalidEntry"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-add", "/test-createInvalidEntry", null, "/createInvalidEntry"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-add", "/test-createInvalidEntry", "", "/createInvalidEntry"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
    }

    @Test
    public void testNameserviceManager() throws Exception {
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-nameservice", "disable", "ns0"}));
        stateStore.loadCache(DisabledNameserviceStoreImpl.class, true);
        System.setOut(new PrintStream(this.out));
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-getDisabledNameservices"}));
        Assert.assertTrue((String)("ns0 should be reported: " + this.out), (boolean)this.out.toString().contains("ns0"));
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-nameservice", "enable", "ns0"}));
        this.out.reset();
        stateStore.loadCache(DisabledNameserviceStoreImpl.class, true);
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-getDisabledNameservices"}));
        Assert.assertFalse((String)("ns0 should not be reported: " + this.out), (boolean)this.out.toString().contains("ns0"));
        System.setErr(new PrintStream(this.err));
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-nameservice", "enable"}));
        String msg = "Not enough parameters specificed for cmd -nameservice";
        Assert.assertTrue((String)("Got error: " + this.err.toString()), (boolean)this.err.toString().startsWith(msg));
        this.err.reset();
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-nameservice", "wrong", "ns0"}));
        Assert.assertTrue((String)("Got error: " + this.err.toString()), (boolean)this.err.toString().startsWith("nameservice: Unknown command: wrong"));
        this.err.reset();
        ToolRunner.run((Tool)admin, (String[])new String[]{"-nameservice", "enable", "ns0", "check"});
        Assert.assertTrue((boolean)this.err.toString().contains("Too many arguments, Max=2 arguments allowed"));
        this.err.reset();
        ToolRunner.run((Tool)admin, (String[])new String[]{"-getDisabledNameservices", "check"});
        Assert.assertTrue((boolean)this.err.toString().contains("No arguments allowed"));
    }

    @Test
    public void testRefreshMountTableCache() throws Exception {
        String src = "/refreshMount";
        String[] argv = new String[]{"-add", src, "refreshNS0", "/refreshDest"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        System.setOut(new PrintStream(this.out));
        argv = new String[]{"-refresh"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().startsWith("Successfully updated mount table cache"));
        this.out.reset();
        argv = new String[]{"-ls", src};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains(src));
    }

    private void waitState(final RouterServiceState expectedState) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return expectedState == routerContext.getRouter().getRouterState();
            }
        }, (long)1000L, (long)30000L);
    }

    @Test
    public void testUpdateNonExistingMountTable() throws Exception {
        System.setErr(new PrintStream(this.err));
        String nsId = "ns0";
        String src = "/test-updateNonExistingMounttable";
        String dest = "/updateNonExistingMounttable";
        String[] argv = new String[]{"-update", src, nsId, dest};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((String)this.err.toString(), (boolean)this.err.toString().contains("update: /test-updateNonExistingMounttable doesn't exist."));
    }

    @Test
    public void testUpdateDestinationForExistingMountTable() throws Exception {
        String nsId = "ns0";
        String src = "/test-updateDestinationForExistingMountTable";
        String dest = "/UpdateDestinationForExistingMountTable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
        String newNsId = "ns1";
        String newDest = "/newDestination";
        argv = new String[]{"-update", src, newNsId, newDest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)newNsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)newDest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
    }

    @Test
    public void testUpdateDestinationForExistingMountTableNotNormalized() throws Exception {
        String nsId = "ns0";
        String src = "/test-updateDestinationForExistingMountTableNotNormalized";
        String srcWithSlash = src + "/";
        String dest = "/UpdateDestinationForExistingMountTableNotNormalized";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
        String newNsId = "ns1";
        String newDest = "/newDestination";
        argv = new String[]{"-update", srcWithSlash, newNsId, newDest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)newNsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)newDest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
    }

    @Test
    public void testUpdateChangeAttributes() throws Exception {
        String nsId = "ns0";
        String src = "/mount";
        String dest = "/dest";
        String[] argv = new String[]{"-add", src, nsId, dest, "-readonly", "-order", "HASH_ALL"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        String newNsId = "ns0";
        String newDest = "/newDestination";
        argv = new String[]{"-update", src, newNsId, newDest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)newNsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)newDest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
        Assert.assertTrue((boolean)mountTable.isReadOnly());
        Assert.assertEquals((Object)"HASH_ALL", (Object)mountTable.getDestOrder().toString());
        argv = new String[]{"-update", src, "-readonly", "false"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)newNsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)newDest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
        Assert.assertFalse((boolean)mountTable.isReadOnly());
        Assert.assertEquals((Object)"HASH_ALL", (Object)mountTable.getDestOrder().toString());
    }

    @Test
    public void testUpdateErrorCase() throws Exception {
        String nsId = "ns0";
        String src = "/mount";
        String dest = "/dest";
        String[] argv = new String[]{"-add", src, nsId, dest, "-readonly", "-order", "HASH_ALL"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        argv = new String[]{"-update", "/noMount", "-readonly", "false"};
        System.setErr(new PrintStream(this.err));
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((String)this.err.toString(), (boolean)this.err.toString().contains("update: /noMount doesn't exist."));
        this.err.reset();
        argv = new String[]{"-update", src, "-readonly", "check"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((String)this.err.toString(), (boolean)this.err.toString().contains("update: Invalid argument: check. Please specify either true or false."));
        this.err.reset();
        argv = new String[]{"-update", src, "ns1", "/tmp", "-faulttolerant"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((String)this.err.toString(), (boolean)this.err.toString().contains("update: Unable to parse arguments: no value provided for -faulttolerant"));
        this.err.reset();
        argv = new String[]{"-update", src, "ns1", "/tmp", "-order", "Invalid"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((String)this.err.toString(), (boolean)this.err.toString().contains("update: Unable to parse arguments: Cannot parse order: Invalid"));
        this.err.reset();
    }

    @Test
    public void testUpdateReadonlyUserGroupPermissionMountable() throws Exception {
        String nsId = "ns0";
        String src = "/test-updateReadonlyUserGroupPermissionMountTable";
        String dest = "/UpdateReadonlyUserGroupPermissionMountTable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
        Assert.assertFalse((boolean)mountTable.isReadOnly());
        String testOwner = "test_owner";
        String testGroup = "test_group";
        argv = new String[]{"-update", src, nsId, dest, "-readonly", "true", "-owner", testOwner, "-group", testGroup, "-mode", "0455"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
        Assert.assertTrue((boolean)mountTable.isReadOnly());
        Assert.assertEquals((Object)testOwner, (Object)mountTable.getOwnerName());
        Assert.assertEquals((Object)testGroup, (Object)mountTable.getGroupName());
        Assert.assertEquals((long)301L, (long)mountTable.getMode().toShort());
    }

    @Test
    public void testUpdateReadonlyWithQuota() throws Exception {
        String nsId = "ns0";
        String src = "/test-updateReadonlywithQuota";
        String dest = "/UpdateReadonlywithQuota";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        RemoteLocation localDest = (RemoteLocation)mountTable.getDestinations().get(0);
        Assert.assertEquals((Object)nsId, (Object)localDest.getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)localDest.getDest());
        Assert.assertFalse((boolean)mountTable.isReadOnly());
        argv = new String[]{"-update", src, nsId, dest, "-readonly", "true"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertTrue((boolean)mountTable.isReadOnly());
        long nsQuota = 50L;
        long ssQuota = 100L;
        argv = new String[]{"-setQuota", src, "-nsQuota", String.valueOf(nsQuota), "-ssQuota", String.valueOf(ssQuota)};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        RouterQuotaUsage quota = mountTable.getQuota();
        Assert.assertEquals((long)nsQuota, (long)quota.getQuota());
        Assert.assertEquals((long)ssQuota, (long)quota.getSpaceQuota());
        Assert.assertTrue((boolean)mountTable.isReadOnly());
    }

    @Test
    public void testUpdateOrderMountTable() throws Exception {
        this.testUpdateOrderMountTable(DestinationOrder.HASH);
        this.testUpdateOrderMountTable(DestinationOrder.LOCAL);
        this.testUpdateOrderMountTable(DestinationOrder.RANDOM);
        this.testUpdateOrderMountTable(DestinationOrder.HASH_ALL);
        this.testUpdateOrderMountTable(DestinationOrder.SPACE);
    }

    @Test
    public void testOrderErrorMsg() throws Exception {
        String nsId = "ns0";
        DestinationOrder order = DestinationOrder.HASH;
        String src = "/testod" + order.toString();
        String dest = "/testUpd";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
        Assert.assertEquals((Object)DestinationOrder.HASH, (Object)mountTable.getDestOrder());
        argv = new String[]{"-update", src, nsId, dest, "-order", order.toString()};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-update", src + "a", nsId, dest + "a", "-orde", order.toString()};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-update", src, nsId, dest, order.toString()};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
    }

    private void testUpdateOrderMountTable(DestinationOrder order) throws Exception {
        String nsId = "ns0";
        String src = "/test-updateOrderMountTable-" + order.toString();
        String dest = "/UpdateOrderMountTable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
        Assert.assertEquals((Object)DestinationOrder.HASH, (Object)mountTable.getDestOrder());
        argv = new String[]{"-update", src, nsId, dest, "-order", order.toString()};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
        Assert.assertEquals((Object)order, (Object)mountTable.getDestOrder());
    }

    @Test
    public void testGetDestination() throws Exception {
        System.setOut(new PrintStream(this.out));
        String[] argv = new String[]{"-getDestination", "/file.txt"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertEquals((Object)("Destination: ns0" + System.lineSeparator()), (Object)this.out.toString());
        argv = new String[]{"-add", "/testGetDest", "ns0,ns1", "/testGetDestination", "-order", DestinationOrder.HASH_ALL.toString()};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        MountTableResolver resolver = (MountTableResolver)router.getSubclusterResolver();
        resolver.loadCache(true);
        TreeMap<String, AtomicInteger> counter = new TreeMap<String, AtomicInteger>();
        Pattern p = Pattern.compile("Destination: (.*)");
        for (int i = 0; i < 10; ++i) {
            this.out.reset();
            String filename = "file" + i + ".txt";
            argv = new String[]{"-getDestination", "/testGetDest/" + filename};
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
            String outLine = this.out.toString();
            Matcher m = p.matcher(outLine);
            Assert.assertTrue((boolean)m.find());
            String nsId = m.group(1);
            if (counter.containsKey(nsId)) {
                ((AtomicInteger)counter.get(nsId)).getAndIncrement();
                continue;
            }
            counter.put(nsId, new AtomicInteger(1));
        }
        Assert.assertEquals((String)("Wrong counter size: " + counter), (long)2L, (long)counter.size());
        Assert.assertTrue((String)(counter + " should contain ns0"), (boolean)counter.containsKey("ns0"));
        Assert.assertTrue((String)(counter + " should contain ns1"), (boolean)counter.containsKey("ns1"));
        argv = new String[]{"-getDestination"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-getDestination /file1.txt /file2.txt"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
    }

    @Test
    public void testErrorFaultTolerant() throws Exception {
        System.setErr(new PrintStream(this.err));
        String[] argv = new String[]{"-add", "/mntft", "ns01", "/tmp", "-faulttolerant"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((String)this.err.toString(), (boolean)this.err.toString().contains("Invalid entry, fault tolerance requires multiple destinations"));
        this.err.reset();
        System.setErr(new PrintStream(this.err));
        argv = new String[]{"-add", "/mntft", "ns0,ns1", "/tmp", "-order", "HASH", "-faulttolerant"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((String)this.err.toString(), (boolean)this.err.toString().contains("Invalid entry, fault tolerance only supported for ALL order"));
        this.err.reset();
        argv = new String[]{"-add", "/mntft", "ns0,ns1", "/tmp", "-order", "HASH_ALL", "-faulttolerant"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
    }

    @Test
    public void testRefreshCallQueue() throws Exception {
        System.setOut(new PrintStream(this.out));
        System.setErr(new PrintStream(this.err));
        String[] argv = new String[]{"-refreshCallQueue"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains("Refresh call queue successfully"));
        argv = new String[]{};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains("-refreshCallQueue"));
        argv = new String[]{"-refreshCallQueue", "redundant"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.err.toString().contains("No arguments allowed"));
    }

    @Test
    public void testDumpState() throws Exception {
        MockStateStoreDriver driver = new MockStateStoreDriver();
        driver.clearAll();
        driver.put((BaseRecord)MembershipState.newInstance((String)"routerId", (String)"ns1", (String)"ns1-ha1", (String)"cluster1", (String)"block1", (String)"rpc1", (String)"service1", (String)"lifeline1", (String)"https", (String)"nn01", (FederationNamenodeServiceState)FederationNamenodeServiceState.ACTIVE, (boolean)false), false, false);
        driver.put((BaseRecord)MembershipState.newInstance((String)"routerId", (String)"ns1", (String)"ns1-ha2", (String)"cluster1", (String)"block1", (String)"rpc2", (String)"service2", (String)"lifeline2", (String)"https", (String)"nn02", (FederationNamenodeServiceState)FederationNamenodeServiceState.STANDBY, (boolean)false), false, false);
        Configuration conf = new Configuration();
        conf.setClass("dfs.federation.router.store.driver.class", MockStateStoreDriver.class, StateStoreDriver.class);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try (PrintStream stream = new PrintStream(buffer);){
            RouterAdmin.dumpStateStore((Configuration)conf, (PrintStream)stream);
        }
        String expected = "---- DisabledNameservice ----\n\n---- MembershipState ----\n  ns1-ha1-ns1-routerId:\n    dateCreated: XXX\n    dateModified: XXX\n    routerId: \"routerId\"\n    nameserviceId: \"ns1\"\n    namenodeId: \"ns1-ha1\"\n    clusterId: \"cluster1\"\n    blockPoolId: \"block1\"\n    webAddress: \"nn01\"\n    rpcAddress: \"rpc1\"\n    serviceAddress: \"service1\"\n    lifelineAddress: \"lifeline1\"\n    state: \"ACTIVE\"\n    isSafeMode: false\n    webScheme: \"https\"\n    \n  ns1-ha2-ns1-routerId:\n    dateCreated: XXX\n    dateModified: XXX\n    routerId: \"routerId\"\n    nameserviceId: \"ns1\"\n    namenodeId: \"ns1-ha2\"\n    clusterId: \"cluster1\"\n    blockPoolId: \"block1\"\n    webAddress: \"nn02\"\n    rpcAddress: \"rpc2\"\n    serviceAddress: \"service2\"\n    lifelineAddress: \"lifeline2\"\n    state: \"STANDBY\"\n    isSafeMode: false\n    webScheme: \"https\"\n    \n\n---- MountTable ----\n\n---- RouterState ----";
        Assert.assertEquals((Object)"---- DisabledNameservice ----\n\n---- MembershipState ----\n  ns1-ha1-ns1-routerId:\n    dateCreated: XXX\n    dateModified: XXX\n    routerId: \"routerId\"\n    nameserviceId: \"ns1\"\n    namenodeId: \"ns1-ha1\"\n    clusterId: \"cluster1\"\n    blockPoolId: \"block1\"\n    webAddress: \"nn01\"\n    rpcAddress: \"rpc1\"\n    serviceAddress: \"service1\"\n    lifelineAddress: \"lifeline1\"\n    state: \"ACTIVE\"\n    isSafeMode: false\n    webScheme: \"https\"\n    \n  ns1-ha2-ns1-routerId:\n    dateCreated: XXX\n    dateModified: XXX\n    routerId: \"routerId\"\n    nameserviceId: \"ns1\"\n    namenodeId: \"ns1-ha2\"\n    clusterId: \"cluster1\"\n    blockPoolId: \"block1\"\n    webAddress: \"nn02\"\n    rpcAddress: \"rpc2\"\n    serviceAddress: \"service2\"\n    lifelineAddress: \"lifeline2\"\n    state: \"STANDBY\"\n    isSafeMode: false\n    webScheme: \"https\"\n    \n\n---- MountTable ----\n\n---- RouterState ----", (Object)buffer.toString().trim().replaceAll("[0-9]{4,}+", "XXX"));
    }

    private void addMountTable(String src, String nsId, String dst) throws Exception {
        String[] argv = new String[]{"-add", src, nsId, dst};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
    }

    private List<MountTable> getMountTable(String src) throws IOException {
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        return getResponse.getEntries();
    }

    private void setStorageTypeQuota(String src, long ssQuota, StorageType type) throws Exception {
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-setStorageTypeQuota", src, "-storageType", type.name(), String.valueOf(ssQuota)}));
        stateStore.loadCache(MountTableStoreImpl.class, true);
    }

    private void rmMountTable(String src) throws Exception {
        String[] argv = new String[]{"-rm", src};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
    }

    static {
        OLD_OUT = System.out;
        OLD_ERR = System.err;
    }
}

