/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.ClientSideRequestStatistics;
import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.ISessionContainer;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.AddressSelector;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ConsistencyReader;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ConsistencyWriter;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GatewayServiceConfigurationReader;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GoneAndRetryWithRetryPolicy;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.Protocol;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.TimeoutHelper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.TransportClient;
import com.microsoft.azure.cosmosdb.rx.internal.BackoffRetryUtility;
import com.microsoft.azure.cosmosdb.rx.internal.Configs;
import com.microsoft.azure.cosmosdb.rx.internal.IAuthorizationTokenProvider;
import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.ReplicatedResourceClientUtils;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Single;
import rx.functions.Func1;
import rx.functions.Func2;

public class ReplicatedResourceClient {
    private final Logger logger = LoggerFactory.getLogger(ReplicatedResourceClient.class);
    private static final int GONE_AND_RETRY_WITH_TIMEOUT_IN_SECONDS = 30;
    private static final int STRONG_GONE_AND_RETRY_WITH_RETRY_TIMEOUT_SECONDS = 60;
    private static final int MIN_BACKOFF_FOR_FAILLING_BACK_TO_OTHER_REGIONS_FOR_READ_REQUESTS_IN_SECONDS = 1;
    private final AddressSelector addressSelector;
    private final ConsistencyReader consistencyReader;
    private final ConsistencyWriter consistencyWriter;
    private final Protocol protocol;
    private final TransportClient transportClient;
    private final boolean enableReadRequestsFallback;
    private final GatewayServiceConfigurationReader serviceConfigReader;
    private final Configs configs;

    public ReplicatedResourceClient(Configs configs, AddressSelector addressSelector, ISessionContainer sessionContainer, TransportClient transportClient, GatewayServiceConfigurationReader serviceConfigReader, IAuthorizationTokenProvider authorizationTokenProvider, boolean enableReadRequestsFallback, boolean useMultipleWriteLocations) {
        this.configs = configs;
        this.protocol = configs.getProtocol();
        this.addressSelector = addressSelector;
        if (this.protocol != Protocol.Https && this.protocol != Protocol.Tcp) {
            throw new IllegalArgumentException("protocol");
        }
        this.transportClient = transportClient;
        this.serviceConfigReader = serviceConfigReader;
        this.consistencyReader = new ConsistencyReader(configs, this.addressSelector, sessionContainer, transportClient, serviceConfigReader, authorizationTokenProvider);
        this.consistencyWriter = new ConsistencyWriter(this.addressSelector, sessionContainer, transportClient, authorizationTokenProvider, serviceConfigReader, useMultipleWriteLocations);
        this.enableReadRequestsFallback = enableReadRequestsFallback;
    }

    public static boolean isReadingFromMaster(ResourceType resourceType, OperationType operationType) {
        return ReplicatedResourceClientUtils.isReadingFromMaster((ResourceType)resourceType, (OperationType)operationType);
    }

    public static boolean isMasterResource(ResourceType resourceType) {
        return ReplicatedResourceClientUtils.isMasterResource((ResourceType)resourceType);
    }

    public static boolean isGlobalStrongEnabled() {
        return true;
    }

    public Single<StoreResponse> invokeAsync(RxDocumentServiceRequest request, Func1<RxDocumentServiceRequest, Single<RxDocumentServiceRequest>> prepareRequestAsyncDelegate) {
        Func2 mainFuncDelegate = (forceRefreshAndTimeout, documentServiceRequest) -> {
            documentServiceRequest.getHeaders().put("x-ms-client-retry-attempt-count", ((Integer)forceRefreshAndTimeout.getValue3()).toString());
            documentServiceRequest.getHeaders().put("x-ms-remaining-time-in-ms-on-client", Long.toString(((Duration)forceRefreshAndTimeout.getValue2()).toMillis()));
            return this.invokeAsync(request, new TimeoutHelper((Duration)forceRefreshAndTimeout.getValue2()), (Boolean)forceRefreshAndTimeout.getValue1(), (Boolean)forceRefreshAndTimeout.getValue0());
        };
        Func1 funcDelegate = forceRefreshAndTimeout -> {
            if (prepareRequestAsyncDelegate != null) {
                return ((Single)prepareRequestAsyncDelegate.call((Object)request)).flatMap(responseReq -> (Single)mainFuncDelegate.call(forceRefreshAndTimeout, responseReq));
            }
            return (Single)mainFuncDelegate.call(forceRefreshAndTimeout, (Object)request);
        };
        Func1 inBackoffFuncDelegate = null;
        if (request.isReadOnlyRequest() && this.enableReadRequestsFallback) {
            if (request.requestContext.clientSideRequestStatistics == null) {
                request.requestContext.clientSideRequestStatistics = new ClientSideRequestStatistics();
            }
            RxDocumentServiceRequest freshRequest = request.clone();
            inBackoffFuncDelegate = forceRefreshAndTimeout -> {
                RxDocumentServiceRequest readRequestClone = freshRequest.clone();
                if (prepareRequestAsyncDelegate != null) {
                    return ((Single)prepareRequestAsyncDelegate.call((Object)readRequestClone)).flatMap(responseReq -> {
                        this.logger.trace(String.format("Executing inBackoffAlternateCallbackMethod on readRegionIndex {}", forceRefreshAndTimeout.getValue3()));
                        responseReq.requestContext.RouteToLocation(((Integer)forceRefreshAndTimeout.getValue3()).intValue(), true);
                        return this.invokeAsync((RxDocumentServiceRequest)responseReq, new TimeoutHelper((Duration)forceRefreshAndTimeout.getValue2()), (Boolean)forceRefreshAndTimeout.getValue1(), (Boolean)forceRefreshAndTimeout.getValue0());
                    });
                }
                this.logger.trace(String.format("Executing inBackoffAlternateCallbackMethod on readRegionIndex {}", forceRefreshAndTimeout.getValue3()));
                readRequestClone.requestContext.RouteToLocation(((Integer)forceRefreshAndTimeout.getValue3()).intValue(), true);
                return this.invokeAsync(readRequestClone, new TimeoutHelper((Duration)forceRefreshAndTimeout.getValue2()), (Boolean)forceRefreshAndTimeout.getValue1(), (Boolean)forceRefreshAndTimeout.getValue0());
            };
        }
        int retryTimeout = this.serviceConfigReader.getDefaultConsistencyLevel() == ConsistencyLevel.Strong ? 60 : 30;
        return BackoffRetryUtility.executeAsync((Func1)funcDelegate, (IRetryPolicy)new GoneAndRetryWithRetryPolicy(request, retryTimeout), (Func1)inBackoffFuncDelegate, (Duration)Duration.ofSeconds(1L));
    }

    private Single<StoreResponse> invokeAsync(RxDocumentServiceRequest request, TimeoutHelper timeout, boolean isInRetry, boolean forceRefresh) {
        if (request.getOperationType().equals((Object)OperationType.ExecuteJavaScript)) {
            if (request.isReadOnlyScript()) {
                return this.consistencyReader.readAsync(request, timeout, isInRetry, forceRefresh);
            }
            return this.consistencyWriter.writeAsync(request, timeout, forceRefresh);
        }
        if (request.getOperationType().isWriteOperation()) {
            return this.consistencyWriter.writeAsync(request, timeout, forceRefresh);
        }
        if (request.isReadOnlyRequest()) {
            return this.consistencyReader.readAsync(request, timeout, isInRetry, forceRefresh);
        }
        throw new IllegalArgumentException(String.format("Unexpected operation type %s", request.getOperationType()));
    }
}

