/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DeltaJoinSpec;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalDeltaJoin;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalJoin;
import org.apache.flink.table.planner.plan.rules.physical.stream.ImmutableDeltaJoinRewriteRule;
import org.apache.flink.table.planner.plan.utils.DeltaJoinUtil;
import org.apache.flink.table.planner.plan.utils.JoinTypeUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.immutables.value.Value;

@Value.Enclosing
public class DeltaJoinRewriteRule
extends RelRule<Config> {
    public static final DeltaJoinRewriteRule INSTANCE = Config.DEFAULT.toRule();

    private DeltaJoinRewriteRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        TableConfig tableConfig = ShortcutUtils.unwrapTableConfig(call);
        OptimizerConfigOptions.DeltaJoinStrategy deltaJoinStrategy = (OptimizerConfigOptions.DeltaJoinStrategy)tableConfig.get(OptimizerConfigOptions.TABLE_OPTIMIZER_DELTA_JOIN_STRATEGY);
        if (OptimizerConfigOptions.DeltaJoinStrategy.NONE == deltaJoinStrategy) {
            return false;
        }
        StreamPhysicalJoin join = (StreamPhysicalJoin)call.rel(0);
        return DeltaJoinUtil.canConvertToDeltaJoin(join);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        StreamPhysicalJoin join = (StreamPhysicalJoin)call.rel(0);
        StreamPhysicalDeltaJoin deltaJoin = this.convertToDeltaJoin(join);
        call.transformTo(deltaJoin);
    }

    private StreamPhysicalDeltaJoin convertToDeltaJoin(StreamPhysicalJoin join) {
        DeltaJoinSpec lookupRightTableJoinSpec = DeltaJoinUtil.getDeltaJoinSpec(join, true);
        DeltaJoinSpec lookupLeftTableJoinSpec = DeltaJoinUtil.getDeltaJoinSpec(join, false);
        return new StreamPhysicalDeltaJoin(join.getCluster(), join.getTraitSet(), join.getHints(), join.getLeft(), join.getRight(), JoinTypeUtil.getFlinkJoinType(join.getJoinType()), join.getCondition(), lookupRightTableJoinSpec, lookupLeftTableJoinSpec, join.getRowType());
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableDeltaJoinRewriteRule.Config.builder().build().withOperandSupplier(b0 -> b0.operand(StreamPhysicalJoin.class).anyInputs()).withDescription("DeltaJoinRewriteRule");

        @Override
        default public DeltaJoinRewriteRule toRule() {
            return new DeltaJoinRewriteRule(this);
        }
    }
}

