/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.planner.plan.rules.logical.RemoteCalcCallFinder;
import org.apache.flink.table.planner.plan.rules.logical.RemoteCalcExpandProjectRule;
import org.apache.flink.table.planner.plan.rules.logical.RemoteCalcPushConditionRule;
import org.apache.flink.table.planner.plan.rules.logical.RemoteCalcRewriteProjectionRule;
import org.apache.flink.table.planner.plan.rules.logical.RemoteCalcSplitConditionRexFieldRule;
import org.apache.flink.table.planner.plan.rules.logical.RemoteCalcSplitConditionRule;
import org.apache.flink.table.planner.plan.rules.logical.RemoteCalcSplitProjectionRexFieldRule;
import org.apache.flink.table.planner.plan.rules.logical.RemoteCalcSplitProjectionRule;
import org.apache.flink.table.planner.plan.rules.logical.RemoteCalcSplitProjectionRuleBase;
import org.apache.flink.table.planner.plan.rules.logical.RemoteCalcSplitRuleBase;
import org.apache.flink.table.planner.plan.rules.logical.ScalarFunctionSplitter;
import org.apache.flink.table.planner.plan.rules.logical.SplitComponents;
import org.apache.flink.table.planner.plan.rules.logical.SplitRemoteConditionFromJoinRule;
import org.apache.flink.table.planner.plan.utils.AsyncScalarUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import scala.Option;

public class AsyncCalcSplitRule {
    private static final RemoteCalcCallFinder ASYNC_CALL_FINDER = new AsyncRemoteCalcCallFinder();
    public static final RelOptRule SPLIT_CONDITION = new RemoteCalcSplitConditionRule(ASYNC_CALL_FINDER);
    public static final RelOptRule SPLIT_PROJECT = new RemoteCalcSplitProjectionRule(ASYNC_CALL_FINDER);
    public static final RelOptRule SPLIT_PROJECTION_REX_FIELD = new RemoteCalcSplitProjectionRexFieldRule(ASYNC_CALL_FINDER);
    public static final RelOptRule SPLIT_CONDITION_REX_FIELD = new RemoteCalcSplitConditionRexFieldRule(ASYNC_CALL_FINDER);
    public static final RelOptRule EXPAND_PROJECT = new RemoteCalcExpandProjectRule(ASYNC_CALL_FINDER);
    public static final RelOptRule PUSH_CONDITION = new RemoteCalcPushConditionRule(ASYNC_CALL_FINDER);
    public static final RelOptRule REWRITE_PROJECT = new RemoteCalcRewriteProjectionRule(ASYNC_CALL_FINDER);
    public static final RelOptRule NESTED_SPLIT = new AsyncCalcSplitNestedRule(ASYNC_CALL_FINDER);
    public static final RelOptRule ONE_PER_CALC_SPLIT = new AsyncCalcSplitOnePerCalcRule(ASYNC_CALL_FINDER);
    public static final RelOptRule NO_ASYNC_JOIN_CONDITIONS = new SplitRemoteConditionFromJoinRule(ASYNC_CALL_FINDER, JavaScalaConversionUtil.toScala(Optional.of("AsyncScalarFunction not supported for non inner join condition")));

    private static boolean hasNestedCalls(List<RexNode> projects) {
        return projects.stream().filter(AsyncScalarUtil::containsAsyncCall).filter(expr -> expr instanceof RexCall).map(expr -> (RexCall)expr).anyMatch(rexCall -> rexCall.getOperands().stream().anyMatch(AsyncScalarUtil::containsAsyncCall));
    }

    public static class AsyncCalcSplitOnePerCalcRule
    extends RemoteCalcSplitProjectionRuleBase<State> {
        public AsyncCalcSplitOnePerCalcRule(RemoteCalcCallFinder callFinder) {
            super("AsyncCalcSplitOnePerCalcRule", callFinder);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(RelOptRuleCall call) {
            FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
            List<RexNode> projects = calc.getProgram().getProjectList().stream().map(calc.getProgram()::expandLocalRef).collect(Collectors.toList());
            if (AsyncCalcSplitRule.hasNestedCalls(projects)) return false;
            if (projects.stream().filter(this.callFinder()::containsRemoteCall).count() < 2L) return false;
            return true;
        }

        @Override
        public boolean needConvert(RexProgram program, RexNode node, Option<State> matchState) {
            if (AsyncScalarUtil.containsAsyncCall(node) && !((State)matchState.get()).foundMatch) {
                ((State)matchState.get()).foundMatch = true;
                return true;
            }
            return false;
        }

        @Override
        public Option<State> getMatchState() {
            return Option.apply((Object)new State());
        }

        public static class State {
            boolean foundMatch = false;
        }
    }

    public static class AsyncCalcSplitNestedRule
    extends RemoteCalcSplitRuleBase<Void> {
        public AsyncCalcSplitNestedRule(RemoteCalcCallFinder callFinder) {
            super("AsyncCalcSplitNestedRule", callFinder);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
            List<RexNode> projects = calc.getProgram().getProjectList().stream().map(calc.getProgram()::expandLocalRef).collect(Collectors.toList());
            return AsyncCalcSplitRule.hasNestedCalls(projects);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean needConvert(RexProgram program, RexNode node, Option<Void> matchState) {
            if (!(node instanceof RexCall)) return false;
            if (((RexCall)node).getOperands().stream().anyMatch(this.callFinder()::containsRemoteCall)) return false;
            return true;
        }

        @Override
        public SplitComponents split(RexProgram program, ScalarFunctionSplitter splitter) {
            return new SplitComponents(JavaScalaConversionUtil.toScala(Optional.empty()), JavaScalaConversionUtil.toScala(Optional.ofNullable(program.getCondition()).map(program::expandLocalRef)), JavaScalaConversionUtil.toScala(program.getProjectList().stream().map(program::expandLocalRef).map(n -> n.accept(splitter)).collect(Collectors.toList())));
        }
    }

    public static class AsyncRemoteCalcCallFinder
    implements RemoteCalcCallFinder {
        @Override
        public boolean containsRemoteCall(RexNode node) {
            return AsyncScalarUtil.containsAsyncCall(node);
        }

        @Override
        public boolean containsNonRemoteCall(RexNode node) {
            return AsyncScalarUtil.containsNonAsyncCall(node);
        }

        @Override
        public boolean isRemoteCall(RexNode node) {
            return AsyncScalarUtil.isAsyncCall(node);
        }

        @Override
        public boolean isNonRemoteCall(RexNode node) {
            return AsyncScalarUtil.isNonAsyncCall(node);
        }

        @Override
        public String getName() {
            return "Async";
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

