/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.client.models;

import com.google.gson.annotations.SerializedName;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.fineract.client.models.Header;

public class BatchRequest {
    public static final String SERIALIZED_NAME_BODY = "body";
    @SerializedName(value="body")
    private String body;
    public static final String SERIALIZED_NAME_HEADERS = "headers";
    @SerializedName(value="headers")
    private Set<Header> headers;
    public static final String SERIALIZED_NAME_METHOD = "method";
    @SerializedName(value="method")
    private String method;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private Long reference;
    public static final String SERIALIZED_NAME_RELATIVE_URL = "relativeUrl";
    @SerializedName(value="relativeUrl")
    private String relativeUrl;
    public static final String SERIALIZED_NAME_REQUEST_ID = "requestId";
    @SerializedName(value="requestId")
    private Long requestId;

    public BatchRequest body(String body) {
        this.body = body;
        return this;
    }

    @Nullable
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public BatchRequest headers(Set<Header> headers) {
        this.headers = headers;
        return this;
    }

    public BatchRequest addHeadersItem(Header headersItem) {
        if (this.headers == null) {
            this.headers = new LinkedHashSet<Header>();
        }
        this.headers.add(headersItem);
        return this;
    }

    @Nullable
    public Set<Header> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Set<Header> headers) {
        this.headers = headers;
    }

    public BatchRequest method(String method) {
        this.method = method;
        return this;
    }

    @Nullable
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public BatchRequest reference(Long reference) {
        this.reference = reference;
        return this;
    }

    @Nullable
    public Long getReference() {
        return this.reference;
    }

    public void setReference(Long reference) {
        this.reference = reference;
    }

    public BatchRequest relativeUrl(String relativeUrl) {
        this.relativeUrl = relativeUrl;
        return this;
    }

    @Nullable
    public String getRelativeUrl() {
        return this.relativeUrl;
    }

    public void setRelativeUrl(String relativeUrl) {
        this.relativeUrl = relativeUrl;
    }

    public BatchRequest requestId(Long requestId) {
        this.requestId = requestId;
        return this;
    }

    @Nullable
    public Long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchRequest batchRequest = (BatchRequest)o;
        return Objects.equals(this.body, batchRequest.body) && Objects.equals(this.headers, batchRequest.headers) && Objects.equals(this.method, batchRequest.method) && Objects.equals(this.reference, batchRequest.reference) && Objects.equals(this.relativeUrl, batchRequest.relativeUrl) && Objects.equals(this.requestId, batchRequest.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.headers, this.method, this.reference, this.relativeUrl, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchRequest {\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    relativeUrl: ").append(this.toIndentedString(this.relativeUrl)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

