/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.meeting.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstance;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstanceRepository;
import org.apache.fineract.portfolio.calendar.domain.CalendarRepository;
import org.apache.fineract.portfolio.calendar.exception.CalendarInstanceNotFoundException;
import org.apache.fineract.portfolio.calendar.exception.CalendarNotFoundException;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepository;
import org.apache.fineract.portfolio.group.exception.ClientNotInGroupException;
import org.apache.fineract.portfolio.meeting.attendance.domain.ClientAttendance;
import org.apache.fineract.portfolio.meeting.data.MeetingDataValidator;
import org.apache.fineract.portfolio.meeting.domain.Meeting;
import org.apache.fineract.portfolio.meeting.domain.MeetingRepository;
import org.apache.fineract.portfolio.meeting.domain.MeetingRepositoryWrapper;
import org.apache.fineract.portfolio.meeting.service.MeetingWritePlatformService;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;

public class MeetingWritePlatformServiceJpaRepositoryImpl
implements MeetingWritePlatformService {
    private final MeetingRepositoryWrapper meetingRepositoryWrapper;
    private final MeetingRepository meetingRepository;
    private final MeetingDataValidator meetingDataValidator;
    private final CalendarInstanceRepository calendarInstanceRepository;
    private final CalendarRepository calendarRepository;
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final GroupRepository groupRepository;
    private final FromJsonHelper fromApiJsonHelper;
    private final ConfigurationDomainService configurationDomainService;

    public CommandProcessingResult createMeeting(JsonCommand command) {
        this.meetingDataValidator.validateForCreate(command);
        LocalDate meetingDate = command.dateValueOfParameterNamed("meetingDate");
        Boolean isTransactionDateOnNonMeetingDate = false;
        try {
            Meeting newMeeting;
            Collection clientsAttendance;
            CalendarInstance calendarInstance = this.getCalendarInstance(command);
            Boolean isSkipRepaymentOnFirstMonth = false;
            Integer numberOfDays = 0;
            boolean isSkipRepaymentOnFirstMonthEnabled = this.configurationDomainService.isSkippingMeetingOnFirstDayOfMonthEnabled();
            if (isSkipRepaymentOnFirstMonthEnabled) {
                if (calendarInstance != null) {
                    isSkipRepaymentOnFirstMonth = true;
                }
                if (isSkipRepaymentOnFirstMonth.booleanValue()) {
                    numberOfDays = this.configurationDomainService.retreivePeriodInNumberOfDaysForSkipMeetingDate().intValue();
                }
            }
            if ((clientsAttendance = this.getClientsAttendance(newMeeting = Meeting.createNew((CalendarInstance)calendarInstance, (LocalDate)meetingDate, (Boolean)isTransactionDateOnNonMeetingDate, (boolean)isSkipRepaymentOnFirstMonth, (int)numberOfDays), command)) != null && !clientsAttendance.isEmpty()) {
                newMeeting.associateClientsAttendance(clientsAttendance);
            }
            this.meetingRepositoryWrapper.saveAndFlush(newMeeting);
            Long groupId = newMeeting.isGroupEntity() ? newMeeting.entityId() : null;
            return new CommandProcessingResultBuilder().withEntityId((Long)newMeeting.getId()).withGroupId(groupId).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleMeetingDataIntegrityIssues(meetingDate, throwable, (Exception)dve);
            return new CommandProcessingResultBuilder().build();
        }
    }

    private CalendarInstance getCalendarInstance(JsonCommand command) {
        Long calendarId = command.longValueOfParameterNamed("calendarId");
        Calendar calendarForUpdate = (Calendar)this.calendarRepository.findById((Object)calendarId).orElseThrow(() -> new CalendarNotFoundException(calendarId));
        Long entityId = null;
        CalendarEntityType entityType = CalendarEntityType.INVALID;
        if (command.getLoanId() != null) {
            entityId = command.getLoanId();
            entityType = CalendarEntityType.LOANS;
        } else if (command.getClientId() != null) {
            entityId = command.getClientId();
            entityType = CalendarEntityType.CLIENTS;
        } else if (command.getGroupId() != null) {
            entityId = command.getGroupId();
            entityType = CalendarEntityType.GROUPS;
            Group group = (Group)this.groupRepository.findById((Object)entityId).orElseThrow();
            if (group.isCenter()) {
                entityType = CalendarEntityType.CENTERS;
            } else if (group.isChildGroup()) {
                entityType = CalendarEntityType.CENTERS;
                entityId = (Long)group.getParent().getId();
            }
        }
        CalendarInstance calendarInstance = this.calendarInstanceRepository.findByCalendarIdAndEntityIdAndEntityTypeId((Long)calendarForUpdate.getId(), entityId, entityType.getValue());
        if (calendarInstance == null) {
            String postFix = "for." + entityType.name().toLowerCase() + "not.found";
            String defaultUserMessage = "No Calendar Instance details found for group with identifier " + entityId + " and calendar with identifier " + calendarId;
            throw new CalendarInstanceNotFoundException(postFix, defaultUserMessage, new Object[]{entityId, calendarId});
        }
        return calendarInstance;
    }

    private Collection<ClientAttendance> getClientsAttendance(Meeting meeting, JsonCommand command) {
        ArrayList<ClientAttendance> clientsAttendance = new ArrayList<ClientAttendance>();
        Collection childGroups = null;
        if (meeting.isCenterEntity()) {
            childGroups = this.groupRepository.findByParentId(meeting.entityId());
        }
        String json = command.json();
        JsonElement element = this.fromApiJsonHelper.parse(json);
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        if (element.isJsonObject() && topLevelJsonElement.has("clientsAttendance") && topLevelJsonElement.get("clientsAttendance").isJsonArray()) {
            JsonArray array = topLevelJsonElement.get("clientsAttendance").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject attendanceElement = array.get(i).getAsJsonObject();
                Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", (JsonElement)attendanceElement);
                Integer attendanceTypeId = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("attendanceType", (JsonElement)attendanceElement);
                Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId, true);
                if (meeting.isGroupEntity() && !client.isChildOfGroup(meeting.entityId())) {
                    throw new ClientNotInGroupException(clientId, meeting.entityId());
                }
                if (meeting.isCenterEntity() && childGroups != null && !childGroups.isEmpty()) {
                    boolean isChildClient = false;
                    for (Group group : childGroups) {
                        if (!group.isChildClient(clientId)) continue;
                        isChildClient = true;
                        break;
                    }
                    if (!isChildClient) {
                        String defaultUserMessage = "Client with identifier " + clientId + " is not in center " + meeting.entityId();
                        throw new ClientNotInGroupException("client.not.in.center", defaultUserMessage, new Object[]{clientId, meeting.entityId()});
                    }
                }
                ClientAttendance clientAttendance = ClientAttendance.createClientAttendance((Client)client, (Meeting)meeting, (Integer)attendanceTypeId);
                clientsAttendance.add(clientAttendance);
            }
        }
        return clientsAttendance;
    }

    public CommandProcessingResult updateMeeting(JsonCommand command) {
        this.meetingDataValidator.validateForUpdate(command);
        CalendarInstance calendarInstance = this.getCalendarInstance(command);
        Boolean isSkipRepaymentOnFirstMonth = false;
        Integer numberOfDays = 0;
        boolean isSkipRepaymentOnFirstMonthEnabled = this.configurationDomainService.isSkippingMeetingOnFirstDayOfMonthEnabled();
        if (isSkipRepaymentOnFirstMonthEnabled && calendarInstance != null) {
            isSkipRepaymentOnFirstMonth = true;
            numberOfDays = this.configurationDomainService.retreivePeriodInNumberOfDaysForSkipMeetingDate().intValue();
        }
        Meeting meetingForUpdate = this.meetingRepositoryWrapper.findOneWithNotFoundDetection(command.entityId());
        Map changes = meetingForUpdate.update(command, isSkipRepaymentOnFirstMonth.booleanValue(), numberOfDays.intValue());
        try {
            if (!changes.isEmpty()) {
                this.meetingRepositoryWrapper.saveAndFlush(meetingForUpdate);
            }
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleMeetingDataIntegrityIssues(meetingForUpdate.getMeetingDate(), throwable, (Exception)dve);
            return new CommandProcessingResultBuilder().build();
        }
        Long groupId = meetingForUpdate.isGroupEntity() ? meetingForUpdate.entityId() : null;
        return new CommandProcessingResultBuilder().withEntityId((Long)meetingForUpdate.getId()).withGroupId(groupId).with(changes).build();
    }

    public CommandProcessingResult deleteMeeting(Long meetingId) {
        Meeting meetingForDelete = this.meetingRepositoryWrapper.findOneWithNotFoundDetection(meetingId);
        this.meetingRepositoryWrapper.delete(meetingForDelete);
        return new CommandProcessingResultBuilder().withEntityId(meetingId).build();
    }

    public CommandProcessingResult saveOrUpdateAttendance(JsonCommand command) {
        this.meetingDataValidator.validateForUpdateAttendance(command);
        Meeting meetingForUpdate = this.meetingRepositoryWrapper.findOneWithNotFoundDetection(command.entityId());
        Collection clientsAttendance = this.getClientsAttendance(meetingForUpdate, command);
        Map changes = meetingForUpdate.updateAttendance(clientsAttendance);
        this.meetingRepositoryWrapper.saveAndFlush(meetingForUpdate);
        Long groupId = meetingForUpdate.isGroupEntity() ? meetingForUpdate.entityId() : null;
        return new CommandProcessingResultBuilder().withEntityId((Long)meetingForUpdate.getId()).withGroupId(groupId).with(changes).build();
    }

    private void handleMeetingDataIntegrityIssues(LocalDate meetingDate, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("unique_calendar_instance_id_meeting_date")) {
            throw new PlatformDataIntegrityException("error.msg.meeting.duplicate", "A meeting with date '" + String.valueOf(meetingDate) + "' already exists", "meetingDate", new Object[]{meetingDate});
        }
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.meeting.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    public void updateCollectionSheetAttendance(JsonCommand command) {
        LocalDate meetingDate = command.dateValueOfParameterNamed("transactionDate");
        Boolean isTransactionDateOnNonMeetingDate = command.booleanPrimitiveValueOfParameterNamed("isTransactionDateOnNonMeetingDate");
        try {
            Meeting newMeeting;
            Collection clientsAttendance;
            CalendarInstance calendarInstance = this.getCalendarInstance(command);
            Meeting meeting = this.meetingRepository.findByCalendarInstanceIdAndMeetingDate((Long)calendarInstance.getId(), meetingDate);
            Boolean isSkipRepaymentOnFirstMonth = false;
            Integer numberOfDays = 0;
            boolean isSkipRepaymentOnFirstMonthEnabled = this.configurationDomainService.isSkippingMeetingOnFirstDayOfMonthEnabled();
            if (isSkipRepaymentOnFirstMonthEnabled && (isSkipRepaymentOnFirstMonth = Boolean.valueOf(true)).booleanValue()) {
                numberOfDays = this.configurationDomainService.retreivePeriodInNumberOfDaysForSkipMeetingDate().intValue();
            }
            if ((clientsAttendance = this.getClientsAttendance(newMeeting = meeting != null ? meeting : Meeting.createNew((CalendarInstance)calendarInstance, (LocalDate)meetingDate, (Boolean)isTransactionDateOnNonMeetingDate, (boolean)isSkipRepaymentOnFirstMonth, (int)numberOfDays), command)) != null && !clientsAttendance.isEmpty()) {
                newMeeting.updateAttendance(clientsAttendance);
            }
            this.meetingRepositoryWrapper.save(newMeeting);
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleMeetingDataIntegrityIssues(meetingDate, throwable, (Exception)dve);
        }
    }

    @Generated
    public MeetingWritePlatformServiceJpaRepositoryImpl(MeetingRepositoryWrapper meetingRepositoryWrapper, MeetingRepository meetingRepository, MeetingDataValidator meetingDataValidator, CalendarInstanceRepository calendarInstanceRepository, CalendarRepository calendarRepository, ClientRepositoryWrapper clientRepositoryWrapper, GroupRepository groupRepository, FromJsonHelper fromApiJsonHelper, ConfigurationDomainService configurationDomainService) {
        this.meetingRepositoryWrapper = meetingRepositoryWrapper;
        this.meetingRepository = meetingRepository;
        this.meetingDataValidator = meetingDataValidator;
        this.calendarInstanceRepository = calendarInstanceRepository;
        this.calendarRepository = calendarRepository;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
        this.groupRepository = groupRepository;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.configurationDomainService = configurationDomainService;
    }
}

