/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanproduct.productmix.service;

import java.util.Collection;
import java.util.Map;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.loanproduct.productmix.data.ProductMixData;
import org.apache.fineract.portfolio.loanproduct.productmix.exception.ProductMixNotFoundException;
import org.apache.fineract.portfolio.loanproduct.productmix.service.ProductMixReadPlatformService;
import org.apache.fineract.portfolio.loanproduct.productmix.service.ProductMixReadPlatformServiceImpl;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Service;

@Service
public class ProductMixReadPlatformServiceImpl
implements ProductMixReadPlatformService {
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private final LoanProductReadPlatformService loanProductReadPlatformService;

    @Autowired
    public ProductMixReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, LoanProductReadPlatformService loanProductReadPlatformService) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.loanProductReadPlatformService = loanProductReadPlatformService;
    }

    public ProductMixData retrieveLoanProductMixDetails(Long productId) {
        try {
            this.context.authenticatedUser();
            ProductMixDataExtractor extractor = new ProductMixDataExtractor(this.loanProductReadPlatformService, productId);
            String sql = "Select " + extractor.schema() + " where pm.product_id=?";
            Map productMixData = (Map)this.jdbcTemplate.query(sql, (ResultSetExtractor)extractor, new Object[]{productId});
            return (ProductMixData)productMixData.get(productId);
        }
        catch (EmptyResultDataAccessException e) {
            throw new ProductMixNotFoundException(productId, e);
        }
    }

    public Collection<ProductMixData> retrieveAllProductMixes() {
        this.context.authenticatedUser();
        ProductMixDataExtractor extractor = new ProductMixDataExtractor(this.loanProductReadPlatformService, null);
        String sql = "Select " + extractor.schema();
        Map productMixData = (Map)this.jdbcTemplate.query(sql, (ResultSetExtractor)extractor);
        return productMixData.values();
    }
}

