/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.calendar.service;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.calendar.CalendarConstants;
import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarHistory;
import org.apache.fineract.portfolio.calendar.domain.CalendarHistoryRepository;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstance;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstanceRepository;
import org.apache.fineract.portfolio.calendar.domain.CalendarRepository;
import org.apache.fineract.portfolio.calendar.domain.CalendarType;
import org.apache.fineract.portfolio.calendar.exception.CalendarNotFoundException;
import org.apache.fineract.portfolio.calendar.serialization.CalendarCommandFromApiJsonDeserializer;
import org.apache.fineract.portfolio.calendar.service.CalendarWritePlatformService;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.apache.fineract.portfolio.loanaccount.service.LoanWritePlatformService;
import org.springframework.util.CollectionUtils;

public class CalendarWritePlatformServiceJpaRepositoryImpl
implements CalendarWritePlatformService {
    private final CalendarRepository calendarRepository;
    private final CalendarHistoryRepository calendarHistoryRepository;
    private final CalendarCommandFromApiJsonDeserializer fromApiJsonDeserializer;
    private final CalendarInstanceRepository calendarInstanceRepository;
    private final LoanWritePlatformService loanWritePlatformService;
    private final ConfigurationDomainService configurationDomainService;
    private final GroupRepositoryWrapper groupRepository;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final ClientRepositoryWrapper clientRepository;

    public CommandProcessingResult createCalendar(JsonCommand command) {
        this.fromApiJsonDeserializer.validateForCreate(command.json());
        Long entityId = null;
        CalendarEntityType entityType = CalendarEntityType.INVALID;
        LocalDate entityActivationDate = null;
        Group centerOrGroup = null;
        if (command.getGroupId() != null) {
            centerOrGroup = this.groupRepository.findOneWithNotFoundDetection(command.getGroupId());
            entityActivationDate = centerOrGroup.getActivationDate();
            entityType = centerOrGroup.isCenter() ? CalendarEntityType.CENTERS : CalendarEntityType.GROUPS;
            entityId = command.getGroupId();
        } else if (command.getLoanId() != null) {
            Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(command.getLoanId(), true);
            entityActivationDate = loan.getApprovedOnDate() == null ? loan.getSubmittedOnDate() : loan.getApprovedOnDate();
            entityType = CalendarEntityType.LOANS;
            entityId = command.getLoanId();
        } else if (command.getClientId() != null) {
            Client client = this.clientRepository.findOneWithNotFoundDetection(command.getClientId());
            entityActivationDate = client.getActivationDate();
            entityType = CalendarEntityType.CLIENTS;
            entityId = command.getClientId();
        }
        Integer entityTypeId = entityType.getValue();
        Calendar newCalendar = Calendar.fromJson((JsonCommand)command);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("calendar");
        if (entityActivationDate == null || DateUtils.isBefore((LocalDate)newCalendar.getStartDateLocalDate(), (LocalDate)entityActivationDate)) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(command.extractLocale());
            String dateAsString = "";
            if (entityActivationDate != null) {
                dateAsString = formatter.format(entityActivationDate);
            }
            String errorMessage = "cannot.be.before." + entityType.name().toLowerCase() + ".activation.date";
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.START_DATE.getValue()).value((Object)dateAsString).failWithCodeNoParameterAddedToErrorCode(errorMessage, new Object[0]);
        }
        if (centerOrGroup != null) {
            CalendarInstance collectionCalendarInstance;
            Long centerOrGroupId = (Long)centerOrGroup.getId();
            Integer centerOrGroupEntityTypeId = entityType.getValue();
            Group parent = centerOrGroup.getParent();
            if (parent != null) {
                centerOrGroupId = (Long)parent.getId();
                centerOrGroupEntityTypeId = CalendarEntityType.CENTERS.getValue();
            }
            if ((collectionCalendarInstance = this.calendarInstanceRepository.findByEntityIdAndEntityTypeIdAndCalendarTypeId(centerOrGroupId, centerOrGroupEntityTypeId, CalendarType.COLLECTION.getValue())) != null) {
                String errorMessage = "multiple.collection.calendar.not.supported";
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("multiple.collection.calendar.not.supported", new Object[0]);
            }
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        this.calendarRepository.saveAndFlush((Object)newCalendar);
        CalendarInstance newCalendarInstance = CalendarInstance.from((Calendar)newCalendar, (Long)entityId, (Integer)entityTypeId);
        this.calendarInstanceRepository.save(newCalendarInstance);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)newCalendar.getId()).withClientId(command.getClientId()).withGroupId(command.getGroupId()).withLoanId(command.getLoanId()).build();
    }

    public void validateIsEditMeetingAllowed(Long groupId) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("calendar");
        Group centerOrGroup = null;
        if (groupId != null) {
            centerOrGroup = this.groupRepository.findOneWithNotFoundDetection(groupId);
            Group parent = centerOrGroup.getParent();
            if (centerOrGroup.isGroup() && parent != null) {
                Integer centerEntityTypeId = CalendarEntityType.CENTERS.getValue();
                CalendarInstance collectionCalendarInstance = this.calendarInstanceRepository.findByEntityIdAndEntityTypeIdAndCalendarTypeId((Long)parent.getId(), centerEntityTypeId, CalendarType.COLLECTION.getValue());
                if (collectionCalendarInstance != null) {
                    String errorMessage = "meeting.created.at.center.cannot.be.edited.at.group.level";
                    baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("meeting.created.at.center.cannot.be.edited.at.group.level", new Object[0]);
                }
            }
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    public CommandProcessingResult updateCalendar(JsonCommand command) {
        this.validateIsEditMeetingAllowed(command.getGroupId());
        this.fromApiJsonDeserializer.validateForUpdate(command.json());
        Boolean areActiveEntitiesSynced = false;
        Long calendarId = command.entityId();
        ArrayList<LoanStatus> loanStatuses = new ArrayList<LoanStatus>(Arrays.asList(LoanStatus.SUBMITTED_AND_PENDING_APPROVAL, LoanStatus.APPROVED, LoanStatus.ACTIVE));
        Integer numberOfActiveLoansSyncedWithThisCalendar = this.calendarInstanceRepository.countOfLoansSyncedWithCalendar(calendarId, loanStatuses);
        if (numberOfActiveLoansSyncedWithThisCalendar > 0) {
            areActiveEntitiesSynced = true;
        }
        Calendar calendarForUpdate = (Calendar)this.calendarRepository.findById((Object)calendarId).orElseThrow(() -> new CalendarNotFoundException(calendarId));
        LocalDate oldStartDate = calendarForUpdate.getStartDate();
        CalendarHistory calendarHistory = new CalendarHistory(calendarForUpdate, oldStartDate);
        Map changes = null;
        Boolean reschedulebasedOnMeetingDates = command.booleanObjectValueOfParameterNamed(CalendarConstants.CalendarSupportedParameters.RESCHEDULE_BASED_ON_MEETING_DATES.getValue());
        LocalDate newMeetingDate = null;
        LocalDate presentMeetingDate = null;
        if (reschedulebasedOnMeetingDates != null && reschedulebasedOnMeetingDates.booleanValue()) {
            newMeetingDate = command.localDateValueOfParameterNamed(CalendarConstants.CalendarSupportedParameters.NEW_MEETING_DATE.getValue());
            presentMeetingDate = command.localDateValueOfParameterNamed(CalendarConstants.CalendarSupportedParameters.PRESENT_MEETING_DATE.getValue());
            changes = calendarForUpdate.updateStartDateAndDerivedFeilds(newMeetingDate);
        } else {
            changes = calendarForUpdate.update(command, areActiveEntitiesSynced);
        }
        if (!changes.isEmpty()) {
            Collection loanCalendarInstances;
            if (reschedulebasedOnMeetingDates == null) {
                presentMeetingDate = command.localDateValueOfParameterNamed(CalendarConstants.CalendarSupportedParameters.START_DATE.getValue());
            }
            if (null != newMeetingDate) {
                LocalDate endDate = presentMeetingDate.minusDays(1L);
                calendarHistory.updateEndDate(endDate);
            }
            this.calendarHistoryRepository.save((Object)calendarHistory);
            Set history = calendarForUpdate.getCalendarHistory();
            history.add(calendarHistory);
            calendarForUpdate.updateCalendarHistory(history);
            this.calendarRepository.saveAndFlush((Object)calendarForUpdate);
            if (this.configurationDomainService.isRescheduleFutureRepaymentsEnabled() && calendarForUpdate.isRepeating() && !CollectionUtils.isEmpty((Collection)(loanCalendarInstances = this.calendarInstanceRepository.findByCalendarIdAndEntityTypeId(calendarId, CalendarEntityType.LOANS.getValue())))) {
                this.loanWritePlatformService.applyMeetingDateChanges(calendarForUpdate, loanCalendarInstances, reschedulebasedOnMeetingDates, presentMeetingDate, newMeetingDate);
            }
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)calendarForUpdate.getId()).with(changes).build();
    }

    public CommandProcessingResult deleteCalendar(Long calendarId) {
        Calendar calendarForDelete = (Calendar)this.calendarRepository.findById((Object)calendarId).orElseThrow(() -> new CalendarNotFoundException(calendarId));
        this.calendarRepository.delete((Object)calendarForDelete);
        return new CommandProcessingResultBuilder().withCommandId(null).withEntityId(calendarId).build();
    }

    public CommandProcessingResult createCalendarInstance(Long calendarId, Long entityId, Integer entityTypeId) {
        Calendar calendarForUpdate = (Calendar)this.calendarRepository.findById((Object)calendarId).orElseThrow(() -> new CalendarNotFoundException(calendarId));
        CalendarInstance newCalendarInstance = new CalendarInstance(calendarForUpdate, entityId, entityTypeId);
        this.calendarInstanceRepository.save(newCalendarInstance);
        return new CommandProcessingResultBuilder().withCommandId(null).withEntityId((Long)calendarForUpdate.getId()).build();
    }

    public CommandProcessingResult updateCalendarInstance(Long calendarId, Long entityId, Integer entityTypeId) {
        Calendar calendarForUpdate = (Calendar)this.calendarRepository.findById((Object)calendarId).orElseThrow(() -> new CalendarNotFoundException(calendarId));
        CalendarInstance calendarInstanceForUpdate = this.calendarInstanceRepository.findByCalendarIdAndEntityIdAndEntityTypeId(calendarId, entityId, entityTypeId);
        this.calendarInstanceRepository.saveAndFlush(calendarInstanceForUpdate);
        return new CommandProcessingResultBuilder().withCommandId(null).withEntityId((Long)calendarForUpdate.getId()).build();
    }

    @Generated
    public CalendarWritePlatformServiceJpaRepositoryImpl(CalendarRepository calendarRepository, CalendarHistoryRepository calendarHistoryRepository, CalendarCommandFromApiJsonDeserializer fromApiJsonDeserializer, CalendarInstanceRepository calendarInstanceRepository, LoanWritePlatformService loanWritePlatformService, ConfigurationDomainService configurationDomainService, GroupRepositoryWrapper groupRepository, LoanRepositoryWrapper loanRepositoryWrapper, ClientRepositoryWrapper clientRepository) {
        this.calendarRepository = calendarRepository;
        this.calendarHistoryRepository = calendarHistoryRepository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.calendarInstanceRepository = calendarInstanceRepository;
        this.loanWritePlatformService = loanWritePlatformService;
        this.configurationDomainService = configurationDomainService;
        this.groupRepository = groupRepository;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.clientRepository = clientRepository;
    }
}

