/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.service.export;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableExportTargetParameter;
import org.apache.fineract.infrastructure.dataqueries.service.ReadReportingService;
import org.apache.fineract.infrastructure.dataqueries.service.export.DatatableExportUtil;
import org.apache.fineract.infrastructure.dataqueries.service.export.DatatableReportExportService;
import org.apache.fineract.infrastructure.dataqueries.service.export.ResponseHolder;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;

public class S3DatatableReportExportServiceImpl
implements DatatableReportExportService {
    public static final int AWS_S3_MAXIMUM_KEY_LENGTH = 1024;
    private final ReadReportingService readExtraDataAndReportingService;
    private final ConfigurationDomainService configurationDomainService;
    private final S3Client s3Client;
    private final FineractProperties properties;

    public ResponseHolder export(String reportName, MultivaluedMap<String, String> queryParams, Map<String, String> reportParams, boolean isSelfServiceUserReport, String parameterTypeValue) {
        ResponseHolder responseHolder;
        StreamingOutput output = this.readExtraDataAndReportingService.retrieveReportCSV(reportName, parameterTypeValue, reportParams, isSelfServiceUserReport);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            output.write((OutputStream)byteArrayOutputStream);
            String folder = this.configurationDomainService.retrieveReportExportS3FolderName();
            String filePath = DatatableExportUtil.generateS3DatatableExportFileName((int)1024, (String)folder, (String)"csv", (String)reportName, reportParams);
            this.s3Client.putObject(builder -> builder.bucket(this.properties.getReport().getExport().getS3().getBucketName()).key(filePath).build(), RequestBody.fromBytes((byte[])byteArrayOutputStream.toByteArray()));
            responseHolder = new ResponseHolder(Response.Status.NO_CONTENT);
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while exporting to S3", e);
            }
        }
        byteArrayOutputStream.close();
        return responseHolder;
    }

    public boolean supports(DatatableExportTargetParameter exportType) {
        return DatatableExportTargetParameter.S3 == exportType;
    }

    @Generated
    public S3DatatableReportExportServiceImpl(ReadReportingService readExtraDataAndReportingService, ConfigurationDomainService configurationDomainService, S3Client s3Client, FineractProperties properties) {
        this.readExtraDataAndReportingService = readExtraDataAndReportingService;
        this.configurationDomainService = configurationDomainService;
        this.s3Client = s3Client;
        this.properties = properties;
    }
}

