/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.email.api;

import com.google.gson.JsonElement;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.campaigns.email.data.EmailBusinessRulesData;
import org.apache.fineract.infrastructure.campaigns.email.data.EmailCampaignData;
import org.apache.fineract.infrastructure.campaigns.email.data.PreviewCampaignMessage;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailCampaignReadPlatformService;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailCampaignWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.stereotype.Component;

@Path(value="/v1/email/campaign")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class EmailCampaignApiResource {
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "EMAIL_CAMPAIGN";
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<EmailBusinessRulesData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final EmailCampaignReadPlatformService emailCampaignReadPlatformService;
    private final FromJsonHelper fromJsonHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final DefaultToApiJsonSerializer<EmailCampaignData> emailCampaignDataDefaultToApiJsonSerializer;
    private final EmailCampaignWritePlatformService emailCampaignWritePlatformService;
    private final DefaultToApiJsonSerializer<PreviewCampaignMessage> previewCampaignMessageDefaultToApiJsonSerializer;

    @GET
    @Path(value="{resourceId}")
    @Produces(value={"application/json"})
    public String retrieveOneCampaign(@PathParam(value="resourceId") Long resourceId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        EmailCampaignData emailCampaignData = this.emailCampaignReadPlatformService.retrieveOne(resourceId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.emailCampaignDataDefaultToApiJsonSerializer.serialize(settings, (Object)emailCampaignData);
    }

    @GET
    @Produces(value={"application/json"})
    public String retrieveAllCampaign(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection emailCampaignDataCollection = this.emailCampaignReadPlatformService.retrieveAllCampaign();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.emailCampaignDataDefaultToApiJsonSerializer.serialize(settings, emailCampaignDataCollection);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String createCampaign(String apiRequestBodyAsJson, @Context UriInfo uriInfo) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createEmailCampaign().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{resourceId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String updateCampaign(@PathParam(value="resourceId") Long campaignId, String apiRequestBodyAsJson, @Context UriInfo uriInfo) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateEmailCampaign(campaignId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="{resourceId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String activate(@PathParam(value="resourceId") Long campaignId, @QueryParam(value="command") String commandParam, String apiRequestBodyAsJson) {
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        CommandProcessingResult result = null;
        if (this.is(commandParam, "activate")) {
            CommandWrapper commandRequest = builder.activateEmailCampaign(campaignId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "close")) {
            CommandWrapper commandRequest = builder.closeEmailCampaign(campaignId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "reactivate")) {
            CommandWrapper commandRequest = builder.reactivateEmailCampaign(campaignId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="preview")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String preview(String apiRequestBodyAsJson, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        JsonElement parsedQuery = this.fromJsonHelper.parse(apiRequestBodyAsJson);
        JsonQuery query = JsonQuery.from((String)apiRequestBodyAsJson, (JsonElement)parsedQuery, (FromJsonHelper)this.fromJsonHelper);
        PreviewCampaignMessage campaignMessage = this.emailCampaignWritePlatformService.previewMessage(query);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.previewCampaignMessageDefaultToApiJsonSerializer.serialize(settings, (Object)campaignMessage, new HashSet());
    }

    @GET
    @Path(value="template")
    public String template(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection emailBusinessRulesDataCollection = this.emailCampaignReadPlatformService.retrieveAll();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, emailBusinessRulesDataCollection);
    }

    @GET
    @Path(value="template/{resourceId}")
    public String retrieveOneTemplate(@PathParam(value="resourceId") Long resourceId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        EmailBusinessRulesData emailBusinessRulesData = this.emailCampaignReadPlatformService.retrieveOneTemplate(resourceId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)emailBusinessRulesData);
    }

    @DELETE
    @Path(value="{resourceId}")
    public String delete(@PathParam(value="resourceId") Long resourceId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteEmailCampaign(resourceId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @Generated
    public EmailCampaignApiResource(PlatformSecurityContext context, DefaultToApiJsonSerializer<EmailBusinessRulesData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, EmailCampaignReadPlatformService emailCampaignReadPlatformService, FromJsonHelper fromJsonHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, DefaultToApiJsonSerializer<EmailCampaignData> emailCampaignDataDefaultToApiJsonSerializer, EmailCampaignWritePlatformService emailCampaignWritePlatformService, DefaultToApiJsonSerializer<PreviewCampaignMessage> previewCampaignMessageDefaultToApiJsonSerializer) {
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.emailCampaignReadPlatformService = emailCampaignReadPlatformService;
        this.fromJsonHelper = fromJsonHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.emailCampaignDataDefaultToApiJsonSerializer = emailCampaignDataDefaultToApiJsonSerializer;
        this.emailCampaignWritePlatformService = emailCampaignWritePlatformService;
        this.previewCampaignMessageDefaultToApiJsonSerializer = previewCampaignMessageDefaultToApiJsonSerializer;
    }
}

