/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.portfolio.fund.data.FundData;
import org.apache.fineract.portfolio.paymenttype.data.PaymentTypeData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExtrasSheetPopulator
extends AbstractWorkbookPopulator {
    private List<FundData> funds;
    private List<PaymentTypeData> paymentTypes;
    private List<CurrencyData> currencies;
    private static final int FUND_ID_COL = 0;
    private static final int FUND_NAME_COL = 1;
    private static final int PAYMENT_TYPE_ID_COL = 2;
    private static final int PAYMENT_TYPE_NAME_COL = 3;
    private static final int CURRENCY_CODE_COL = 4;
    private static final int CURRENCY_NAME_COL = 5;

    public ExtrasSheetPopulator(List<FundData> funds, List<PaymentTypeData> paymentTypes, List<CurrencyData> currencies) {
        this.funds = funds;
        this.paymentTypes = paymentTypes;
        this.currencies = currencies;
    }

    public void populate(Workbook workbook, String dateFormat) {
        int fundRowIndex = 1;
        Sheet extrasSheet = workbook.createSheet("Extras");
        this.setLayout(extrasSheet);
        for (Object fund : this.funds) {
            Row row = extrasSheet.createRow(fundRowIndex++);
            this.writeLong(0, row, fund.getId().longValue());
            this.writeString(1, row, fund.getName());
        }
        int paymentTypeRowIndex = 1;
        for (PaymentTypeData paymentType : this.paymentTypes) {
            Row row = paymentTypeRowIndex < fundRowIndex ? extrasSheet.getRow(paymentTypeRowIndex++) : extrasSheet.createRow(paymentTypeRowIndex++);
            this.writeLong(2, row, paymentType.getId().longValue());
            this.writeString(3, row, paymentType.getName().trim().replaceAll("[ )(]", "_"));
        }
        int currencyCodeRowIndex = 1;
        for (CurrencyData currencies : this.currencies) {
            Row row = currencyCodeRowIndex < paymentTypeRowIndex || currencyCodeRowIndex < fundRowIndex ? extrasSheet.getRow(currencyCodeRowIndex++) : extrasSheet.createRow(currencyCodeRowIndex++);
            this.writeString(5, row, currencies.getName().trim().replaceAll("[ )(]", "_"));
            this.writeString(4, row, currencies.getCode());
        }
        extrasSheet.protectSheet("");
    }

    private void setLayout(Sheet worksheet) {
        worksheet.setColumnWidth(0, 6000);
        worksheet.setColumnWidth(1, 6000);
        worksheet.setColumnWidth(2, 6000);
        worksheet.setColumnWidth(3, 6000);
        worksheet.setColumnWidth(5, 6000);
        worksheet.setColumnWidth(4, 6000);
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        this.writeString(0, rowHeader, "Fund ID");
        this.writeString(1, rowHeader, "Name");
        this.writeString(2, rowHeader, "Payment Type ID");
        this.writeString(3, rowHeader, "Payment Type Name");
        this.writeString(5, rowHeader, "Currency Type ");
        this.writeString(4, rowHeader, "Currency Code ");
    }

    public Integer getFundsSize() {
        return this.funds.size();
    }

    public Integer getPaymentTypesSize() {
        return this.paymentTypes.size();
    }

    public Integer getCurrenciesSize() {
        return this.currencies.size();
    }
}

