/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import java.util.List;
import lombok.Generated;
import org.apache.fineract.cob.domain.LockOwner;
import org.apache.fineract.cob.loan.LoanLockingService;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.data.RepositoryItemWriter;
import org.springframework.lang.NonNull;

public abstract class AbstractLoanItemWriter
extends RepositoryItemWriter<Loan> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractLoanItemWriter.class);
    private final LoanLockingService loanLockingService;

    public void write(@NonNull Chunk<? extends Loan> items) throws Exception {
        if (!items.isEmpty()) {
            super.write(items);
            List<Long> loanIds = items.getItems().stream().map(AbstractPersistableCustom::getId).toList();
            this.loanLockingService.deleteByLoanIdInAndLockOwner(loanIds, this.getLockOwner());
        }
    }

    protected abstract LockOwner getLockOwner();

    @Generated
    public AbstractLoanItemWriter(LoanLockingService loanLockingService) {
        this.loanLockingService = loanLockingService;
    }
}

