/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.batch.command.internal;

import com.google.common.base.Splitter;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.batch.command.CommandStrategy;
import org.apache.fineract.batch.command.CommandStrategyUtils;
import org.apache.fineract.batch.domain.BatchRequest;
import org.apache.fineract.batch.domain.BatchResponse;
import org.apache.fineract.infrastructure.core.api.MutableUriInfo;
import org.apache.fineract.portfolio.loanaccount.api.LoansApiResource;
import org.springframework.stereotype.Component;

@Component
public class GetLoanByExternalIdCommandStrategy
implements CommandStrategy {
    private final LoansApiResource loansApiResource;

    public BatchResponse execute(BatchRequest request, UriInfo uriInfo) {
        String loanExternalId;
        MutableUriInfo parameterizedUriInfo = new MutableUriInfo(uriInfo);
        BatchResponse response = new BatchResponse();
        response.setRequestId(request.getRequestId());
        response.setHeaders(request.getHeaders());
        String relativeUrl = CommandStrategyUtils.relativeUrlWithoutVersion((BatchRequest)request);
        List pathParameters = Splitter.on((char)'/').splitToList((CharSequence)relativeUrl);
        String loanExternalIdPathParameter = (String)pathParameters.get(2);
        Map queryParameters = null;
        if (loanExternalIdPathParameter.indexOf(63) > 0) {
            loanExternalId = StringUtils.substringBefore((String)loanExternalIdPathParameter, (String)"?");
            queryParameters = this.getQueryParameters(relativeUrl);
            this.addQueryParametersToUriInfo(parameterizedUriInfo, queryParameters);
        } else {
            loanExternalId = loanExternalIdPathParameter;
        }
        boolean staffInSelectedOfficeOnly = false;
        String associations = null;
        String exclude = null;
        String fields = null;
        if (queryParameters != null && queryParameters.size() > 0) {
            if (queryParameters.containsKey("associations")) {
                associations = (String)queryParameters.get("associations");
            }
            if (queryParameters.containsKey("exclude")) {
                exclude = (String)queryParameters.get("exclude");
            }
            if (queryParameters.containsKey("fields")) {
                fields = (String)queryParameters.get("fields");
            }
            if (queryParameters.containsKey("staffInSelectedOfficeOnly")) {
                staffInSelectedOfficeOnly = BooleanUtils.toBoolean((String)((String)queryParameters.get("staffInSelectedOfficeOnly")));
            }
        }
        String responseBody = this.loansApiResource.retrieveLoan(loanExternalId, staffInSelectedOfficeOnly, associations, exclude, fields, (UriInfo)parameterizedUriInfo);
        response.setStatusCode(Integer.valueOf(200));
        response.setBody(responseBody);
        return response;
    }

    private Map<String, String> getQueryParameters(String relativeUrl) {
        String queryParameterStr = StringUtils.substringAfter((String)relativeUrl, (String)"?");
        String[] queryParametersArray = StringUtils.split((String)queryParameterStr, (String)"&");
        HashMap<String, String> queryParametersMap = new HashMap<String, String>();
        for (String parameterStr : queryParametersArray) {
            String[] keyValue = StringUtils.split((String)parameterStr, (String)"=");
            queryParametersMap.put(keyValue[0], keyValue[1]);
        }
        return queryParametersMap;
    }

    private void addQueryParametersToUriInfo(MutableUriInfo uriInfo, Map<String, String> queryParameters) {
        for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
            uriInfo.addAdditionalQueryParameter(entry.getKey(), entry.getValue());
        }
    }

    @Generated
    public GetLoanByExternalIdCommandStrategy(LoansApiResource loansApiResource) {
        this.loansApiResource = loansApiResource;
    }
}

