/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.journalentry.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.accounting.closure.domain.GLClosure;
import org.apache.fineract.accounting.closure.domain.GLClosureRepository;
import org.apache.fineract.accounting.common.AccountingConstants;
import org.apache.fineract.accounting.financialactivityaccount.domain.FinancialActivityAccount;
import org.apache.fineract.accounting.financialactivityaccount.domain.FinancialActivityAccountRepositoryWrapper;
import org.apache.fineract.accounting.glaccount.domain.GLAccount;
import org.apache.fineract.accounting.glaccount.domain.GLAccountRepository;
import org.apache.fineract.accounting.journalentry.data.ChargePaymentDTO;
import org.apache.fineract.accounting.journalentry.data.ClientChargePaymentDTO;
import org.apache.fineract.accounting.journalentry.data.ClientTransactionDTO;
import org.apache.fineract.accounting.journalentry.data.LoanDTO;
import org.apache.fineract.accounting.journalentry.data.LoanTransactionDTO;
import org.apache.fineract.accounting.journalentry.data.SavingsDTO;
import org.apache.fineract.accounting.journalentry.data.SavingsTransactionDTO;
import org.apache.fineract.accounting.journalentry.data.SharesDTO;
import org.apache.fineract.accounting.journalentry.data.SharesTransactionDTO;
import org.apache.fineract.accounting.journalentry.data.TaxPaymentDTO;
import org.apache.fineract.accounting.journalentry.domain.JournalEntry;
import org.apache.fineract.accounting.journalentry.domain.JournalEntryRepository;
import org.apache.fineract.accounting.journalentry.domain.JournalEntryType;
import org.apache.fineract.accounting.journalentry.exception.JournalEntryInvalidException;
import org.apache.fineract.accounting.journalentry.service.JournalAmountHolder;
import org.apache.fineract.accounting.producttoaccountmapping.domain.ProductToGLAccountMapping;
import org.apache.fineract.accounting.producttoaccountmapping.domain.ProductToGLAccountMappingRepository;
import org.apache.fineract.accounting.producttoaccountmapping.exception.ProductToGLAccountMappingNotFoundException;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.journalentry.LoanJournalEntryCreatedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.office.domain.OfficeRepository;
import org.apache.fineract.portfolio.PortfolioProductType;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.service.AccountTransfersReadPlatformService;
import org.apache.fineract.portfolio.charge.domain.ChargeRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.data.AccountingBridgeDataDTO;
import org.apache.fineract.portfolio.loanaccount.data.AccountingBridgeLoanTransactionDTO;
import org.apache.fineract.portfolio.loanaccount.data.LoanChargeData;
import org.apache.fineract.portfolio.loanaccount.data.LoanChargePaidByDTO;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionEnumData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionEnumData;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountTransactionEnumData;
import org.springframework.dao.DataAccessException;

public class AccountingProcessorHelper {
    public static final String LOAN_TRANSACTION_IDENTIFIER = "L";
    public static final String SAVINGS_TRANSACTION_IDENTIFIER = "S";
    public static final String CLIENT_TRANSACTION_IDENTIFIER = "C";
    public static final String PROVISIONING_TRANSACTION_IDENTIFIER = "P";
    public static final String SHARE_TRANSACTION_IDENTIFIER = "SH";
    private final JournalEntryRepository glJournalEntryRepository;
    private final ProductToGLAccountMappingRepository accountMappingRepository;
    private final FinancialActivityAccountRepositoryWrapper financialActivityAccountRepository;
    private final GLClosureRepository closureRepository;
    private final GLAccountRepository glAccountRepository;
    private final OfficeRepository officeRepository;
    private final AccountTransfersReadPlatformService accountTransfersReadPlatformService;
    private final ChargeRepositoryWrapper chargeRepositoryWrapper;
    private final BusinessEventNotifierService businessEventNotifierService;

    public LoanDTO populateLoanDtoFromDTO(AccountingBridgeDataDTO accountingBridgeData) {
        Long loanId = accountingBridgeData.getLoanId();
        Long loanProductId = accountingBridgeData.getLoanProductId();
        Long officeId = accountingBridgeData.getOfficeId();
        String currencyCode = accountingBridgeData.getCurrencyCode();
        ArrayList<LoanTransactionDTO> newLoanTransactions = new ArrayList<LoanTransactionDTO>();
        boolean isAccountTransfer = accountingBridgeData.isAccountTransfer();
        boolean isLoanMarkedAsChargeOff = accountingBridgeData.isChargeOff();
        boolean isLoanMarkedAsFraud = accountingBridgeData.isFraud();
        Long chargeOffReasonCodeValue = accountingBridgeData.getChargeOffReasonCodeValue();
        boolean isLoanMarkedAsWrittenOff = accountingBridgeData.isWrittenOff();
        boolean cashBasedAccountingEnabled = accountingBridgeData.isCashBasedAccountingEnabled();
        boolean upfrontAccrualBasedAccountingEnabled = accountingBridgeData.isUpfrontAccrualBasedAccountingEnabled();
        boolean periodicAccrualBasedAccountingEnabled = accountingBridgeData.isPeriodicAccrualBasedAccountingEnabled();
        boolean merchantBuyDownFee = accountingBridgeData.isMerchantBuyDownFee();
        List loanTransactionDTOs = accountingBridgeData.getNewLoanTransactions();
        for (AccountingBridgeLoanTransactionDTO loanTxnDto : loanTransactionDTOs) {
            boolean localIsAccountTransfer;
            Long transactionOfficeId = loanTxnDto.getOfficeId();
            String transactionId = loanTxnDto.getId().toString();
            LocalDate transactionDate = loanTxnDto.getDate();
            LoanTransactionEnumData transactionType = loanTxnDto.getType();
            BigDecimal amount = loanTxnDto.getAmount();
            BigDecimal principal = loanTxnDto.getPrincipalPortion();
            BigDecimal interest = loanTxnDto.getInterestPortion();
            BigDecimal fees = loanTxnDto.getFeeChargesPortion();
            BigDecimal penalties = loanTxnDto.getPenaltyChargesPortion();
            BigDecimal overPayments = loanTxnDto.getOverPaymentPortion();
            boolean reversed = loanTxnDto.isReversed();
            Long paymentTypeId = loanTxnDto.getPaymentTypeId();
            String chargeRefundChargeType = loanTxnDto.getChargeRefundChargeType();
            LoanChargeData loanChargeData = loanTxnDto.getLoanChargeData();
            ArrayList<ChargePaymentDTO> feePaymentDetails = new ArrayList<ChargePaymentDTO>();
            ArrayList<ChargePaymentDTO> penaltyPaymentDetails = new ArrayList<ChargePaymentDTO>();
            if (loanTxnDto.getLoanChargesPaid() != null) {
                List loanChargesPaidData = loanTxnDto.getLoanChargesPaid();
                for (LoanChargePaidByDTO loanChargePaid : loanChargesPaidData) {
                    Long chargeId = loanChargePaid.getChargeId();
                    Long loanChargeId = loanChargePaid.getLoanChargeId();
                    boolean isPenalty = loanChargePaid.getIsPenalty();
                    BigDecimal chargeAmountPaid = loanChargePaid.getAmount();
                    ChargePaymentDTO chargePaymentDTO = new ChargePaymentDTO(chargeId, chargeAmountPaid, loanChargeId);
                    if (isPenalty) {
                        penaltyPaymentDetails.add(chargePaymentDTO);
                        continue;
                    }
                    feePaymentDetails.add(chargePaymentDTO);
                }
            }
            if (!(localIsAccountTransfer = isAccountTransfer)) {
                localIsAccountTransfer = this.accountTransfersReadPlatformService.isAccountTransfer(Long.valueOf(Long.parseLong(transactionId)), PortfolioAccountType.LOAN);
            }
            BigDecimal principalPaid = loanTxnDto.getPrincipalPaid();
            BigDecimal feePaid = loanTxnDto.getFeePaid();
            BigDecimal penaltyPaid = loanTxnDto.getPenaltyPaid();
            LoanTransactionDTO transaction = new LoanTransactionDTO(transactionOfficeId, paymentTypeId, transactionId, transactionDate, transactionType, amount, principal, interest, fees, penalties, overPayments, reversed, penaltyPaymentDetails, feePaymentDetails, localIsAccountTransfer, chargeRefundChargeType, loanChargeData, principalPaid, feePaid, penaltyPaid);
            transaction.setLoanToLoanTransfer(loanTxnDto.isLoanToLoanTransfer());
            newLoanTransactions.add(transaction);
        }
        return new LoanDTO(loanId, loanProductId, officeId, currencyCode, cashBasedAccountingEnabled, upfrontAccrualBasedAccountingEnabled, periodicAccrualBasedAccountingEnabled, newLoanTransactions, isLoanMarkedAsChargeOff, isLoanMarkedAsFraud, chargeOffReasonCodeValue, isLoanMarkedAsWrittenOff, merchantBuyDownFee, accountingBridgeData.getBuydownFeeClassificationCodeValue(), accountingBridgeData.getCapitalizedIncomeClassificationCodeValue(), accountingBridgeData.getWriteOffReasonCodeValue());
    }

    public ProductToGLAccountMapping getChargeOffMappingByCodeValue(Long loanProductId, PortfolioProductType productType, Long chargeOffReasonId) {
        return this.accountMappingRepository.findChargeOffReasonMapping(loanProductId, productType.getValue(), chargeOffReasonId);
    }

    public ProductToGLAccountMapping getWriteOffMappingByCodeValue(Long loanProductId, PortfolioProductType productType, Long writeOffReasonId) {
        return this.accountMappingRepository.findWriteOffReasonMapping(loanProductId, productType.getValue(), writeOffReasonId);
    }

    public ProductToGLAccountMapping getClassificationMappingByCodeValue(Long loanProductId, PortfolioProductType productType, Long classificationId, String classificationType) {
        if (AccountingConstants.LoanProductAccountingParams.BUYDOWN_FEE_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS.getValue().equals(classificationType)) {
            return this.accountMappingRepository.findBuydownFeeClassificationMapping(loanProductId, productType.getValue(), classificationId);
        }
        return this.accountMappingRepository.findCapitalizedIncomeClassificationMapping(loanProductId, productType.getValue(), classificationId);
    }

    public SavingsDTO populateSavingsDtoFromMap(Map<String, Object> accountingBridgeData, boolean cashBasedAccountingEnabled, boolean accrualBasedAccountingEnabled) {
        Long loanId = (Long)accountingBridgeData.get("savingsId");
        Long loanProductId = (Long)accountingBridgeData.get("savingsProductId");
        Long officeId = (Long)accountingBridgeData.get("officeId");
        String currencyCode = (String)accountingBridgeData.get("currencyCode");
        ArrayList<SavingsTransactionDTO> newSavingsTransactions = new ArrayList<SavingsTransactionDTO>();
        boolean isAccountTransfer = (Boolean)accountingBridgeData.get("isAccountTransfer");
        List newTransactionsMap = (List)accountingBridgeData.get("newSavingsTransactions");
        for (Map map : newTransactionsMap) {
            Long transactionOfficeId = (Long)map.get("officeId");
            String transactionId = ((Long)map.get("id")).toString();
            LocalDate transactionDate = (LocalDate)map.get("date");
            SavingsAccountTransactionEnumData transactionType = (SavingsAccountTransactionEnumData)map.get("type");
            BigDecimal amount = (BigDecimal)map.get("amount");
            boolean reversed = (Boolean)map.get("reversed");
            Long paymentTypeId = (Long)map.get("paymentTypeId");
            BigDecimal overdraftAmount = (BigDecimal)map.get("overdraftAmount");
            ArrayList<ChargePaymentDTO> feePayments = new ArrayList<ChargePaymentDTO>();
            ArrayList<ChargePaymentDTO> penaltyPayments = new ArrayList<ChargePaymentDTO>();
            if (map.containsKey("savingsChargesPaid")) {
                List savingsChargesPaidData = (List)map.get("savingsChargesPaid");
                for (Map loanChargePaid : savingsChargesPaidData) {
                    Long chargeId = (Long)loanChargePaid.get("chargeId");
                    Long loanChargeId = (Long)loanChargePaid.get("savingsChargeId");
                    boolean isPenalty = (Boolean)loanChargePaid.get("isPenalty");
                    BigDecimal chargeAmountPaid = (BigDecimal)loanChargePaid.get("amount");
                    ChargePaymentDTO chargePaymentDTO = new ChargePaymentDTO(chargeId, chargeAmountPaid, loanChargeId);
                    if (isPenalty) {
                        penaltyPayments.add(chargePaymentDTO);
                        continue;
                    }
                    feePayments.add(chargePaymentDTO);
                }
            }
            ArrayList<TaxPaymentDTO> taxPayments = new ArrayList<TaxPaymentDTO>();
            if (map.containsKey("taxDetails")) {
                List taxDataList = (List)map.get("taxDetails");
                for (Map taxData : taxDataList) {
                    BigDecimal taxAmount = (BigDecimal)taxData.get("amount");
                    Long creditAccountId = (Long)taxData.get("creditAccountId");
                    Long debitAccountId = (Long)taxData.get("debitAccountId");
                    taxPayments.add(new TaxPaymentDTO(debitAccountId, creditAccountId, taxAmount));
                }
            }
            if (!isAccountTransfer) {
                isAccountTransfer = this.accountTransfersReadPlatformService.isAccountTransfer(Long.valueOf(Long.parseLong(transactionId)), PortfolioAccountType.SAVINGS);
            }
            SavingsTransactionDTO transaction = new SavingsTransactionDTO(transactionOfficeId, paymentTypeId, transactionId, transactionDate, transactionType, amount, reversed, feePayments, penaltyPayments, overdraftAmount, isAccountTransfer, taxPayments);
            newSavingsTransactions.add(transaction);
        }
        return new SavingsDTO(loanId, loanProductId, officeId, currencyCode, cashBasedAccountingEnabled, accrualBasedAccountingEnabled, newSavingsTransactions);
    }

    public SharesDTO populateSharesDtoFromMap(Map<String, Object> accountingBridgeData, boolean cashBasedAccountingEnabled, boolean accrualBasedAccountingEnabled) {
        Long shareAccountId = (Long)accountingBridgeData.get("shareAccountId");
        Long shareProductId = (Long)accountingBridgeData.get("shareProductId");
        Long officeId = (Long)accountingBridgeData.get("officeId");
        String currencyCode = (String)accountingBridgeData.get("currencyCode");
        ArrayList<SharesTransactionDTO> newTransactions = new ArrayList<SharesTransactionDTO>();
        List newTransactionsMap = (List)accountingBridgeData.get("newTransactions");
        for (Map map : newTransactionsMap) {
            Long transactionOfficeId = (Long)map.get("officeId");
            String transactionId = ((Long)map.get("id")).toString();
            LocalDate transactionDate = (LocalDate)map.get("date");
            ShareAccountTransactionEnumData transactionType = (ShareAccountTransactionEnumData)map.get("type");
            ShareAccountTransactionEnumData transactionStatus = (ShareAccountTransactionEnumData)map.get("status");
            BigDecimal amount = (BigDecimal)map.get("amount");
            BigDecimal chargeAmount = (BigDecimal)map.get("chargeAmount");
            Long paymentTypeId = (Long)map.get("paymentTypeId");
            ArrayList<ChargePaymentDTO> feePayments = new ArrayList<ChargePaymentDTO>();
            if (map.containsKey("chargesPaid")) {
                List chargesPaidData = (List)map.get("chargesPaid");
                for (Map chargePaid : chargesPaidData) {
                    Long chargeId = (Long)chargePaid.get("chargeId");
                    Long loanChargeId = (Long)chargePaid.get("sharesChargeId");
                    BigDecimal chargeAmountPaid = (BigDecimal)chargePaid.get("amount");
                    ChargePaymentDTO chargePaymentDTO = new ChargePaymentDTO(chargeId, chargeAmountPaid, loanChargeId);
                    feePayments.add(chargePaymentDTO);
                }
            }
            SharesTransactionDTO transaction = new SharesTransactionDTO(transactionOfficeId, paymentTypeId, transactionId, transactionDate, transactionType, transactionStatus, amount, chargeAmount, feePayments);
            newTransactions.add(transaction);
        }
        return new SharesDTO(shareAccountId, shareProductId, officeId, currencyCode, cashBasedAccountingEnabled, accrualBasedAccountingEnabled, newTransactions);
    }

    public ClientTransactionDTO populateClientTransactionDtoFromMap(Map<String, Object> accountingBridgeData) {
        Long transactionOfficeId = (Long)accountingBridgeData.get("officeId");
        Long clientId = (Long)accountingBridgeData.get("clientId");
        Long transactionId = (Long)accountingBridgeData.get("id");
        LocalDate transactionDate = (LocalDate)accountingBridgeData.get("date");
        EnumOptionData transactionType = (EnumOptionData)accountingBridgeData.get("type");
        BigDecimal amount = (BigDecimal)accountingBridgeData.get("amount");
        boolean reversed = (Boolean)accountingBridgeData.get("reversed");
        Long paymentTypeId = (Long)accountingBridgeData.get("paymentTypeId");
        String currencyCode = (String)accountingBridgeData.get("currencyCode");
        Boolean accountingEnabled = (Boolean)accountingBridgeData.get("accountingEnabled");
        ArrayList<ClientChargePaymentDTO> clientChargePaymentDTOs = new ArrayList<ClientChargePaymentDTO>();
        if (accountingBridgeData.containsKey("clientChargesPaid")) {
            List clientChargesPaidData = (List)accountingBridgeData.get("clientChargesPaid");
            for (Map clientChargePaid : clientChargesPaidData) {
                Long chargeId = (Long)clientChargePaid.get("chargeId");
                Long clientChargeId = (Long)clientChargePaid.get("clientChargeId");
                boolean isPenalty = (Boolean)clientChargePaid.get("isPenalty");
                BigDecimal chargeAmountPaid = (BigDecimal)clientChargePaid.get("amount");
                Long incomeAccountId = (Long)clientChargePaid.get("incomeAccountId");
                ClientChargePaymentDTO clientChargePaymentDTO = new ClientChargePaymentDTO(chargeId, chargeAmountPaid, clientChargeId, isPenalty, incomeAccountId);
                clientChargePaymentDTOs.add(clientChargePaymentDTO);
            }
        }
        return new ClientTransactionDTO(clientId, transactionOfficeId, paymentTypeId, transactionId, transactionDate, transactionType, currencyCode, amount, reversed, accountingEnabled.booleanValue(), clientChargePaymentDTOs);
    }

    public void createJournalEntriesForLoanCharges(Office office, String currencyCode, Integer accountTypeToBeDebited, Integer accountTypeToBeCredited, Long loanProductId, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal totalAmount, List<ChargePaymentDTO> chargePaymentDTOs) {
        BigDecimal amount;
        GLAccount account;
        LinkedHashMap<GLAccount, BigDecimal> creditDetailsMap = new LinkedHashMap<GLAccount, BigDecimal>();
        LinkedHashMap<GLAccount, BigDecimal> debitDetailsMap = new LinkedHashMap<GLAccount, BigDecimal>();
        for (ChargePaymentDTO chargePaymentDTO : chargePaymentDTOs) {
            Long chargeId = chargePaymentDTO.getChargeId();
            GLAccount chargeSpecificCreditAccount = this.getLinkedGLAccountForLoanCharges(loanProductId, accountTypeToBeCredited.intValue(), chargeId);
            GLAccount chargeSpecificDebitAccount = this.getLinkedGLAccountForLoanCharges(loanProductId, accountTypeToBeDebited.intValue(), chargeId);
            BigDecimal chargeSpecificAmount = chargePaymentDTO.getAmount();
            creditDetailsMap.merge(chargeSpecificCreditAccount, chargeSpecificAmount, BigDecimal::add);
            debitDetailsMap.merge(chargeSpecificDebitAccount, chargeSpecificAmount, BigDecimal::add);
        }
        BigDecimal totalCreditedAmount = BigDecimal.ZERO;
        BigDecimal totalDebitedAmount = BigDecimal.ZERO;
        for (Map.Entry entry : creditDetailsMap.entrySet()) {
            account = (GLAccount)entry.getKey();
            amount = (BigDecimal)entry.getValue();
            totalCreditedAmount = totalCreditedAmount.add(amount);
            this.createCreditJournalEntryForLoan(office, currencyCode, account, loanId, transactionId, transactionDate, amount);
        }
        for (Map.Entry entry : debitDetailsMap.entrySet()) {
            account = (GLAccount)entry.getKey();
            amount = (BigDecimal)entry.getValue();
            totalDebitedAmount = totalDebitedAmount.add(amount);
            this.createDebitJournalEntryForLoan(office, currencyCode, account, loanId, transactionId, transactionDate, amount);
        }
        if (totalAmount.compareTo(totalCreditedAmount) != 0) {
            throw new PlatformDataIntegrityException("Meltdown in advanced accounting...sum of all charge credits does not equal the total transaction amount", "Sum of charge credits (" + String.valueOf(totalCreditedAmount) + ") does not equal transaction total (" + String.valueOf(totalAmount) + ") for loan " + loanId + ", transaction " + transactionId, new Object[]{totalCreditedAmount, totalAmount});
        }
        if (totalAmount.compareTo(totalDebitedAmount) != 0) {
            throw new PlatformDataIntegrityException("Meltdown in advanced accounting...sum of all charge debits does not equal the total transaction amount", "Sum of charge debits (" + String.valueOf(totalDebitedAmount) + ") does not equal transaction total (" + String.valueOf(totalAmount) + ") for loan " + loanId + ", transaction " + transactionId, new Object[]{totalDebitedAmount, totalAmount});
        }
    }

    public void createCashBasedJournalEntriesAndReversalsForSavings(Office office, String currencyCode, Integer accountTypeToBeDebited, Integer accountTypeToBeCredited, Long savingsProductId, Long paymentTypeId, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal amount, Boolean isReversal) {
        int accountTypeToDebitId = accountTypeToBeDebited;
        int accountTypeToCreditId = accountTypeToBeCredited;
        if (isReversal.booleanValue()) {
            accountTypeToDebitId = accountTypeToBeCredited;
            accountTypeToCreditId = accountTypeToBeDebited;
        }
        this.createJournalEntriesForSavings(office, currencyCode, accountTypeToDebitId, accountTypeToCreditId, savingsProductId, paymentTypeId, loanId, transactionId, transactionDate, amount);
    }

    public void createJournalEntriesForLoan(Office office, String currencyCode, Integer accountTypeToBeDebited, Integer accountTypeToBeCredited, Long loanProductId, Long paymentTypeId, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        int accountTypeToDebitId = accountTypeToBeDebited;
        int accountTypeToCreditId = accountTypeToBeCredited;
        this.createJournalEntriesForLoan(office, currencyCode, accountTypeToDebitId, accountTypeToCreditId, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, amount);
    }

    public void createJournalEntriesForLoan(Office office, String currencyCode, Integer accountTypeToBeDebited, GLAccount accountToBeCredited, Long loanProductId, Long paymentTypeId, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        int accountTypeToDebitId = accountTypeToBeDebited;
        this.createJournalEntriesForLoan(office, currencyCode, accountTypeToDebitId, accountToBeCredited, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, amount);
    }

    public void createSplitJournalEntriesForLoan(Office office, String currencyCode, List<JournalAmountHolder> splitAccountsHolder, JournalAmountHolder totalAccountHolder, Long loanProductId, Long paymentTypeId, Long loanId, String transactionId, LocalDate transactionDate) {
        splitAccountsHolder.forEach(journalItemHolder -> {
            if (MathUtil.isGreaterThanZero((BigDecimal)journalItemHolder.getAmount())) {
                GLAccount account = this.getLinkedGLAccountForLoanProduct(loanProductId, journalItemHolder.getAccountType().intValue(), paymentTypeId);
                this.createDebitJournalEntryForLoan(office, currencyCode, account, loanId, transactionId, transactionDate, journalItemHolder.getAmount());
            }
        });
        if (MathUtil.isGreaterThanZero((BigDecimal)totalAccountHolder.getAmount())) {
            GLAccount totalAccount = this.getLinkedGLAccountForLoanProduct(loanProductId, totalAccountHolder.getAccountType().intValue(), paymentTypeId);
            this.createCreditJournalEntryForLoan(office, currencyCode, totalAccount, loanId, transactionId, transactionDate, totalAccountHolder.getAmount());
        }
    }

    public void createCreditJournalEntryForLoan(Office office, String currencyCode, AccountingConstants.CashAccountsForLoan accountMappingType, Long loanProductId, Long paymentTypeId, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        int accountMappingTypeId = accountMappingType.getValue();
        this.createCreditJournalEntryForLoan(office, currencyCode, accountMappingTypeId, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, amount);
    }

    public void createCreditJournalEntryForLoan(Office office, String currencyCode, AccountingConstants.AccrualAccountsForLoan accountMappingType, Long loanProductId, Long paymentTypeId, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        int accountMappingTypeId = accountMappingType.getValue();
        this.createCreditJournalEntryForLoan(office, currencyCode, accountMappingTypeId, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, amount);
    }

    public void checkForBranchClosures(GLClosure latestGLClosure, LocalDate transactionDate) {
        if (latestGLClosure != null && !DateUtils.isBefore((LocalDate)latestGLClosure.getClosingDate(), (LocalDate)transactionDate)) {
            throw new JournalEntryInvalidException(JournalEntryInvalidException.GlJournalEntryInvalidReason.ACCOUNTING_CLOSED, latestGLClosure.getClosingDate(), null, null);
        }
    }

    public GLClosure getLatestClosureByBranch(long officeId) {
        return this.closureRepository.getLatestGLClosureByBranch(Long.valueOf(officeId));
    }

    private void createJournalEntriesForLoan(Office office, String currencyCode, int accountTypeToDebitId, int accountTypeToCreditId, Long loanProductId, Long paymentTypeId, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        GLAccount debitAccount = this.getLinkedGLAccountForLoanProduct(loanProductId, accountTypeToDebitId, paymentTypeId);
        GLAccount creditAccount = this.getLinkedGLAccountForLoanProduct(loanProductId, accountTypeToCreditId, paymentTypeId);
        this.createDebitJournalEntryForLoan(office, currencyCode, debitAccount, loanId, transactionId, transactionDate, amount);
        this.createCreditJournalEntryForLoan(office, currencyCode, creditAccount, loanId, transactionId, transactionDate, amount);
    }

    private void createJournalEntriesForLoan(Office office, String currencyCode, int accountTypeToDebitId, GLAccount creditAccount, Long loanProductId, Long paymentTypeId, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        GLAccount debitAccount = this.getLinkedGLAccountForLoanProduct(loanProductId, accountTypeToDebitId, paymentTypeId);
        this.createDebitJournalEntryForLoan(office, currencyCode, debitAccount, loanId, transactionId, transactionDate, amount);
        this.createCreditJournalEntryForLoan(office, currencyCode, creditAccount, loanId, transactionId, transactionDate, amount);
    }

    private void createJournalEntriesForSavings(Office office, String currencyCode, int accountTypeToDebitId, int accountTypeToCreditId, Long savingsProductId, Long paymentTypeId, Long savingsId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        GLAccount debitAccount = this.getLinkedGLAccountForSavingsProduct(savingsProductId, accountTypeToDebitId, paymentTypeId);
        GLAccount creditAccount = this.getLinkedGLAccountForSavingsProduct(savingsProductId, accountTypeToCreditId, paymentTypeId);
        this.createDebitJournalEntryForSavings(office, currencyCode, debitAccount, savingsId, transactionId, transactionDate, amount);
        this.createCreditJournalEntryForSavings(office, currencyCode, creditAccount, savingsId, transactionId, transactionDate, amount);
    }

    public void createCashBasedJournalEntriesAndReversalsForSavingsTax(Office office, String currencyCode, AccountingConstants.CashAccountsForSavings accountTypeToBeDebited, AccountingConstants.CashAccountsForSavings accountTypeToBeCredited, Long savingsProductId, Long paymentTypeId, Long savingsId, String transactionId, LocalDate transactionDate, BigDecimal amount, Boolean isReversal, List<TaxPaymentDTO> taxDetails) {
        for (TaxPaymentDTO taxPaymentDTO : taxDetails) {
            if (taxPaymentDTO.getAmount() == null) continue;
            if (taxPaymentDTO.getCreditAccountId() == null) {
                this.createCashBasedCreditJournalEntriesAndReversalsForSavings(office, currencyCode, accountTypeToBeCredited.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, taxPaymentDTO.getAmount(), isReversal);
                continue;
            }
            this.createCashBasedCreditJournalEntriesAndReversalsForSavings(office, currencyCode, taxPaymentDTO.getCreditAccountId(), savingsId, transactionId, transactionDate, taxPaymentDTO.getAmount(), isReversal);
        }
        this.createCashBasedDebitJournalEntriesAndReversalsForSavings(office, currencyCode, accountTypeToBeDebited.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, isReversal);
    }

    public void createAccrualBasedJournalEntriesAndReversalsForSavingsTax(Office office, String currencyCode, AccountingConstants.AccrualAccountsForSavings accountTypeToBeDebited, AccountingConstants.AccrualAccountsForSavings accountTypeToBeCredited, Long savingsProductId, Long paymentTypeId, Long savingsId, String transactionId, LocalDate transactionDate, BigDecimal amount, Boolean isReversal, List<TaxPaymentDTO> taxDetails) {
        for (TaxPaymentDTO taxPaymentDTO : taxDetails) {
            if (taxPaymentDTO.getAmount() == null) continue;
            if (taxPaymentDTO.getCreditAccountId() == null) {
                this.createAccrualBasedCreditJournalEntriesAndReversalsForSavings(office, currencyCode, accountTypeToBeCredited.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, taxPaymentDTO.getAmount(), isReversal);
                continue;
            }
            this.createAccrualBasedBasedCreditJournalEntriesAndReversalsForSavings(office, currencyCode, taxPaymentDTO.getCreditAccountId(), savingsId, transactionId, transactionDate, taxPaymentDTO.getAmount(), isReversal);
        }
        this.createAccrualBasedDebitJournalEntriesAndReversalsForSavings(office, currencyCode, accountTypeToBeDebited.getValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount, isReversal);
    }

    public void createCashBasedDebitJournalEntriesAndReversalsForSavings(Office office, String currencyCode, Integer accountTypeToBeDebited, Long savingsProductId, Long paymentTypeId, Long savingsId, String transactionId, LocalDate transactionDate, BigDecimal amount, Boolean isReversal) {
        if (isReversal.booleanValue()) {
            this.createCreditJournalEntriesForSavings(office, currencyCode, accountTypeToBeDebited.intValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount);
        } else {
            this.createDebitJournalEntriesForSavings(office, currencyCode, accountTypeToBeDebited.intValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount);
        }
    }

    public void createCashBasedCreditJournalEntriesAndReversalsForSavings(Office office, String currencyCode, Integer accountTypeToBeCredited, Long savingsProductId, Long paymentTypeId, Long savingsId, String transactionId, LocalDate transactionDate, BigDecimal amount, Boolean isReversal) {
        if (isReversal.booleanValue()) {
            this.createDebitJournalEntriesForSavings(office, currencyCode, accountTypeToBeCredited.intValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount);
        } else {
            this.createCreditJournalEntriesForSavings(office, currencyCode, accountTypeToBeCredited.intValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount);
        }
    }

    public void createCashBasedCreditJournalEntriesAndReversalsForSavings(Office office, String currencyCode, Long creditAccountId, Long savingsId, String transactionId, LocalDate transactionDate, BigDecimal amount, Boolean isReversal) {
        GLAccount creditAccount = this.getGLAccountById(creditAccountId);
        if (isReversal.booleanValue()) {
            this.createDebitJournalEntryForSavings(office, currencyCode, creditAccount, savingsId, transactionId, transactionDate, amount);
        } else {
            this.createCreditJournalEntryForSavings(office, currencyCode, creditAccount, savingsId, transactionId, transactionDate, amount);
        }
    }

    public void createAccrualBasedDebitJournalEntriesAndReversalsForSavings(Office office, String currencyCode, Integer accountTypeToBeDebited, Long savingsProductId, Long paymentTypeId, Long savingsId, String transactionId, LocalDate transactionDate, BigDecimal amount, Boolean isReversal) {
        if (isReversal.booleanValue()) {
            this.createCreditJournalEntriesForSavings(office, currencyCode, accountTypeToBeDebited.intValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount);
        } else {
            this.createDebitJournalEntriesForSavings(office, currencyCode, accountTypeToBeDebited.intValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount);
        }
    }

    public void createAccrualBasedCreditJournalEntriesAndReversalsForSavings(Office office, String currencyCode, Integer accountTypeToBeCredited, Long savingsProductId, Long paymentTypeId, Long savingsId, String transactionId, LocalDate transactionDate, BigDecimal amount, Boolean isReversal) {
        if (isReversal.booleanValue()) {
            this.createDebitJournalEntriesForSavings(office, currencyCode, accountTypeToBeCredited.intValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount);
        } else {
            this.createCreditJournalEntriesForSavings(office, currencyCode, accountTypeToBeCredited.intValue(), savingsProductId, paymentTypeId, savingsId, transactionId, transactionDate, amount);
        }
    }

    public void createAccrualBasedBasedCreditJournalEntriesAndReversalsForSavings(Office office, String currencyCode, Long creditAccountId, Long savingsId, String transactionId, LocalDate transactionDate, BigDecimal amount, Boolean isReversal) {
        GLAccount creditAccount = this.getGLAccountById(creditAccountId);
        if (isReversal.booleanValue()) {
            this.createDebitJournalEntryForSavings(office, currencyCode, creditAccount, savingsId, transactionId, transactionDate, amount);
        } else {
            this.createCreditJournalEntryForSavings(office, currencyCode, creditAccount, savingsId, transactionId, transactionDate, amount);
        }
    }

    private void createDebitJournalEntriesForSavings(Office office, String currencyCode, int accountTypeToDebitId, Long savingsProductId, Long paymentTypeId, Long savingsId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        GLAccount debitAccount = this.getLinkedGLAccountForSavingsProduct(savingsProductId, accountTypeToDebitId, paymentTypeId);
        this.createDebitJournalEntryForSavings(office, currencyCode, debitAccount, savingsId, transactionId, transactionDate, amount);
    }

    private void createCreditJournalEntriesForSavings(Office office, String currencyCode, int accountTypeToCreditId, Long savingsProductId, Long paymentTypeId, Long savingsId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        GLAccount creditAccount = this.getLinkedGLAccountForSavingsProduct(savingsProductId, accountTypeToCreditId, paymentTypeId);
        this.createCreditJournalEntryForSavings(office, currencyCode, creditAccount, savingsId, transactionId, transactionDate, amount);
    }

    public void createDebitJournalEntryForLoan(Office office, String currencyCode, int accountMappingTypeId, Long loanProductId, Long paymentTypeId, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        GLAccount account = this.getLinkedGLAccountForLoanProduct(loanProductId, accountMappingTypeId, paymentTypeId);
        this.createDebitJournalEntryForLoan(office, currencyCode, account, loanId, transactionId, transactionDate, amount);
    }

    public void createDebitJournalEntryForLoan(Office office, String currencyCode, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal amount, GLAccount account) {
        this.createDebitJournalEntryForLoan(office, currencyCode, account, loanId, transactionId, transactionDate, amount);
    }

    public void createDebitJournalEntryForLoanCharges(Office office, String currencyCode, int accountMappingTypeId, Long loanProductId, Long chargeId, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        GLAccount account = this.getLinkedGLAccountForLoanCharges(loanProductId, accountMappingTypeId, chargeId);
        this.createDebitJournalEntryForLoan(office, currencyCode, account, loanId, transactionId, transactionDate, amount);
    }

    public void createCreditJournalEntryForLoanCharges(Office office, String currencyCode, int accountMappingTypeId, Long loanProductId, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal totalAmount, List<ChargePaymentDTO> chargePaymentDTOs) {
        this.createJournalEntriesForLoanChargesInternal(office, currencyCode, accountMappingTypeId, loanProductId, loanId, transactionId, transactionDate, totalAmount, chargePaymentDTOs, true);
    }

    public void createDebitJournalEntryForLoanCharges(Office office, String currencyCode, int accountMappingTypeId, Long loanProductId, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal totalAmount, List<ChargePaymentDTO> chargePaymentDTOs) {
        this.createJournalEntriesForLoanChargesInternal(office, currencyCode, accountMappingTypeId, loanProductId, loanId, transactionId, transactionDate, totalAmount, chargePaymentDTOs, false);
    }

    public void createCashBasedJournalEntriesAndReversalsForSavingsCharges(Office office, String currencyCode, AccountingConstants.CashAccountsForSavings accountTypeToBeDebited, AccountingConstants.CashAccountsForSavings accountTypeToBeCredited, Long savingsProductId, Long paymentTypeId, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal totalAmount, Boolean isReversal, List<ChargePaymentDTO> chargePaymentDTOs) {
        if (chargePaymentDTOs.size() != 1) {
            throw new PlatformDataIntegrityException("Recent Portfolio changes w.r.t Charges for Savings have Broken the accounting code", "Recent Portfolio changes w.r.t Charges for Savings have Broken the accounting code", new Object[0]);
        }
        ChargePaymentDTO chargePaymentDTO = chargePaymentDTOs.get(0);
        GLAccount chargeSpecificAccount = this.getLinkedGLAccountForSavingsCharges(savingsProductId, accountTypeToBeCredited.getValue().intValue(), chargePaymentDTO.getChargeId());
        GLAccount savingsControlAccount = this.getLinkedGLAccountForSavingsProduct(savingsProductId, accountTypeToBeDebited.getValue().intValue(), paymentTypeId);
        if (isReversal.booleanValue()) {
            this.createDebitJournalEntryForSavings(office, currencyCode, chargeSpecificAccount, loanId, transactionId, transactionDate, totalAmount);
            this.createCreditJournalEntryForSavings(office, currencyCode, savingsControlAccount, loanId, transactionId, transactionDate, totalAmount);
        } else {
            this.createDebitJournalEntryForSavings(office, currencyCode, savingsControlAccount, loanId, transactionId, transactionDate, totalAmount);
            this.createCreditJournalEntryForSavings(office, currencyCode, chargeSpecificAccount, loanId, transactionId, transactionDate, totalAmount);
        }
    }

    public void createAccrualBasedJournalEntriesAndReversalsForSavingsCharges(Office office, String currencyCode, AccountingConstants.AccrualAccountsForSavings accountTypeToBeDebited, AccountingConstants.AccrualAccountsForSavings accountTypeToBeCredited, Long savingsProductId, Long paymentTypeId, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal totalAmount, Boolean isReversal, List<ChargePaymentDTO> chargePaymentDTOs) {
        if (chargePaymentDTOs.size() != 1) {
            throw new PlatformDataIntegrityException("Recent Portfolio changes w.r.t Charges for Savings have Broken the accounting code", "Recent Portfolio changes w.r.t Charges for Savings have Broken the accounting code", new Object[0]);
        }
        ChargePaymentDTO chargePaymentDTO = chargePaymentDTOs.get(0);
        GLAccount chargeSpecificAccount = this.getLinkedGLAccountForSavingsCharges(savingsProductId, accountTypeToBeCredited.getValue().intValue(), chargePaymentDTO.getChargeId());
        GLAccount savingsControlAccount = this.getLinkedGLAccountForSavingsProduct(savingsProductId, accountTypeToBeDebited.getValue().intValue(), paymentTypeId);
        if (isReversal.booleanValue()) {
            this.createDebitJournalEntryForSavings(office, currencyCode, chargeSpecificAccount, loanId, transactionId, transactionDate, totalAmount);
            this.createCreditJournalEntryForSavings(office, currencyCode, savingsControlAccount, loanId, transactionId, transactionDate, totalAmount);
        } else {
            this.createDebitJournalEntryForSavings(office, currencyCode, savingsControlAccount, loanId, transactionId, transactionDate, totalAmount);
            this.createCreditJournalEntryForSavings(office, currencyCode, chargeSpecificAccount, loanId, transactionId, transactionDate, totalAmount);
        }
    }

    public Office getOfficeById(long officeId) {
        return (Office)this.officeRepository.getReferenceById((Object)officeId);
    }

    public void createCreditJournalEntryForLoan(Office office, String currencyCode, int accountMappingTypeId, Long loanProductId, Long paymentTypeId, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        GLAccount account = this.getLinkedGLAccountForLoanProduct(loanProductId, accountMappingTypeId, paymentTypeId);
        this.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, amount, account);
    }

    public void createCreditJournalEntryForLoan(Office office, String currencyCode, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal amount, GLAccount account) {
        this.createCreditJournalEntryForLoan(office, currencyCode, account, loanId, transactionId, transactionDate, amount);
    }

    private void createCreditJournalEntryForClientPayments(Office office, String currencyCode, GLAccount account, Long clientId, Long transactionId, LocalDate transactionDate, BigDecimal amount) {
        boolean manualEntry = false;
        String modifiedTransactionId = CLIENT_TRANSACTION_IDENTIFIER + transactionId;
        JournalEntry journalEntry = JournalEntry.createNew((Office)office, null, (GLAccount)account, (String)currencyCode, (String)modifiedTransactionId, (boolean)false, (LocalDate)transactionDate, (JournalEntryType)JournalEntryType.CREDIT, (BigDecimal)amount, null, (Integer)PortfolioProductType.CLIENT.getValue(), (Long)clientId, null, null, null, (Long)transactionId, null);
        this.persistJournalEntry(journalEntry);
    }

    private void createCreditJournalEntryForSavings(Office office, String currencyCode, GLAccount account, Long savingsId, String transactionId, LocalDate transactionDate, BigDecimal amount) throws DataAccessException {
        boolean manualEntry = false;
        Long savingsAccountTransactionId = null;
        Object modifiedTransactionId = transactionId;
        if (StringUtils.isNumeric((CharSequence)transactionId)) {
            savingsAccountTransactionId = Long.parseLong(transactionId);
            modifiedTransactionId = SAVINGS_TRANSACTION_IDENTIFIER + transactionId;
        }
        JournalEntry journalEntry = JournalEntry.createNew((Office)office, null, (GLAccount)account, (String)currencyCode, (String)modifiedTransactionId, (boolean)false, (LocalDate)transactionDate, (JournalEntryType)JournalEntryType.CREDIT, (BigDecimal)amount, null, (Integer)PortfolioProductType.SAVING.getValue(), (Long)savingsId, null, null, (Long)savingsAccountTransactionId, null, null);
        this.persistJournalEntry(journalEntry);
    }

    private void createCreditJournalEntryForLoan(Office office, String currencyCode, GLAccount account, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        boolean manualEntry = false;
        Long loanTransactionId = null;
        Object modifiedTransactionId = transactionId;
        if (StringUtils.isNumeric((CharSequence)transactionId)) {
            loanTransactionId = Long.parseLong(transactionId);
            modifiedTransactionId = LOAN_TRANSACTION_IDENTIFIER + transactionId;
        }
        JournalEntry journalEntry = JournalEntry.createNew((Office)office, null, (GLAccount)account, (String)currencyCode, (String)modifiedTransactionId, (boolean)false, (LocalDate)transactionDate, (JournalEntryType)JournalEntryType.CREDIT, (BigDecimal)amount, null, (Integer)PortfolioProductType.LOAN.getValue(), (Long)loanId, null, (Long)loanTransactionId, null, null, null);
        this.persistJournalEntry(journalEntry);
    }

    public void createProvisioningDebitJournalEntry(LocalDate transactionDate, Long provisioningEntryId, Office office, String currencyCode, GLAccount account, BigDecimal amount) {
        boolean manualEntry = false;
        String modifiedTransactionId = PROVISIONING_TRANSACTION_IDENTIFIER + provisioningEntryId;
        JournalEntry journalEntry = JournalEntry.createNew((Office)office, null, (GLAccount)account, (String)currencyCode, (String)modifiedTransactionId, (boolean)false, (LocalDate)transactionDate, (JournalEntryType)JournalEntryType.DEBIT, (BigDecimal)amount, null, (Integer)PortfolioProductType.PROVISIONING.getValue(), (Long)provisioningEntryId, null, null, null, null, null);
        this.persistJournalEntry(journalEntry);
    }

    public void createProvisioningCreditJournalEntry(LocalDate transactionDate, Long provisioningEntryId, Office office, String currencyCode, GLAccount account, BigDecimal amount) {
        boolean manualEntry = false;
        String modifiedTransactionId = PROVISIONING_TRANSACTION_IDENTIFIER + provisioningEntryId;
        JournalEntry journalEntry = JournalEntry.createNew((Office)office, null, (GLAccount)account, (String)currencyCode, (String)modifiedTransactionId, (boolean)false, (LocalDate)transactionDate, (JournalEntryType)JournalEntryType.CREDIT, (BigDecimal)amount, null, (Integer)PortfolioProductType.PROVISIONING.getValue(), (Long)provisioningEntryId, null, null, null, null, null);
        this.persistJournalEntry(journalEntry);
    }

    public void createDebitJournalEntryForLoan(Office office, String currencyCode, GLAccount account, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        boolean manualEntry = false;
        Long loanTransactionId = null;
        Object modifiedTransactionId = transactionId;
        if (StringUtils.isNumeric((CharSequence)transactionId)) {
            loanTransactionId = Long.parseLong(transactionId);
            modifiedTransactionId = LOAN_TRANSACTION_IDENTIFIER + transactionId;
        }
        JournalEntry journalEntry = JournalEntry.createNew((Office)office, null, (GLAccount)account, (String)currencyCode, (String)modifiedTransactionId, (boolean)false, (LocalDate)transactionDate, (JournalEntryType)JournalEntryType.DEBIT, (BigDecimal)amount, null, (Integer)PortfolioProductType.LOAN.getValue(), (Long)loanId, null, (Long)loanTransactionId, null, null, null);
        this.persistJournalEntry(journalEntry);
    }

    private void createDebitJournalEntryForSavings(Office office, String currencyCode, GLAccount account, Long savingsId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        boolean manualEntry = false;
        Long savingsAccountTransactionId = null;
        Object modifiedTransactionId = transactionId;
        if (StringUtils.isNumeric((CharSequence)transactionId)) {
            savingsAccountTransactionId = Long.parseLong(transactionId);
            modifiedTransactionId = SAVINGS_TRANSACTION_IDENTIFIER + transactionId;
        }
        JournalEntry journalEntry = JournalEntry.createNew((Office)office, null, (GLAccount)account, (String)currencyCode, (String)modifiedTransactionId, (boolean)false, (LocalDate)transactionDate, (JournalEntryType)JournalEntryType.DEBIT, (BigDecimal)amount, null, (Integer)PortfolioProductType.SAVING.getValue(), (Long)savingsId, null, null, (Long)savingsAccountTransactionId, null, null);
        this.persistJournalEntry(journalEntry);
    }

    private void createDebitJournalEntryForClientPayments(Office office, String currencyCode, GLAccount account, Long clientId, Long transactionId, LocalDate transactionDate, BigDecimal amount) {
        boolean manualEntry = false;
        String modifiedTransactionId = CLIENT_TRANSACTION_IDENTIFIER + transactionId;
        JournalEntry journalEntry = JournalEntry.createNew((Office)office, null, (GLAccount)account, (String)currencyCode, (String)modifiedTransactionId, (boolean)false, (LocalDate)transactionDate, (JournalEntryType)JournalEntryType.DEBIT, (BigDecimal)amount, null, (Integer)PortfolioProductType.CLIENT.getValue(), (Long)clientId, null, null, null, (Long)transactionId, null);
        this.persistJournalEntry(journalEntry);
    }

    public void createJournalEntriesForShares(Office office, String currencyCode, int accountTypeToDebitId, int accountTypeToCreditId, Long shareProductId, Long paymentTypeId, Long shareAccountId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        this.createDebitJournalEntryForShares(office, currencyCode, accountTypeToDebitId, shareProductId, paymentTypeId, shareAccountId, transactionId, transactionDate, amount);
        this.createCreditJournalEntryForShares(office, currencyCode, accountTypeToCreditId, shareProductId, paymentTypeId, shareAccountId, transactionId, transactionDate, amount);
    }

    public void createDebitJournalEntryForShares(Office office, String currencyCode, int accountTypeToDebitId, Long shareProductId, Long paymentTypeId, Long shareAccountId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        GLAccount debitAccount = this.getLinkedGLAccountForShareProduct(shareProductId, accountTypeToDebitId, paymentTypeId);
        this.createDebitJournalEntryForShares(office, currencyCode, debitAccount, shareAccountId, transactionId, transactionDate, amount);
    }

    public void createCreditJournalEntryForShares(Office office, String currencyCode, int accountTypeToCreditId, Long shareProductId, Long paymentTypeId, Long shareAccountId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        GLAccount creditAccount = this.getLinkedGLAccountForShareProduct(shareProductId, accountTypeToCreditId, paymentTypeId);
        this.createCreditJournalEntryForShares(office, currencyCode, creditAccount, shareAccountId, transactionId, transactionDate, amount);
    }

    public void createCashBasedJournalEntriesForSharesCharges(Office office, String currencyCode, AccountingConstants.CashAccountsForShares accountTypeToBeDebited, AccountingConstants.CashAccountsForShares accountTypeToBeCredited, Long shareProductId, Long paymentTypeId, Long shareAccountId, String transactionId, LocalDate transactionDate, BigDecimal totalAmount, List<ChargePaymentDTO> chargePaymentDTOs) {
        this.createDebitJournalEntryForShares(office, currencyCode, accountTypeToBeDebited.getValue().intValue(), shareProductId, paymentTypeId, shareAccountId, transactionId, transactionDate, totalAmount);
        this.createCashBasedJournalEntryForSharesCharges(office, currencyCode, accountTypeToBeCredited, shareProductId, shareAccountId, transactionId, transactionDate, totalAmount, chargePaymentDTOs);
    }

    public void createCashBasedJournalEntryForSharesCharges(Office office, String currencyCode, AccountingConstants.CashAccountsForShares accountTypeToBeCredited, Long shareProductId, Long shareAccountId, String transactionId, LocalDate transactionDate, BigDecimal totalAmount, List<ChargePaymentDTO> chargePaymentDTOs) {
        LinkedHashMap<GLAccount, BigDecimal> creditDetailsMap = new LinkedHashMap<GLAccount, BigDecimal>();
        for (ChargePaymentDTO chargePaymentDTO : chargePaymentDTOs) {
            GLAccount chargeSpecificAccount = this.getLinkedGLAccountForShareCharges(shareProductId, accountTypeToBeCredited.getValue().intValue(), chargePaymentDTO.getChargeId());
            BigDecimal chargeSpecificAmount = chargePaymentDTO.getAmount();
            if (creditDetailsMap.containsKey(chargeSpecificAccount)) {
                BigDecimal existingAmount = (BigDecimal)creditDetailsMap.get(chargeSpecificAccount);
                chargeSpecificAmount = chargeSpecificAmount.add(existingAmount);
            }
            creditDetailsMap.put(chargeSpecificAccount, chargeSpecificAmount);
        }
        BigDecimal totalCreditedAmount = BigDecimal.ZERO;
        for (Map.Entry entry : creditDetailsMap.entrySet()) {
            GLAccount account = (GLAccount)entry.getKey();
            BigDecimal amount = (BigDecimal)entry.getValue();
            totalCreditedAmount = totalCreditedAmount.add(amount);
            this.createCreditJournalEntryForShares(office, currencyCode, account, shareAccountId, transactionId, transactionDate, amount);
        }
        if (totalAmount.compareTo(totalCreditedAmount) != 0) {
            throw new PlatformDataIntegrityException("Recent Portfolio changes w.r.t Charges for shares have Broken the accounting code", "Recent Portfolio changes w.r.t Charges for shares have Broken the accounting code", new Object[0]);
        }
    }

    public void revertCashBasedJournalEntryForSharesCharges(Office office, String currencyCode, AccountingConstants.CashAccountsForShares accountTypeToBeCredited, Long shareProductId, Long shareAccountId, String transactionId, LocalDate transactionDate, BigDecimal totalAmount, List<ChargePaymentDTO> chargePaymentDTOs) {
        LinkedHashMap<GLAccount, BigDecimal> creditDetailsMap = new LinkedHashMap<GLAccount, BigDecimal>();
        for (ChargePaymentDTO chargePaymentDTO : chargePaymentDTOs) {
            GLAccount chargeSpecificAccount = this.getLinkedGLAccountForShareCharges(shareProductId, accountTypeToBeCredited.getValue().intValue(), chargePaymentDTO.getChargeId());
            BigDecimal chargeSpecificAmount = chargePaymentDTO.getAmount();
            if (creditDetailsMap.containsKey(chargeSpecificAccount)) {
                BigDecimal existingAmount = (BigDecimal)creditDetailsMap.get(chargeSpecificAccount);
                chargeSpecificAmount = chargeSpecificAmount.add(existingAmount);
            }
            creditDetailsMap.put(chargeSpecificAccount, chargeSpecificAmount);
        }
        BigDecimal totalCreditedAmount = BigDecimal.ZERO;
        for (Map.Entry entry : creditDetailsMap.entrySet()) {
            GLAccount account = (GLAccount)entry.getKey();
            BigDecimal amount = (BigDecimal)entry.getValue();
            totalCreditedAmount = totalCreditedAmount.add(amount);
            this.createDebitJournalEntryForShares(office, currencyCode, account, shareAccountId, transactionId, transactionDate, amount);
        }
        if (totalAmount.compareTo(totalCreditedAmount) != 0) {
            throw new PlatformDataIntegrityException("Recent Portfolio changes w.r.t Charges for shares have Broken the accounting code", "Recent Portfolio changes w.r.t Charges for shares have Broken the accounting code", new Object[0]);
        }
    }

    private void createDebitJournalEntryForShares(Office office, String currencyCode, GLAccount account, Long shareAccountId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        boolean manualEntry = false;
        Long shareTransactionId = null;
        Object modifiedTransactionId = transactionId;
        if (StringUtils.isNumeric((CharSequence)transactionId)) {
            shareTransactionId = Long.parseLong(transactionId);
            modifiedTransactionId = SHARE_TRANSACTION_IDENTIFIER + transactionId;
        }
        JournalEntry journalEntry = JournalEntry.createNew((Office)office, null, (GLAccount)account, (String)currencyCode, (String)modifiedTransactionId, (boolean)false, (LocalDate)transactionDate, (JournalEntryType)JournalEntryType.DEBIT, (BigDecimal)amount, null, (Integer)PortfolioProductType.SHARES.getValue(), (Long)shareAccountId, null, null, null, null, (Long)shareTransactionId);
        this.persistJournalEntry(journalEntry);
    }

    private void createCreditJournalEntryForShares(Office office, String currencyCode, GLAccount account, Long shareAccountId, String transactionId, LocalDate transactionDate, BigDecimal amount) {
        boolean manualEntry = false;
        Long shareTransactionId = null;
        Object modifiedTransactionId = transactionId;
        if (StringUtils.isNumeric((CharSequence)transactionId)) {
            shareTransactionId = Long.parseLong(transactionId);
            modifiedTransactionId = SHARE_TRANSACTION_IDENTIFIER + transactionId;
        }
        JournalEntry journalEntry = JournalEntry.createNew((Office)office, null, (GLAccount)account, (String)currencyCode, (String)modifiedTransactionId, (boolean)false, (LocalDate)transactionDate, (JournalEntryType)JournalEntryType.CREDIT, (BigDecimal)amount, null, (Integer)PortfolioProductType.SHARES.getValue(), (Long)shareAccountId, null, null, null, null, (Long)shareTransactionId);
        this.persistJournalEntry(journalEntry);
    }

    public GLAccount getLinkedGLAccountForLoanProduct(Long loanProductId, int accountMappingTypeId, Long paymentTypeId) {
        GLAccount glAccount;
        if (this.isOrganizationAccount(accountMappingTypeId)) {
            FinancialActivityAccount financialActivityAccount = this.financialActivityAccountRepository.findByFinancialActivityTypeWithNotFoundDetection(accountMappingTypeId);
            glAccount = financialActivityAccount.getGlAccount();
        } else {
            ProductToGLAccountMapping paymentChannelSpecificAccountMapping;
            ProductToGLAccountMapping accountMapping = this.accountMappingRepository.findCoreProductToFinAccountMapping(loanProductId, PortfolioProductType.LOAN.getValue().intValue(), accountMappingTypeId);
            if (accountMappingTypeId == AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue() && (paymentChannelSpecificAccountMapping = this.accountMappingRepository.findByProductIdAndProductTypeAndFinancialAccountTypeAndPaymentTypeId(loanProductId, PortfolioProductType.LOAN.getValue().intValue(), accountMappingTypeId, paymentTypeId)) != null) {
                accountMapping = paymentChannelSpecificAccountMapping;
            }
            if (accountMapping == null) {
                throw new ProductToGLAccountMappingNotFoundException(PortfolioProductType.LOAN, loanProductId, AccountingConstants.AccrualAccountsForLoan.fromInt((int)accountMappingTypeId).toString());
            }
            glAccount = accountMapping.getGlAccount();
        }
        return glAccount;
    }

    private GLAccount getLinkedGLAccountForLoanCharges(Long loanProductId, int accountMappingTypeId, Long chargeId) {
        ProductToGLAccountMapping chargeSpecificAccountMapping;
        ProductToGLAccountMapping accountMapping = this.accountMappingRepository.findCoreProductToFinAccountMapping(loanProductId, PortfolioProductType.LOAN.getValue().intValue(), accountMappingTypeId);
        if (chargeId != null && (chargeSpecificAccountMapping = this.accountMappingRepository.findProductIdAndProductTypeAndFinancialAccountTypeAndChargeId(loanProductId, PortfolioProductType.LOAN.getValue().intValue(), accountMappingTypeId, chargeId)) != null) {
            accountMapping = chargeSpecificAccountMapping;
        }
        return accountMapping.getGlAccount();
    }

    private GLAccount getLinkedGLAccountForSavingsCharges(Long savingsProductId, int accountMappingTypeId, Long chargeId) {
        ProductToGLAccountMapping accountMapping = this.accountMappingRepository.findCoreProductToFinAccountMapping(savingsProductId, PortfolioProductType.SAVING.getValue().intValue(), accountMappingTypeId);
        if (accountMappingTypeId == AccountingConstants.CashAccountsForSavings.INCOME_FROM_FEES.getValue() || accountMappingTypeId == AccountingConstants.CashAccountsForLoan.INCOME_FROM_PENALTIES.getValue()) {
            GLAccount glAccount = this.chargeRepositoryWrapper.findOneWithNotFoundDetection(chargeId).getAccount();
            if (glAccount != null) {
                return glAccount;
            }
            ProductToGLAccountMapping chargeSpecificIncomeAccountMapping = this.accountMappingRepository.findProductIdAndProductTypeAndFinancialAccountTypeAndChargeId(savingsProductId, PortfolioProductType.SAVING.getValue().intValue(), accountMappingTypeId, chargeId);
            if (chargeSpecificIncomeAccountMapping != null) {
                accountMapping = chargeSpecificIncomeAccountMapping;
            }
        }
        return accountMapping.getGlAccount();
    }

    private GLAccount getLinkedGLAccountForSavingsProduct(Long savingsProductId, int accountMappingTypeId, Long paymentTypeId) {
        GLAccount glAccount;
        if (this.isOrganizationAccount(accountMappingTypeId)) {
            FinancialActivityAccount financialActivityAccount = this.financialActivityAccountRepository.findByFinancialActivityTypeWithNotFoundDetection(accountMappingTypeId);
            glAccount = financialActivityAccount.getGlAccount();
        } else {
            ProductToGLAccountMapping paymentChannelSpecificAccountMapping;
            ProductToGLAccountMapping accountMapping = this.accountMappingRepository.findCoreProductToFinAccountMapping(savingsProductId, PortfolioProductType.SAVING.getValue().intValue(), accountMappingTypeId);
            if (accountMappingTypeId == AccountingConstants.CashAccountsForSavings.SAVINGS_REFERENCE.getValue() && (paymentChannelSpecificAccountMapping = this.accountMappingRepository.findByProductIdAndProductTypeAndFinancialAccountTypeAndPaymentTypeId(savingsProductId, PortfolioProductType.SAVING.getValue().intValue(), accountMappingTypeId, paymentTypeId)) != null) {
                accountMapping = paymentChannelSpecificAccountMapping;
            }
            glAccount = accountMapping.getGlAccount();
        }
        return glAccount;
    }

    private GLAccount getLinkedGLAccountForShareProduct(Long shareProductId, int accountMappingTypeId, Long paymentTypeId) {
        GLAccount glAccount;
        if (this.isOrganizationAccount(accountMappingTypeId)) {
            FinancialActivityAccount financialActivityAccount = this.financialActivityAccountRepository.findByFinancialActivityTypeWithNotFoundDetection(accountMappingTypeId);
            glAccount = financialActivityAccount.getGlAccount();
        } else {
            ProductToGLAccountMapping paymentChannelSpecificAccountMapping;
            ProductToGLAccountMapping accountMapping = this.accountMappingRepository.findCoreProductToFinAccountMapping(shareProductId, PortfolioProductType.SHARES.getValue().intValue(), accountMappingTypeId);
            if (accountMappingTypeId == AccountingConstants.CashAccountsForShares.SHARES_REFERENCE.getValue() && (paymentChannelSpecificAccountMapping = this.accountMappingRepository.findByProductIdAndProductTypeAndFinancialAccountTypeAndPaymentTypeId(shareProductId, PortfolioProductType.SHARES.getValue().intValue(), accountMappingTypeId, paymentTypeId)) != null) {
                accountMapping = paymentChannelSpecificAccountMapping;
            }
            glAccount = accountMapping.getGlAccount();
        }
        return glAccount;
    }

    private GLAccount getLinkedGLAccountForShareCharges(Long shareProductId, int accountMappingTypeId, Long chargeId) {
        ProductToGLAccountMapping accountMapping = this.accountMappingRepository.findCoreProductToFinAccountMapping(shareProductId, PortfolioProductType.SHARES.getValue().intValue(), accountMappingTypeId);
        ProductToGLAccountMapping chargeSpecificIncomeAccountMapping = this.accountMappingRepository.findProductIdAndProductTypeAndFinancialAccountTypeAndChargeId(shareProductId, PortfolioProductType.SHARES.getValue().intValue(), accountMappingTypeId, chargeId);
        if (chargeSpecificIncomeAccountMapping != null) {
            accountMapping = chargeSpecificIncomeAccountMapping;
        }
        return accountMapping.getGlAccount();
    }

    private boolean isOrganizationAccount(int accountMappingTypeId) {
        return AccountingConstants.FinancialActivity.fromInt((int)accountMappingTypeId) != null;
    }

    public BigDecimal createCreditJournalEntryOrReversalForClientPayments(Office office, String currencyCode, Long clientId, Long transactionId, LocalDate transactionDate, Boolean isReversal, List<ClientChargePaymentDTO> clientChargePaymentDTOs) {
        LinkedHashMap<Long, BigDecimal> creditDetailsMap = new LinkedHashMap<Long, BigDecimal>();
        for (ClientChargePaymentDTO clientChargePaymentDTO : clientChargePaymentDTOs) {
            if (clientChargePaymentDTO.getIncomeAccountId() == null) continue;
            Long accountId = clientChargePaymentDTO.getIncomeAccountId();
            BigDecimal chargeSpecificAmount = clientChargePaymentDTO.getAmount();
            if (creditDetailsMap.containsKey(accountId)) {
                BigDecimal existingAmount = (BigDecimal)creditDetailsMap.get(accountId);
                chargeSpecificAmount = chargeSpecificAmount.add(existingAmount);
            }
            creditDetailsMap.put(accountId, chargeSpecificAmount);
        }
        BigDecimal totalCreditedAmount = BigDecimal.ZERO;
        for (Map.Entry entry : creditDetailsMap.entrySet()) {
            GLAccount account = this.getGLAccountById((Long)entry.getKey());
            BigDecimal amount = (BigDecimal)entry.getValue();
            totalCreditedAmount = totalCreditedAmount.add(amount);
            if (isReversal.booleanValue()) {
                this.createDebitJournalEntryForClientPayments(office, currencyCode, account, clientId, transactionId, transactionDate, amount);
                continue;
            }
            this.createCreditJournalEntryForClientPayments(office, currencyCode, account, clientId, transactionId, transactionDate, amount);
        }
        return totalCreditedAmount;
    }

    public void createDebitJournalEntryOrReversalForClientChargePayments(Office office, String currencyCode, Long clientId, Long transactionId, LocalDate transactionDate, BigDecimal amount, Boolean isReversal) {
        GLAccount account = this.financialActivityAccountRepository.findByFinancialActivityTypeWithNotFoundDetection(AccountingConstants.FinancialActivity.ASSET_FUND_SOURCE.getValue().intValue()).getGlAccount();
        if (isReversal.booleanValue()) {
            this.createCreditJournalEntryForClientPayments(office, currencyCode, account, clientId, transactionId, transactionDate, amount);
        } else {
            this.createDebitJournalEntryForClientPayments(office, currencyCode, account, clientId, transactionId, transactionDate, amount);
        }
    }

    private GLAccount getGLAccountById(Long accountId) {
        return (GLAccount)this.glAccountRepository.getReferenceById((Object)accountId);
    }

    public Integer getValueForFeeOrPenaltyIncomeAccount(String chargeRefundChargeType) {
        if (chargeRefundChargeType == null || !chargeRefundChargeType.equalsIgnoreCase(PROVISIONING_TRANSACTION_IDENTIFIER) && !chargeRefundChargeType.equalsIgnoreCase("F")) {
            String errorValue = Objects.requireNonNullElse(chargeRefundChargeType, "Null");
            throw new PlatformDataIntegrityException("error.msg.chargeRefundChargeType.can.only.be.P.or.F", "chargeRefundChargeType can only be P (Penalty) or F(Fee) - Value is: " + errorValue, new Object[0]);
        }
        Integer incomeAccount = chargeRefundChargeType.equalsIgnoreCase(PROVISIONING_TRANSACTION_IDENTIFIER) ? AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_PENALTIES.getValue() : AccountingConstants.AccrualAccountsForLoan.INCOME_FROM_FEES.getValue();
        return incomeAccount;
    }

    public JournalEntry persistJournalEntry(JournalEntry journalEntry) {
        boolean isNew = journalEntry.isNew();
        JournalEntry savedJournalEntry = (JournalEntry)this.glJournalEntryRepository.saveAndFlush((Object)journalEntry);
        if (isNew && journalEntry.getLoanTransactionId() != null) {
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanJournalEntryCreatedBusinessEvent(savedJournalEntry));
        }
        return savedJournalEntry;
    }

    private void createJournalEntriesForLoanChargesInternal(Office office, String currencyCode, int accountMappingTypeId, Long loanProductId, Long loanId, String transactionId, LocalDate transactionDate, BigDecimal totalAmount, List<ChargePaymentDTO> chargePaymentDTOs, boolean isCredit) {
        BigDecimal amount;
        GLAccount account;
        LinkedHashMap<GLAccount, BigDecimal> creditDetailsMap = new LinkedHashMap<GLAccount, BigDecimal>();
        for (ChargePaymentDTO chargePaymentDTO : chargePaymentDTOs) {
            Long chargeId = chargePaymentDTO.getChargeId();
            account = this.getLinkedGLAccountForLoanCharges(loanProductId, accountMappingTypeId, chargeId);
            amount = chargePaymentDTO.getAmount();
            creditDetailsMap.merge(account, amount, BigDecimal::add);
        }
        BigDecimal totalCreditedAmount = BigDecimal.ZERO;
        for (Map.Entry entry : creditDetailsMap.entrySet()) {
            account = (GLAccount)entry.getKey();
            amount = (BigDecimal)entry.getValue();
            totalCreditedAmount = totalCreditedAmount.add(amount);
            if (isCredit) {
                this.createCreditJournalEntryForLoan(office, currencyCode, account, loanId, transactionId, transactionDate, amount);
                continue;
            }
            this.createDebitJournalEntryForLoan(office, currencyCode, account, loanId, transactionId, transactionDate, amount);
        }
        if (totalAmount.compareTo(totalCreditedAmount) != 0) {
            throw new PlatformDataIntegrityException("Meltdown in advanced accounting...sum of all charges is not equal to the fee charge for a transaction", "Meltdown in advanced accounting...sum of all charges is not equal to the fee charge for a transaction", new Object[]{totalCreditedAmount, totalAmount});
        }
    }

    @Generated
    public AccountingProcessorHelper(JournalEntryRepository glJournalEntryRepository, ProductToGLAccountMappingRepository accountMappingRepository, FinancialActivityAccountRepositoryWrapper financialActivityAccountRepository, GLClosureRepository closureRepository, GLAccountRepository glAccountRepository, OfficeRepository officeRepository, AccountTransfersReadPlatformService accountTransfersReadPlatformService, ChargeRepositoryWrapper chargeRepositoryWrapper, BusinessEventNotifierService businessEventNotifierService) {
        this.glJournalEntryRepository = glJournalEntryRepository;
        this.accountMappingRepository = accountMappingRepository;
        this.financialActivityAccountRepository = financialActivityAccountRepository;
        this.closureRepository = closureRepository;
        this.glAccountRepository = glAccountRepository;
        this.officeRepository = officeRepository;
        this.accountTransfersReadPlatformService = accountTransfersReadPlatformService;
        this.chargeRepositoryWrapper = chargeRepositoryWrapper;
        this.businessEventNotifierService = businessEventNotifierService;
    }
}

