package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.GetClientsClientIdTransactionsResponse;
import org.apache.fineract.client.models.GetClientsClientIdTransactionsTransactionIdResponse;
import org.apache.fineract.client.models.PostClientsClientIdTransactionsTransactionIdResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ClientTransactionApi {
    /**
    * List Client Transactions
    * The list capability of client transaction can support pagination.  Example Requests:  clients/189/transactions  clients/189/transactions?offset&#x3D;10&amp;limit&#x3D;50
        * @param clientId clientId (required)
        * @param offset offset (optional)
        * @param limit limit (optional)
    * @return Call&lt;GetClientsClientIdTransactionsResponse&gt;
    */
    @GET("v1/clients/{clientId}/transactions")
    Call<GetClientsClientIdTransactionsResponse> retrieveAllClientTransactions(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit);

    /**
    * List Client Transactions
    * The list capability of client transaction can support pagination.  Example Requests:  clients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions  clients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?offset&#x3D;10&amp;limit&#x3D;50
        * @param clientExternalId clientExternalId (required)
        * @param offset offset (optional)
        * @param limit limit (optional)
    * @return Call&lt;GetClientsClientIdTransactionsResponse&gt;
    */
    @GET("v1/clients/external-id/{clientExternalId}/transactions")
    Call<GetClientsClientIdTransactionsResponse> retrieveAllClientTransactions1(@retrofit2.http.Path("clientExternalId") String clientExternalId, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit);

    /**
    * Retrieve a Client Transaction
    * Example Requests: clients/1/transactions/1   clients/1/transactions/1?fields&#x3D;id,officeName
        * @param clientId clientId (required)
        * @param transactionId transactionId (required)
    * @return Call&lt;GetClientsClientIdTransactionsTransactionIdResponse&gt;
    */
    @GET("v1/clients/{clientId}/transactions/{transactionId}")
    Call<GetClientsClientIdTransactionsTransactionIdResponse> retrieveClientTransaction(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Path("transactionId") Long transactionId);

    /**
    * Retrieve a Client Transaction
    * Example Requests: clients/1/transactions/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854   clients/1/transactions/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?fields&#x3D;id,officeName
        * @param clientId clientId (required)
        * @param transactionExternalId transactionExternalId (required)
    * @return Call&lt;GetClientsClientIdTransactionsTransactionIdResponse&gt;
    */
    @GET("v1/clients/{clientId}/transactions/external-id/{transactionExternalId}")
    Call<GetClientsClientIdTransactionsTransactionIdResponse> retrieveClientTransaction1(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Path("transactionExternalId") String transactionExternalId);

    /**
    * Retrieve a Client Transaction
    * Example Requests: clients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions/1   clients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions/1?fields&#x3D;id,officeName
        * @param clientExternalId clientExternalId (required)
        * @param transactionId transactionId (required)
    * @return Call&lt;GetClientsClientIdTransactionsTransactionIdResponse&gt;
    */
    @GET("v1/clients/external-id/{clientExternalId}/transactions/{transactionId}")
    Call<GetClientsClientIdTransactionsTransactionIdResponse> retrieveClientTransaction2(@retrofit2.http.Path("clientExternalId") String clientExternalId, @retrofit2.http.Path("transactionId") Long transactionId);

    /**
    * Retrieve a Client Transaction
    * Example Requests: clients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854   clients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?fields&#x3D;id,officeName
        * @param clientExternalId clientExternalId (required)
        * @param transactionExternalId transactionExternalId (required)
    * @return Call&lt;GetClientsClientIdTransactionsTransactionIdResponse&gt;
    */
    @GET("v1/clients/external-id/{clientExternalId}/transactions/external-id/{transactionExternalId}")
    Call<GetClientsClientIdTransactionsTransactionIdResponse> retrieveClientTransaction3(@retrofit2.http.Path("clientExternalId") String clientExternalId, @retrofit2.http.Path("transactionExternalId") String transactionExternalId);

    /**
    * Undo a Client Transaction
    * Undoes a Client Transaction
        * @param clientId clientId (required)
        * @param transactionId transactionId (required)
        * @param command command (optional)
    * @return Call&lt;PostClientsClientIdTransactionsTransactionIdResponse&gt;
    */
    @POST("v1/clients/{clientId}/transactions/{transactionId}")
    Call<PostClientsClientIdTransactionsTransactionIdResponse> undoClientTransaction(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Query("command") String command);

    /**
    * Undo a Client Transaction
    * Undoes a Client Transaction
        * @param clientId clientId (required)
        * @param transactionExternalId transactionExternalId (required)
        * @param command command (optional)
    * @return Call&lt;PostClientsClientIdTransactionsTransactionIdResponse&gt;
    */
    @POST("v1/clients/{clientId}/transactions/external-id/{transactionExternalId}")
    Call<PostClientsClientIdTransactionsTransactionIdResponse> undoClientTransaction1(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Path("transactionExternalId") String transactionExternalId, @retrofit2.http.Query("command") String command);

    /**
    * Undo a Client Transaction
    * Undoes a Client Transaction
        * @param clientExternalId clientExternalId (required)
        * @param transactionId transactionId (required)
        * @param command command (optional)
    * @return Call&lt;PostClientsClientIdTransactionsTransactionIdResponse&gt;
    */
    @POST("v1/clients/external-id/{clientExternalId}/transactions/{transactionId}")
    Call<PostClientsClientIdTransactionsTransactionIdResponse> undoClientTransaction2(@retrofit2.http.Path("clientExternalId") String clientExternalId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Query("command") String command);

    /**
    * Undo a Client Transaction
    * Undoes a Client Transaction
        * @param clientExternalId clientExternalId (required)
        * @param transactionExternalId transactionExternalId (required)
        * @param command command (optional)
    * @return Call&lt;PostClientsClientIdTransactionsTransactionIdResponse&gt;
    */
    @POST("v1/clients/external-id/{clientExternalId}/transactions/external-id/{transactionExternalId}")
    Call<PostClientsClientIdTransactionsTransactionIdResponse> undoClientTransaction3(@retrofit2.http.Path("clientExternalId") String clientExternalId, @retrofit2.http.Path("transactionExternalId") String transactionExternalId, @retrofit2.http.Query("command") String command);



        /**
        * List Client Transactions
        * The list capability of client transaction can support pagination.  Example Requests:  clients/189/transactions  clients/189/transactions?offset&#x3D;10&amp;limit&#x3D;50
            * @param clientId clientId (required)
            * @param offset offset (optional)
            * @param limit limit (optional)
        * @return Call&lt;GetClientsClientIdTransactionsResponse&gt;
        */
    @GET("v1/clients/{clientId}/transactions")
    Call<GetClientsClientIdTransactionsResponse> retrieveAllClientTransactions(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @HeaderMap Map<String, String> headers);

        /**
        * List Client Transactions
        * The list capability of client transaction can support pagination.  Example Requests:  clients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions  clients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions?offset&#x3D;10&amp;limit&#x3D;50
            * @param clientExternalId clientExternalId (required)
            * @param offset offset (optional)
            * @param limit limit (optional)
        * @return Call&lt;GetClientsClientIdTransactionsResponse&gt;
        */
    @GET("v1/clients/external-id/{clientExternalId}/transactions")
    Call<GetClientsClientIdTransactionsResponse> retrieveAllClientTransactions1(@retrofit2.http.Path("clientExternalId") String clientExternalId, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Client Transaction
        * Example Requests: clients/1/transactions/1   clients/1/transactions/1?fields&#x3D;id,officeName
            * @param clientId clientId (required)
            * @param transactionId transactionId (required)
        * @return Call&lt;GetClientsClientIdTransactionsTransactionIdResponse&gt;
        */
    @GET("v1/clients/{clientId}/transactions/{transactionId}")
    Call<GetClientsClientIdTransactionsTransactionIdResponse> retrieveClientTransaction(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Path("transactionId") Long transactionId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Client Transaction
        * Example Requests: clients/1/transactions/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854   clients/1/transactions/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?fields&#x3D;id,officeName
            * @param clientId clientId (required)
            * @param transactionExternalId transactionExternalId (required)
        * @return Call&lt;GetClientsClientIdTransactionsTransactionIdResponse&gt;
        */
    @GET("v1/clients/{clientId}/transactions/external-id/{transactionExternalId}")
    Call<GetClientsClientIdTransactionsTransactionIdResponse> retrieveClientTransaction1(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Path("transactionExternalId") String transactionExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Client Transaction
        * Example Requests: clients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions/1   clients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions/1?fields&#x3D;id,officeName
            * @param clientExternalId clientExternalId (required)
            * @param transactionId transactionId (required)
        * @return Call&lt;GetClientsClientIdTransactionsTransactionIdResponse&gt;
        */
    @GET("v1/clients/external-id/{clientExternalId}/transactions/{transactionId}")
    Call<GetClientsClientIdTransactionsTransactionIdResponse> retrieveClientTransaction2(@retrofit2.http.Path("clientExternalId") String clientExternalId, @retrofit2.http.Path("transactionId") Long transactionId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Client Transaction
        * Example Requests: clients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854   clients/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854/transactions/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?fields&#x3D;id,officeName
            * @param clientExternalId clientExternalId (required)
            * @param transactionExternalId transactionExternalId (required)
        * @return Call&lt;GetClientsClientIdTransactionsTransactionIdResponse&gt;
        */
    @GET("v1/clients/external-id/{clientExternalId}/transactions/external-id/{transactionExternalId}")
    Call<GetClientsClientIdTransactionsTransactionIdResponse> retrieveClientTransaction3(@retrofit2.http.Path("clientExternalId") String clientExternalId, @retrofit2.http.Path("transactionExternalId") String transactionExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Undo a Client Transaction
        * Undoes a Client Transaction
            * @param clientId clientId (required)
            * @param transactionId transactionId (required)
            * @param command command (optional)
        * @return Call&lt;PostClientsClientIdTransactionsTransactionIdResponse&gt;
        */
    @POST("v1/clients/{clientId}/transactions/{transactionId}")
    Call<PostClientsClientIdTransactionsTransactionIdResponse> undoClientTransaction(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Undo a Client Transaction
        * Undoes a Client Transaction
            * @param clientId clientId (required)
            * @param transactionExternalId transactionExternalId (required)
            * @param command command (optional)
        * @return Call&lt;PostClientsClientIdTransactionsTransactionIdResponse&gt;
        */
    @POST("v1/clients/{clientId}/transactions/external-id/{transactionExternalId}")
    Call<PostClientsClientIdTransactionsTransactionIdResponse> undoClientTransaction1(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Path("transactionExternalId") String transactionExternalId, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Undo a Client Transaction
        * Undoes a Client Transaction
            * @param clientExternalId clientExternalId (required)
            * @param transactionId transactionId (required)
            * @param command command (optional)
        * @return Call&lt;PostClientsClientIdTransactionsTransactionIdResponse&gt;
        */
    @POST("v1/clients/external-id/{clientExternalId}/transactions/{transactionId}")
    Call<PostClientsClientIdTransactionsTransactionIdResponse> undoClientTransaction2(@retrofit2.http.Path("clientExternalId") String clientExternalId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Undo a Client Transaction
        * Undoes a Client Transaction
            * @param clientExternalId clientExternalId (required)
            * @param transactionExternalId transactionExternalId (required)
            * @param command command (optional)
        * @return Call&lt;PostClientsClientIdTransactionsTransactionIdResponse&gt;
        */
    @POST("v1/clients/external-id/{clientExternalId}/transactions/external-id/{transactionExternalId}")
    Call<PostClientsClientIdTransactionsTransactionIdResponse> undoClientTransaction3(@retrofit2.http.Path("clientExternalId") String clientExternalId, @retrofit2.http.Path("transactionExternalId") String transactionExternalId, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);


}
