/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.spm.service;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.spm.data.ScorecardData;
import org.apache.fineract.spm.data.ScorecardValue;
import org.apache.fineract.spm.service.ScorecardReadPlatformService;
import org.apache.fineract.spm.service.ScorecardReadPlatformServiceImpl;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ScorecardReadPlatformServiceImpl
implements ScorecardReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;

    List<ScorecardValue> getScorecardValueBySurveyAndClient(Long surveyId, Long clientId) {
        ScorecardValueMapper scvm = new ScorecardValueMapper();
        String sql = "select " + scvm.schema();
        return this.jdbcTemplate.query(sql, (RowMapper)scvm, new Object[]{surveyId, clientId});
    }

    Collection<ScorecardData> updateScorecardValues(Collection<ScorecardData> scorecard) {
        for (ScorecardData scorecardData : scorecard) {
            scorecardData.setScorecardValues(this.getScorecardValueBySurveyAndClient(scorecardData.getSurveyId(), scorecardData.getClientId()));
        }
        return scorecard;
    }

    public Collection<ScorecardData> retrieveScorecardBySurvey(Long surveyId) {
        this.context.authenticatedUser();
        ScorecardMapper scm = new ScorecardMapper();
        String sql = "select " + scm.schema() + " where sc.survey_id = ?  group by sc.survey_id, sc.client_id, sc.id ";
        List scorecardDatas = this.jdbcTemplate.query(sql, (RowMapper)scm, new Object[]{surveyId});
        this.updateScorecardValues((Collection)scorecardDatas);
        return scorecardDatas;
    }

    public Collection<ScorecardData> retrieveScorecardByClient(Long clientId) {
        this.context.authenticatedUser();
        ScorecardMapper scm = new ScorecardMapper();
        String sql = "select " + scm.schema() + " where sc.client_id = ?  group by sc.survey_id, sc.client_id, sc.id ";
        List scorecardDatas = this.jdbcTemplate.query(sql, (RowMapper)scm, new Object[]{clientId});
        this.updateScorecardValues((Collection)scorecardDatas);
        return scorecardDatas;
    }

    public Collection<ScorecardData> retrieveScorecardBySurveyAndClient(Long surveyId, Long clientId) {
        this.context.authenticatedUser();
        ScorecardMapper scm = new ScorecardMapper();
        String sql = "select " + scm.schema() + " where sc.survey_id = ? and sc.client_id = ?  group by sc.survey_id, sc.client_id, sc.id ";
        List scorecardDatas = this.jdbcTemplate.query(sql, (RowMapper)scm, new Object[]{surveyId, clientId});
        this.updateScorecardValues((Collection)scorecardDatas);
        return scorecardDatas;
    }

    @Generated
    public ScorecardReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
    }
}

