/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareaccounts.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Set;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.portfolio.shareaccounts.domain.PurchasedSharesStatusType;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccount;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountCharge;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountChargePaidBy;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_share_account_transactions")
public class ShareAccountTransaction
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    @ManyToOne(optional=false)
    @JoinColumn(name="account_id", referencedColumnName="id", nullable=false)
    private ShareAccount shareAccount;
    @Column(name="transaction_date")
    private LocalDate transactionDate;
    @Column(name="total_shares")
    private Long totalShares;
    @Column(name="unit_price")
    private BigDecimal shareValue;
    @Column(name="amount")
    private BigDecimal amount;
    @Column(name="amount_paid")
    private BigDecimal amountPaid;
    @Column(name="charge_amount")
    private BigDecimal chargeAmount;
    @Column(name="status_enum", nullable=true)
    private Integer status;
    @Column(name="type_enum", nullable=true)
    private Integer type;
    @Column(name="is_active", nullable=false)
    private boolean active;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="shareAccountTransaction", orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<ShareAccountChargePaidBy> shareAccountChargesPaid;
    static final long serialVersionUID = -6529573490015147411L;

    protected ShareAccountTransaction() {
        this.active = true;
        this.shareAccountChargesPaid = new HashSet();
    }

    public void setShareAccount(ShareAccount shareAccount) {
        this._persistence_set_shareAccount(shareAccount);
    }

    public ShareAccountTransaction(LocalDate transactionDate, Long totalShares, BigDecimal shareValue) {
        this.active = true;
        this.shareAccountChargesPaid = new HashSet();
        this.transactionDate = transactionDate;
        this.totalShares = totalShares;
        this.shareValue = shareValue;
        this.status = PurchasedSharesStatusType.APPLIED.getValue();
        this.type = PurchasedSharesStatusType.PURCHASED.getValue();
        this.amount = shareValue.multiply(BigDecimal.valueOf(totalShares));
        this.amountPaid = new BigDecimal(this.amount.doubleValue());
    }

    private ShareAccountTransaction(LocalDate transactionDate, Long totalShares, BigDecimal shareValue, Integer status, Integer type, BigDecimal amount, BigDecimal chargeAmount, BigDecimal amountPaid) {
        this.active = true;
        this.shareAccountChargesPaid = new HashSet();
        this.transactionDate = transactionDate;
        this.totalShares = totalShares;
        this.shareValue = shareValue;
        this.status = status;
        this.type = type;
        this.amount = amount;
        this.chargeAmount = chargeAmount;
        this.amountPaid = amountPaid;
    }

    public static ShareAccountTransaction createRedeemTransaction(LocalDate transactionDate, Long totalShares, BigDecimal shareValue) {
        Integer status = PurchasedSharesStatusType.APPROVED.getValue();
        Integer type = PurchasedSharesStatusType.REDEEMED.getValue();
        BigDecimal amount = shareValue.multiply(BigDecimal.valueOf(totalShares));
        BigDecimal amountPaid = new BigDecimal(amount.doubleValue());
        return new ShareAccountTransaction(transactionDate, totalShares, shareValue, status, type, amount, null, amountPaid);
    }

    public static ShareAccountTransaction createChargeTransaction(LocalDate transactionDate, ShareAccountCharge charge) {
        Long totalShares = null;
        BigDecimal unitPrice = null;
        Integer status = PurchasedSharesStatusType.APPROVED.getValue();
        Integer type = PurchasedSharesStatusType.CHARGE_PAYMENT.getValue();
        BigDecimal amount = charge.percentageOrAmount();
        BigDecimal chargeAmount = null;
        BigDecimal amountPaid = null;
        return new ShareAccountTransaction(transactionDate, totalShares, unitPrice, status, type, amount, chargeAmount, amountPaid);
    }

    public LocalDate getPurchasedDate() {
        return this._persistence_get_transactionDate();
    }

    public Long getTotalShares() {
        return this._persistence_get_totalShares();
    }

    public BigDecimal getPurchasePrice() {
        return this._persistence_get_shareValue();
    }

    public void update(LocalDate purchasedDate, Long totalShares, BigDecimal shareValue) {
        this._persistence_set_transactionDate(purchasedDate);
        this._persistence_set_totalShares(totalShares);
        this._persistence_set_shareValue(shareValue);
        this._persistence_set_amount(shareValue.multiply(BigDecimal.valueOf(totalShares)));
        this._persistence_set_chargeAmount(BigDecimal.ZERO);
        this._persistence_set_status(PurchasedSharesStatusType.APPLIED.getValue());
    }

    public void approve() {
        this._persistence_set_status(PurchasedSharesStatusType.APPROVED.getValue());
    }

    public void undoApprove() {
        this._persistence_set_status(PurchasedSharesStatusType.APPLIED.getValue());
    }

    public void reject() {
        this._persistence_set_status(PurchasedSharesStatusType.REJECTED.getValue());
        if (this._persistence_get_chargeAmount() != null) {
            this._persistence_set_amount(this._persistence_get_amount().subtract(this._persistence_get_chargeAmount()));
        }
    }

    public boolean isPendingForApprovalTransaction() {
        return this._persistence_get_status().equals(PurchasedSharesStatusType.APPLIED.getValue()) && this._persistence_get_type().equals(PurchasedSharesStatusType.PURCHASED.getValue());
    }

    public boolean isPurchasTransaction() {
        return this._persistence_get_status().equals(PurchasedSharesStatusType.APPROVED.getValue()) && this._persistence_get_type().equals(PurchasedSharesStatusType.PURCHASED.getValue());
    }

    public boolean isRedeemTransaction() {
        return this._persistence_get_status().equals(PurchasedSharesStatusType.APPROVED.getValue()) && this._persistence_get_type().equals(PurchasedSharesStatusType.REDEEMED.getValue());
    }

    public boolean isChargeTransaction() {
        return this._persistence_get_status().equals(PurchasedSharesStatusType.APPROVED.getValue()) && this._persistence_get_type().equals(PurchasedSharesStatusType.CHARGE_PAYMENT.getValue());
    }

    public boolean isPurchaseRejectedTransaction() {
        return this._persistence_get_status().equals(PurchasedSharesStatusType.REJECTED.getValue()) && this._persistence_get_type().equals(PurchasedSharesStatusType.PURCHASED.getValue());
    }

    public void addShareAccountChargePaidBy(ShareAccountChargePaidBy chargePaidBy) {
        this._persistence_get_shareAccountChargesPaid().add(chargePaidBy);
    }

    public BigDecimal amount() {
        return this._persistence_get_amount();
    }

    public BigDecimal chargeAmount() {
        return this._persistence_get_chargeAmount();
    }

    public void updateChargeAmount(BigDecimal totalChargeAmount) {
        this._persistence_set_amount(this._persistence_get_amount().add(totalChargeAmount));
        this._persistence_set_chargeAmount(totalChargeAmount);
    }

    public void deductChargesFromTotalAmount(BigDecimal totalChargeAmount) {
        this._persistence_set_amount(this._persistence_get_amount().subtract(totalChargeAmount));
        this._persistence_set_chargeAmount(totalChargeAmount);
    }

    public Set<ShareAccountChargePaidBy> getChargesPaidBy() {
        return this._persistence_get_shareAccountChargesPaid();
    }

    public Integer getTransactionStatus() {
        return this._persistence_get_status();
    }

    public Integer getTransactionType() {
        return this._persistence_get_type();
    }

    public void updateAmountPaid(BigDecimal amountPaid) {
        this._persistence_set_amountPaid(amountPaid);
    }

    public void addAmountPaid(BigDecimal amountPaid) {
        if (this.isRedeemTransaction()) {
            this._persistence_set_amountPaid(this._persistence_get_amountPaid().subtract(amountPaid));
        } else if (this.isPurchasTransaction()) {
            this._persistence_set_amountPaid(this._persistence_get_amountPaid().add(amountPaid));
        }
    }

    public void resetAmountPaid() {
        this._persistence_set_amountPaid(BigDecimal.ZERO);
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
        if (!this._persistence_get_active()) {
            // empty if block
        }
    }

    public void updateTransactionDate(LocalDate transactionDate) {
        this._persistence_set_transactionDate(transactionDate);
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public BigDecimal shareValue() {
        return this._persistence_get_shareValue();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ShareAccountTransaction(persistenceObject);
    }

    public ShareAccountTransaction(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "amount") {
            return this.amount;
        }
        if (string == "shareValue") {
            return this.shareValue;
        }
        if (string == "amountPaid") {
            return this.amountPaid;
        }
        if (string == "shareAccount") {
            return this.shareAccount;
        }
        if (string == "shareAccountChargesPaid") {
            return this.shareAccountChargesPaid;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "chargeAmount") {
            return this.chargeAmount;
        }
        if (string == "transactionDate") {
            return this.transactionDate;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "totalShares") {
            return this.totalShares;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "shareValue") {
            this.shareValue = (BigDecimal)object;
            return;
        }
        if (string == "amountPaid") {
            this.amountPaid = (BigDecimal)object;
            return;
        }
        if (string == "shareAccount") {
            this.shareAccount = (ShareAccount)object;
            return;
        }
        if (string == "shareAccountChargesPaid") {
            this.shareAccountChargesPaid = (Set)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "chargeAmount") {
            this.chargeAmount = (BigDecimal)object;
            return;
        }
        if (string == "transactionDate") {
            this.transactionDate = (LocalDate)object;
            return;
        }
        if (string == "type") {
            this.type = (Integer)object;
            return;
        }
        if (string == "totalShares") {
            this.totalShares = (Long)object;
            return;
        }
        if (string == "status") {
            this.status = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this.amount = bigDecimal;
    }

    public BigDecimal _persistence_get_shareValue() {
        this._persistence_checkFetched("shareValue");
        return this.shareValue;
    }

    public void _persistence_set_shareValue(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("shareValue");
        this.shareValue = bigDecimal;
    }

    public BigDecimal _persistence_get_amountPaid() {
        this._persistence_checkFetched("amountPaid");
        return this.amountPaid;
    }

    public void _persistence_set_amountPaid(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amountPaid");
        this.amountPaid = bigDecimal;
    }

    public ShareAccount _persistence_get_shareAccount() {
        this._persistence_checkFetched("shareAccount");
        return this.shareAccount;
    }

    public void _persistence_set_shareAccount(ShareAccount shareAccount) {
        this._persistence_checkFetchedForSet("shareAccount");
        this.shareAccount = shareAccount;
    }

    public Set _persistence_get_shareAccountChargesPaid() {
        this._persistence_checkFetched("shareAccountChargesPaid");
        return this.shareAccountChargesPaid;
    }

    public void _persistence_set_shareAccountChargesPaid(Set set) {
        this._persistence_checkFetchedForSet("shareAccountChargesPaid");
        this.shareAccountChargesPaid = set;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this.active = bl;
    }

    public BigDecimal _persistence_get_chargeAmount() {
        this._persistence_checkFetched("chargeAmount");
        return this.chargeAmount;
    }

    public void _persistence_set_chargeAmount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("chargeAmount");
        this.chargeAmount = bigDecimal;
    }

    public LocalDate _persistence_get_transactionDate() {
        this._persistence_checkFetched("transactionDate");
        return this.transactionDate;
    }

    public void _persistence_set_transactionDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("transactionDate");
        this.transactionDate = localDate;
    }

    public Integer _persistence_get_type() {
        this._persistence_checkFetched("type");
        return this.type;
    }

    public void _persistence_set_type(Integer n) {
        this._persistence_checkFetchedForSet("type");
        this.type = n;
    }

    public Long _persistence_get_totalShares() {
        this._persistence_checkFetched("totalShares");
        return this.totalShares;
    }

    public void _persistence_set_totalShares(Long l) {
        this._persistence_checkFetchedForSet("totalShares");
        this.totalShares = l;
    }

    public Integer _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(Integer n) {
        this._persistence_checkFetchedForSet("status");
        this.status = n;
    }
}

