/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.pockets.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PocketDataValidator {
    private static final Set<String> LINKING_ACCOUNTS_SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("accountId", "accountType", "accountsDetail"));
    private static final Set<String> DELINKING_ACCOUNTS_SUPPORTED_PARAMETERS = new HashSet<String>(List.of("pocketAccountMappingIds"));
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public PocketDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForLinkingAccounts(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)LINKING_ACCOUNTS_SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("pockets");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        JsonArray accountsDetail = this.fromApiJsonHelper.extractJsonArrayNamed("accountsDetail", element);
        baseDataValidator.reset().parameter("accountsDetail").value((Object)accountsDetail).notNull().jsonArrayNotEmpty();
        List<String> valueList = Arrays.asList(EntityAccountType.LOAN.name().toLowerCase(), EntityAccountType.SAVINGS.name().toLowerCase(), EntityAccountType.SHARES.name().toLowerCase());
        for (JsonElement accountDetails : accountsDetail) {
            Long accountId = this.fromApiJsonHelper.extractLongNamed("accountId", accountDetails);
            baseDataValidator.reset().parameter("accountId").value((Object)accountId).notBlank();
            String accountType = this.fromApiJsonHelper.extractStringNamed("accountType", accountDetails);
            baseDataValidator.reset().parameter("accountType").value((Object)accountType).notBlank().isOneOfTheseStringValues(valueList);
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForDeLinkingAccounts(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)DELINKING_ACCOUNTS_SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("pockets");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        JsonArray pocketAccountMappingList = this.fromApiJsonHelper.extractJsonArrayNamed("pocketAccountMappingIds", element);
        baseDataValidator.reset().parameter("pocketAccountMappingIds").value((Object)pocketAccountMappingList).notNull().jsonArrayNotEmpty();
        for (JsonElement pocketAccountMapping : pocketAccountMappingList) {
            Long mappingId = pocketAccountMapping.getAsLong();
            baseDataValidator.reset().parameter("pocketAccountMappingId").value((Object)mappingId).notBlank();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }
}

