/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartReadPlatformService;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.data.DepositProductData;
import org.apache.fineract.portfolio.savings.data.FixedDepositProductData;
import org.apache.fineract.portfolio.savings.data.RecurringDepositProductData;
import org.apache.fineract.portfolio.savings.exception.FixedDepositProductNotFoundException;
import org.apache.fineract.portfolio.savings.service.DepositProductReadPlatformService;
import org.apache.fineract.portfolio.savings.service.DepositProductReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class DepositProductReadPlatformServiceImpl
implements DepositProductReadPlatformService {
    private static final FixedDepositProductMapper FIXED_DEPOSIT_PRODUCT_MAPPER = new FixedDepositProductMapper();
    private static final RecurringDepositProductMapper RECURRING_DEPOSIT_PRODUCT_MAPPER = new RecurringDepositProductMapper();
    private static final DepositProductLookupMapper DEPOSIT_PRODUCT_LOOKUP_MAPPER = new DepositProductLookupMapper();
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private final InterestRateChartReadPlatformService chartReadPlatformService;

    public Collection<DepositProductData> retrieveAll(DepositAccountType depositAccountType) {
        this.context.authenticatedUser();
        DepositProductMapper depositProductMapper = this.getDepositProductMapper(depositAccountType);
        if (depositProductMapper == null) {
            return null;
        }
        StringBuilder sqlBuilder = new StringBuilder(400);
        sqlBuilder.append("select ");
        sqlBuilder.append(depositProductMapper.schema());
        sqlBuilder.append(" where sp.deposit_type_enum = ? ");
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)depositProductMapper, new Object[]{depositAccountType.getValue()});
    }

    public Collection<DepositProductData> retrieveAllForLookup(DepositAccountType depositAccountType) {
        StringBuilder sqlBuilder = new StringBuilder(400);
        sqlBuilder.append("select ");
        sqlBuilder.append(DEPOSIT_PRODUCT_LOOKUP_MAPPER.schema());
        sqlBuilder.append(" where sp.deposit_type_enum = ? ");
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)DEPOSIT_PRODUCT_LOOKUP_MAPPER, new Object[]{depositAccountType.getValue()});
    }

    public DepositProductData retrieveOne(DepositAccountType depositAccountType, Long fixedDepositProductId) {
        try {
            this.context.authenticatedUser();
            DepositProductMapper depositProductMapper = this.getDepositProductMapper(depositAccountType);
            if (depositProductMapper == null) {
                return null;
            }
            StringBuilder sqlBuilder = new StringBuilder(400);
            sqlBuilder.append("select ");
            sqlBuilder.append(depositProductMapper.schema());
            sqlBuilder.append(" where sp.id = ? and sp.deposit_type_enum = ? ");
            return (DepositProductData)this.jdbcTemplate.queryForObject(sqlBuilder.toString(), (RowMapper)depositProductMapper, new Object[]{fixedDepositProductId, depositAccountType.getValue()});
        }
        catch (EmptyResultDataAccessException e) {
            throw new FixedDepositProductNotFoundException(fixedDepositProductId, e);
        }
    }

    public DepositProductData retrieveOneWithChartSlabs(DepositAccountType depositAccountType, Long depositProductId) {
        DepositProductData depositProduct = this.retrieveOne(depositAccountType, depositProductId);
        Collection charts = this.chartReadPlatformService.retrieveAllWithSlabsWithTemplate(depositProductId);
        if (depositAccountType.isFixedDeposit()) {
            depositProduct = FixedDepositProductData.withInterestChart((DepositProductData)depositProduct, (Collection)charts);
        } else if (depositAccountType.isRecurringDeposit()) {
            depositProduct = RecurringDepositProductData.withInterestChart((DepositProductData)depositProduct, (Collection)charts);
        }
        return depositProduct;
    }

    private DepositProductMapper getDepositProductMapper(DepositAccountType depositAccountType) {
        if (depositAccountType.isFixedDeposit()) {
            return FIXED_DEPOSIT_PRODUCT_MAPPER;
        }
        if (depositAccountType.isRecurringDeposit()) {
            return RECURRING_DEPOSIT_PRODUCT_MAPPER;
        }
        return null;
    }

    @Generated
    public DepositProductReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, InterestRateChartReadPlatformService chartReadPlatformService) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.chartReadPlatformService = chartReadPlatformService;
    }
}

