/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.repaymentwithpostdatedchecks.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.apache.fineract.portfolio.loanaccount.exception.LoanNotFoundException;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.data.PostDatedChecksStatus;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.domain.PostDatedChecks;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.domain.PostDatedChecksRepository;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.exception.PostDatedCheckNotFoundException;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.service.RepaymentWithPostDatedChecksWritePlatformService;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class RepaymentWithPostDatedChecksWritePlatformServiceImpl
implements RepaymentWithPostDatedChecksWritePlatformService {
    public static final String NAME = "name";
    public static final String AMOUNT = "amount";
    public static final String ACCOUNT_NO = "accountNo";
    public static final String LOCALE = "locale";
    public static final String CHECK_NO = "checkNo";
    public static final String INSTALLMENT_ID = "installmentId";
    public static final String REPAYMENT_WITH_POST_DATED_CHECKS = "repayment-with-post-dated-checks";
    private static final Set<String> SUPPORTED_PARAMETERS_FOR_UPDATE = new HashSet<String>(Arrays.asList("name", "amount", "accountNo", "locale"));
    private static final Set<String> SUPPORTED_PARAMETERS_FOR_BOUNCE = new HashSet<String>(Arrays.asList("name", "amount", "accountNo", "checkNo", "locale", "installmentId"));
    private final PostDatedChecksRepository postDatedChecksRepository;
    private final FromJsonHelper fromApiJsonHelper;
    private final LoanRepository loanRepository;

    @Transactional
    public CommandProcessingResult updatePostDatedChecks(JsonCommand command) {
        this.validateForUpdate(command);
        PostDatedChecks postDatedChecks = (PostDatedChecks)this.postDatedChecksRepository.findById((Object)command.entityId()).orElseThrow(() -> new PostDatedCheckNotFoundException(command.entityId()));
        Map changes = postDatedChecks.updatePostDatedChecks(command);
        this.postDatedChecksRepository.saveAndFlush((Object)postDatedChecks);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(command.entityId()).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult bouncePostDatedChecks(JsonCommand command) {
        PostDatedChecks postDatedChecks;
        Integer installmentId;
        block3: {
            this.validateForBounce(command);
            PostDatedChecks postDatedCheck = (PostDatedChecks)this.postDatedChecksRepository.findById((Object)command.entityId()).orElseThrow(() -> new PostDatedCheckNotFoundException(command.entityId()));
            postDatedCheck.setStatus(PostDatedChecksStatus.POST_DATED_CHECKS_BOUNCED);
            Loan loan = (Loan)this.loanRepository.findById((Object)command.getLoanId()).orElseThrow(() -> new LoanNotFoundException(command.getLoanId()));
            JsonElement jsonElement = this.fromApiJsonHelper.parse(command.json());
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Locale locale = this.fromApiJsonHelper.extractLocaleParameter(jsonObject);
            String name = this.fromApiJsonHelper.extractStringNamed(NAME, (JsonElement)jsonObject);
            BigDecimal amount = this.fromApiJsonHelper.extractBigDecimalNamed(AMOUNT, (JsonElement)jsonObject, locale);
            installmentId = this.fromApiJsonHelper.extractIntegerNamed(INSTALLMENT_ID, (JsonElement)jsonObject, locale);
            Long accountNo = this.fromApiJsonHelper.extractLongNamed(ACCOUNT_NO, (JsonElement)jsonObject);
            Long checkNo = this.fromApiJsonHelper.extractLongNamed(CHECK_NO, (JsonElement)jsonObject);
            List loanRepaymentScheduleInstallments = loan.getRepaymentScheduleInstallments();
            List<LoanRepaymentScheduleInstallment> installmentList = loanRepaymentScheduleInstallments.stream().filter(repayment -> repayment.getInstallmentNumber().equals(installmentId)).toList();
            postDatedChecks = PostDatedChecks.instanceOf((Long)accountNo, (String)name, (BigDecimal)amount, (LoanRepaymentScheduleInstallment)installmentList.get(0), (Loan)loan, (Long)checkNo);
            try {
                this.postDatedChecksRepository.saveAndFlush((Object)postDatedChecks);
            }
            catch (DataIntegrityViolationException | JpaSystemException e) {
                Throwable realCause = e.getCause();
                ArrayList dataValidationErrors = new ArrayList();
                DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("postdatedChecks");
                if (realCause.getMessage().toLowerCase().contains("transaction has been rolled back")) {
                    baseDataValidator.reset().parameter(CHECK_NO).failWithCode("value.must.be.unique", new Object[0]);
                }
                if (dataValidationErrors.isEmpty()) break block3;
                throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors, e);
            }
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(Long.valueOf(Integer.toUnsignedLong(installmentId))).withLoanId((Long)postDatedChecks.getLoan().getId()).build();
    }

    private void validateForBounce(JsonCommand command) {
        JsonElement jsonElement = this.fromApiJsonHelper.parse(command.json());
        ArrayList dataValidationErrors = new ArrayList();
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, command.json(), (Collection)SUPPORTED_PARAMETERS_FOR_BOUNCE);
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(REPAYMENT_WITH_POST_DATED_CHECKS);
        if (!command.parameterExists(LOCALE)) {
            baseDataValidator.reset().parameter(LOCALE).notNull().failWithCode("locale.not.exists", new Object[0]);
        } else {
            String locale = this.fromApiJsonHelper.extractStringNamed(LOCALE, jsonElement);
            baseDataValidator.reset().parameter(LOCALE).value((Object)locale).notNull();
        }
        if (command.parameterExists(AMOUNT)) {
            BigDecimal amount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(AMOUNT, jsonElement);
            baseDataValidator.reset().parameter(AMOUNT).value((Object)amount).notNull().positiveAmount();
        }
        if (command.parameterExists(ACCOUNT_NO)) {
            Long accountNo = this.fromApiJsonHelper.extractLongNamed(ACCOUNT_NO, jsonElement);
            baseDataValidator.reset().parameter(ACCOUNT_NO).value((Object)accountNo).notNull().positiveAmount();
        }
        if (command.parameterExists(NAME)) {
            String name = this.fromApiJsonHelper.extractStringNamed(NAME, jsonElement);
            baseDataValidator.reset().parameter(NAME).value((Object)name).notNull();
        }
        if (command.parameterExists(CHECK_NO)) {
            Long checkNo = this.fromApiJsonHelper.extractLongNamed(CHECK_NO, jsonElement);
            baseDataValidator.reset().parameter(CHECK_NO).value((Object)checkNo).notNull().longGreaterThanZero();
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void validateForUpdate(JsonCommand command) {
        JsonElement jsonElement = this.fromApiJsonHelper.parse(command.json());
        ArrayList dataValidationErrors = new ArrayList();
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, command.json(), (Collection)SUPPORTED_PARAMETERS_FOR_UPDATE);
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(REPAYMENT_WITH_POST_DATED_CHECKS);
        if (!command.parameterExists(LOCALE)) {
            baseDataValidator.reset().parameter(LOCALE).notNull().failWithCode("locale.not.exists", new Object[0]);
        } else {
            String locale = this.fromApiJsonHelper.extractStringNamed(LOCALE, jsonElement);
            baseDataValidator.reset().parameter(LOCALE).value((Object)locale).notNull();
        }
        if (command.parameterExists(AMOUNT)) {
            BigDecimal amount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed(AMOUNT, jsonElement);
            baseDataValidator.reset().parameter(AMOUNT).value((Object)amount).notNull().positiveAmount();
        }
        if (command.parameterExists(ACCOUNT_NO)) {
            Long accountNo = this.fromApiJsonHelper.extractLongNamed(ACCOUNT_NO, jsonElement);
            baseDataValidator.reset().parameter(ACCOUNT_NO).value((Object)accountNo).notNull().positiveAmount();
        }
        if (command.parameterExists(NAME)) {
            String name = this.fromApiJsonHelper.extractStringNamed(NAME, jsonElement);
            baseDataValidator.reset().parameter(NAME).value((Object)name).notNull();
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    @Transactional
    public CommandProcessingResult deletePostDatedChecks(JsonCommand command) {
        this.postDatedChecksRepository.deleteById((Object)command.entityId());
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withLoanId(command.getLoanId()).withEntityId(command.entityId()).build();
    }

    @Generated
    public RepaymentWithPostDatedChecksWritePlatformServiceImpl(PostDatedChecksRepository postDatedChecksRepository, FromJsonHelper fromApiJsonHelper, LoanRepository loanRepository) {
        this.postDatedChecksRepository = postDatedChecksRepository;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.loanRepository = loanRepository;
    }
}

