/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanAccrualAdjustmentTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanAccrualTransactionCreatedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.portfolio.interestpauses.service.LoanAccountTransfersService;
import org.apache.fineract.portfolio.loanaccount.data.TransactionChangeData;
import org.apache.fineract.portfolio.loanaccount.domain.ChangedTransactionDetail;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanChargePaidBy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleProcessingWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.LoanRepaymentScheduleTransactionProcessor;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.MoneyHolder;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.TransactionCtx;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.impl.AdvancedPaymentScheduleTransactionProcessor;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.impl.ProgressiveTransactionCtx;
import org.apache.fineract.portfolio.loanaccount.service.InterestScheduleModelRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualActivityProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanBalanceService;
import org.apache.fineract.portfolio.loanaccount.service.LoanJournalEntryPoster;
import org.apache.fineract.portfolio.loanaccount.service.LoanTransactionProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanTransactionService;
import org.apache.fineract.portfolio.loanaccount.service.ReplayedTransactionBusinessEventService;
import org.apache.fineract.portfolio.loanaccount.service.ReprocessLoanTransactionsService;
import org.apache.fineract.portfolio.loanproduct.calc.data.ProgressiveLoanInterestScheduleModel;
import org.springframework.stereotype.Service;

@Service
public class ReprocessLoanTransactionsServiceImpl
implements ReprocessLoanTransactionsService {
    private final LoanAccountService loanAccountService;
    private final LoanAccountTransfersService loanAccountTransfersService;
    private final ReplayedTransactionBusinessEventService replayedTransactionBusinessEventService;
    private final LoanTransactionProcessingService loanTransactionProcessingService;
    private final InterestScheduleModelRepositoryWrapper interestScheduleModelRepositoryWrapper;
    private final LoanBalanceService loanBalanceService;
    private final LoanTransactionRepository loanTransactionRepository;
    private final LoanTransactionService loanTransactionService;
    private final LoanJournalEntryPoster loanJournalEntryPoster;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanAccrualActivityProcessingService loanAccrualActivityProcessingService;

    public void reprocessTransactions(Loan loan) {
        List allNonContraTransactionsPostDisbursement = this.loanTransactionService.retrieveListOfTransactionsForReprocessing(loan);
        ChangedTransactionDetail changedTransactionDetail = this.reprocessTransactionsAndFetchChangedTransactions(loan, allNonContraTransactionsPostDisbursement);
        this.handleChangedDetail(changedTransactionDetail);
    }

    public void reprocessParticularTransactions(Loan loan, List<LoanTransaction> loanTransactions) {
        ChangedTransactionDetail changedTransactionDetail = this.reprocessTransactionsAndFetchChangedTransactions(loan, loanTransactions);
        this.handleChangedDetail(changedTransactionDetail);
    }

    public void reprocessTransactionsWithPostTransactionChecks(Loan loan, LocalDate transactionDate) {
        List transactions = this.loanTransactionRepository.findNonReversedTransactionsForReprocessingByLoan(loan);
        ChangedTransactionDetail changedTransactionDetail = this.reprocessTransactionsAndFetchChangedTransactions(loan, transactions);
        this.handleChangedDetail(changedTransactionDetail);
    }

    public void processPostDisbursementTransactions(Loan loan) {
        this.loanTransactionProcessingService.processPostDisbursementTransactions(loan).ifPresent(arg_0 -> this.handleChangedDetail(arg_0));
    }

    public void removeLoanCharge(Loan loan, LoanCharge loanCharge) {
        boolean removed = loanCharge.isActive();
        if (removed) {
            loanCharge.setActive(false);
            LoanRepaymentScheduleProcessingWrapper wrapper = new LoanRepaymentScheduleProcessingWrapper();
            wrapper.reprocess(loan.getCurrency(), loan.getDisbursementDate(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges());
            loan.updateSummaryWithTotalFeeChargesDueAtDisbursement(loan.deriveSumTotalOfChargesDueAtDisbursement());
        }
        this.removeOrModifyTransactionAssociatedWithLoanChargeIfDueAtDisbursement(loan, loanCharge);
        if (!loanCharge.isDueAtDisbursement() && loanCharge.isPaidOrPartiallyPaid(loan.getCurrency())) {
            this.reprocessTransactions(loan);
            return;
        }
        loan.getLoanCharges().remove(loanCharge);
        this.loanBalanceService.updateLoanSummaryDerivedFields(loan);
    }

    private void removeOrModifyTransactionAssociatedWithLoanChargeIfDueAtDisbursement(Loan loan, LoanCharge loanCharge) {
        if (loanCharge.isDueAtDisbursement()) {
            LoanTransaction transactionToRemove = null;
            List transactions = loan.getLoanTransactions();
            for (LoanTransaction transaction : transactions) {
                if (!transaction.isRepaymentAtDisbursement() || !this.doesLoanChargePaidByContainLoanCharge(transaction.getLoanChargesPaid(), loanCharge)) continue;
                MonetaryCurrency currency = loan.getCurrency();
                Money chargeAmount = Money.of((MonetaryCurrency)currency, (BigDecimal)loanCharge.amount());
                if (transaction.isGreaterThan(chargeAmount)) {
                    Money principalPortion = Money.zero((MonetaryCurrency)currency);
                    Money interestPortion = Money.zero((MonetaryCurrency)currency);
                    Money penaltyChargesPortion = Money.zero((MonetaryCurrency)currency);
                    transaction.updateComponentsAndTotal(principalPortion, interestPortion, chargeAmount, penaltyChargesPortion);
                    continue;
                }
                transactionToRemove = transaction;
            }
            if (transactionToRemove != null) {
                loan.removeLoanTransaction(transactionToRemove);
            }
        }
    }

    private boolean doesLoanChargePaidByContainLoanCharge(Set<LoanChargePaidBy> loanChargePaidBys, LoanCharge loanCharge) {
        return loanChargePaidBys.stream().anyMatch(loanChargePaidBy -> loanChargePaidBy.getLoanCharge().equals(loanCharge));
    }

    public void processLatestTransaction(LoanTransaction loanTransaction, Loan loan) {
        TransactionCtx transactionCtx;
        LoanRepaymentScheduleTransactionProcessor transactionProcessor = this.loanTransactionProcessingService.getTransactionProcessor(loan.getTransactionProcessingStrategyCode());
        if (transactionProcessor instanceof AdvancedPaymentScheduleTransactionProcessor) {
            AdvancedPaymentScheduleTransactionProcessor advancedProcessor = (AdvancedPaymentScheduleTransactionProcessor)transactionProcessor;
            Optional savedModel = this.interestScheduleModelRepositoryWrapper.getSavedModel(loan, loanTransaction.getTransactionDate());
            ProgressiveLoanInterestScheduleModel model = savedModel.orElseGet(() -> advancedProcessor.calculateInterestScheduleModel((Long)loan.getId(), loanTransaction.getTransactionDate()));
            transactionCtx = new ProgressiveTransactionCtx(loan.getCurrency(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges(), new MoneyHolder(loan.getTotalOverpaidAsMoney()), new ChangedTransactionDetail(), model);
        } else {
            transactionCtx = new TransactionCtx(loan.getCurrency(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges(), new MoneyHolder(loan.getTotalOverpaidAsMoney()), new ChangedTransactionDetail());
        }
        ChangedTransactionDetail changedTransactionDetail = this.loanTransactionProcessingService.processLatestTransaction(loan.getTransactionProcessingStrategyCode(), loanTransaction, transactionCtx);
        List<LoanTransaction> newTransactions = changedTransactionDetail.getTransactionChanges().stream().map(TransactionChangeData::getNewTransaction).toList().stream().filter(LoanTransaction::isNotReversed).peek(transaction -> transaction.updateLoan(loan)).toList();
        loan.getLoanTransactions().addAll(newTransactions);
        this.loanBalanceService.updateLoanSummaryDerivedFields(loan);
        this.handleChangedDetail(changedTransactionDetail);
    }

    public void updateModel(Loan loan) {
        Optional savedModel = this.interestScheduleModelRepositoryWrapper.getSavedModel(loan, ThreadLocalContextUtil.getBusinessDate());
        if (savedModel.isEmpty()) {
            this.reprocessTransactions(loan);
        }
    }

    private void handleChangedDetail(ChangedTransactionDetail changedTransactionDetail) {
        for (TransactionChangeData change : changedTransactionDetail.getTransactionChanges()) {
            LoanTransaction newTransaction = change.getNewTransaction();
            LoanTransaction oldTransaction = change.getOldTransaction();
            if (newTransaction.isNotReversed()) {
                this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(newTransaction);
                this.loanJournalEntryPoster.postJournalEntriesForLoanTransaction(newTransaction, false, false);
                if (oldTransaction == null && (newTransaction.isAccrual() || newTransaction.isAccrualAdjustment())) {
                    LoanAccrualTransactionCreatedBusinessEvent businessEvent = newTransaction.isAccrual() ? new LoanAccrualTransactionCreatedBusinessEvent(newTransaction) : new LoanAccrualAdjustmentTransactionBusinessEvent(newTransaction);
                    this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)businessEvent);
                }
                if (oldTransaction != null) {
                    this.loanAccountTransfersService.updateLoanTransaction((Long)oldTransaction.getId(), newTransaction);
                }
            }
            if (oldTransaction == null) continue;
            this.loanJournalEntryPoster.postJournalEntriesForLoanTransaction(oldTransaction, false, false);
        }
        this.replayedTransactionBusinessEventService.raiseTransactionReplayedEvents(changedTransactionDetail);
    }

    private ChangedTransactionDetail reprocessTransactionsAndFetchChangedTransactions(Loan loan, List<LoanTransaction> loanTransactions) {
        ChangedTransactionDetail changedTransactionDetail = this.loanTransactionProcessingService.reprocessLoanTransactions(loan.getTransactionProcessingStrategyCode(), loan.getDisbursementDate(), loanTransactions, loan.getCurrency(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges());
        for (TransactionChangeData change : changedTransactionDetail.getTransactionChanges()) {
            change.getNewTransaction().updateLoan(loan);
        }
        List<LoanTransaction> newTransactions = changedTransactionDetail.getTransactionChanges().stream().map(TransactionChangeData::getNewTransaction).toList().stream().filter(LoanTransaction::isNotReversed).toList();
        loan.getLoanTransactions().addAll(newTransactions);
        this.loanBalanceService.updateLoanSummaryDerivedFields(loan);
        this.loanAccrualActivityProcessingService.recalculateAccrualActivityTransaction(loan, changedTransactionDetail);
        return changedTransactionDetail;
    }

    @Generated
    public ReprocessLoanTransactionsServiceImpl(LoanAccountService loanAccountService, LoanAccountTransfersService loanAccountTransfersService, ReplayedTransactionBusinessEventService replayedTransactionBusinessEventService, LoanTransactionProcessingService loanTransactionProcessingService, InterestScheduleModelRepositoryWrapper interestScheduleModelRepositoryWrapper, LoanBalanceService loanBalanceService, LoanTransactionRepository loanTransactionRepository, LoanTransactionService loanTransactionService, LoanJournalEntryPoster loanJournalEntryPoster, BusinessEventNotifierService businessEventNotifierService, LoanAccrualActivityProcessingService loanAccrualActivityProcessingService) {
        this.loanAccountService = loanAccountService;
        this.loanAccountTransfersService = loanAccountTransfersService;
        this.replayedTransactionBusinessEventService = replayedTransactionBusinessEventService;
        this.loanTransactionProcessingService = loanTransactionProcessingService;
        this.interestScheduleModelRepositoryWrapper = interestScheduleModelRepositoryWrapper;
        this.loanBalanceService = loanBalanceService;
        this.loanTransactionRepository = loanTransactionRepository;
        this.loanTransactionService = loanTransactionService;
        this.loanJournalEntryPoster = loanJournalEntryPoster;
        this.businessEventNotifierService = businessEventNotifierService;
        this.loanAccrualActivityProcessingService = loanAccrualActivityProcessingService;
    }
}

