/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.interestratechart.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.interestratechart.data.InterestRateChartSlabDataValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InterestRateChartDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private final InterestRateChartSlabDataValidator chartSlabDataValidator;
    private static final Set<String> INTERESTRATE_CHART_CREATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "name", "description", "fromDate", "endDate", "productId", "chartSlabs", "isPrimaryGroupingByAmount"));
    private static final Set<String> INTERESTRATE_CHART_UPDATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "id", "name", "description", "fromDate", "endDate", "chartSlabs", "delete", "isPrimaryGroupingByAmount"));

    @Autowired
    public InterestRateChartDataValidator(FromJsonHelper fromApiJsonHelper, InterestRateChartSlabDataValidator chartSlabDataValidator) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.chartSlabDataValidator = chartSlabDataValidator;
    }

    public void validateForCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("interestchart");
        this.validateForCreate(json, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForCreate(String json, DataValidatorBuilder baseDataValidator) {
        Boolean isPrimaryGroupingByAmount;
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)INTERESTRATE_CHART_CREATE_REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists("name", element)) {
            String name = this.fromApiJsonHelper.extractStringNamed("name", element);
            baseDataValidator.reset().parameter("name").value((Object)name).notBlank();
        }
        if (this.fromApiJsonHelper.parameterExists("description", element)) {
            String description = this.fromApiJsonHelper.extractStringNamed("description", element);
            baseDataValidator.reset().parameter("description").value((Object)description).notNull();
        }
        LocalDate fromDate = this.fromApiJsonHelper.extractLocalDateNamed("fromDate", element);
        baseDataValidator.reset().parameter("fromDate").value((Object)fromDate).notNull();
        LocalDate toDate = null;
        if (this.fromApiJsonHelper.parameterExists("endDate", element)) {
            toDate = this.fromApiJsonHelper.extractLocalDateNamed("endDate", element);
            baseDataValidator.reset().parameter("endDate").value((Object)toDate).notNull();
        }
        if ((isPrimaryGroupingByAmount = this.fromApiJsonHelper.extractBooleanNamed("isPrimaryGroupingByAmount", element)) == null) {
            isPrimaryGroupingByAmount = false;
        }
        if (toDate != null && DateUtils.isAfter((LocalDate)fromDate, (LocalDate)toDate)) {
            baseDataValidator.parameter("fromDate").value((Object)fromDate).failWithCode("from.date.is.after.to.date", new Object[0]);
        }
        JsonArray array = this.fromApiJsonHelper.extractJsonArrayNamed("chartSlabs", element);
        baseDataValidator.reset().parameter("chartSlabs").value((Object)array).notNull().jsonArrayNotEmpty();
        this.validateChartSlabs(element, baseDataValidator, isPrimaryGroupingByAmount.booleanValue());
    }

    public void validateUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("interestchart");
        this.validateForUpdate(json, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdate(String json, DataValidatorBuilder baseDataValidator) {
        Boolean isPrimaryGroupingByAmount;
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)INTERESTRATE_CHART_UPDATE_REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists("productId", element)) {
            Long savingsProductId = this.fromApiJsonHelper.extractLongNamed("productId", element);
            baseDataValidator.reset().parameter("productId").value((Object)savingsProductId).notNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("name", element)) {
            String name = this.fromApiJsonHelper.extractStringNamed("name", element);
            baseDataValidator.reset().parameter("name").value((Object)name).notBlank();
        }
        if (this.fromApiJsonHelper.parameterExists("description", element)) {
            String description = this.fromApiJsonHelper.extractStringNamed("description", element);
            baseDataValidator.reset().parameter("description").value((Object)description).notNull();
        }
        LocalDate fromDate = null;
        if (this.fromApiJsonHelper.parameterExists("fromDate", element)) {
            fromDate = this.fromApiJsonHelper.extractLocalDateNamed("fromDate", element);
            baseDataValidator.reset().parameter("fromDate").value((Object)fromDate).notNull();
        }
        LocalDate toDate = null;
        if (this.fromApiJsonHelper.parameterExists("endDate", element)) {
            toDate = this.fromApiJsonHelper.extractLocalDateNamed("endDate", element);
            baseDataValidator.reset().parameter("endDate").value((Object)toDate).notNull();
        }
        if ((isPrimaryGroupingByAmount = this.fromApiJsonHelper.extractBooleanNamed("isPrimaryGroupingByAmount", element)) == null) {
            isPrimaryGroupingByAmount = false;
        }
        if (toDate != null && DateUtils.isAfter((LocalDate)fromDate, (LocalDate)toDate)) {
            baseDataValidator.parameter("fromDate").value((Object)fromDate).failWithCode("from.date.is.after.to.date", new Object[0]);
        }
        this.validateChartSlabs(element, baseDataValidator, isPrimaryGroupingByAmount.booleanValue());
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void validateChartSlabs(JsonElement element, DataValidatorBuilder baseDataValidator, boolean isPrimaryGroupingByAmount) {
        if (element.isJsonObject()) {
            JsonObject topLevelJsonElement = element.getAsJsonObject();
            Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
            if (topLevelJsonElement.has("chartSlabs") && topLevelJsonElement.get("chartSlabs").isJsonArray()) {
                JsonArray array = topLevelJsonElement.get("chartSlabs").getAsJsonArray();
                for (int i = 0; i < array.size(); ++i) {
                    JsonObject interstRateChartElement = array.get(i).getAsJsonObject();
                    if (this.fromApiJsonHelper.parameterExists("id", (JsonElement)interstRateChartElement)) {
                        Long id = this.fromApiJsonHelper.extractLongNamed("id", (JsonElement)interstRateChartElement);
                        baseDataValidator.reset().parameter("id").value((Object)id).notNull().integerGreaterThanZero();
                        this.chartSlabDataValidator.validateChartSlabsUpdate((JsonElement)interstRateChartElement, baseDataValidator, locale, Boolean.valueOf(isPrimaryGroupingByAmount));
                        continue;
                    }
                    this.chartSlabDataValidator.validateChartSlabsCreate((JsonElement)interstRateChartElement, baseDataValidator, locale, Boolean.valueOf(isPrimaryGroupingByAmount));
                }
            }
        }
    }
}

