/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.handler;

import org.apache.fineract.commands.annotation.CommandType;
import org.apache.fineract.commands.handler.NewCommandSourceHandler;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.portfolio.client.service.ClientTransactionWritePlatformService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@CommandType(entity="client", action="UNDOTRANSACTION")
public class UndoClientTransactionCommandHandler
implements NewCommandSourceHandler {
    private final ClientTransactionWritePlatformService writePlatformService;

    @Autowired
    public UndoClientTransactionCommandHandler(ClientTransactionWritePlatformService writePlatformService) {
        this.writePlatformService = writePlatformService;
    }

    @Transactional
    public CommandProcessingResult processCommand(JsonCommand command) {
        return this.writePlatformService.undo(command.getClientId(), command.entityId());
    }
}

