/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.calendar.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.calendar.data.CalendarData;
import org.apache.fineract.portfolio.calendar.data.request.CalendarRequest;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.exception.CalendarEntityTypeNotSupportedException;
import org.apache.fineract.portfolio.calendar.service.CalendarDropdownReadPlatformService;
import org.apache.fineract.portfolio.calendar.service.CalendarReadPlatformService;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.springframework.stereotype.Component;

@Path(value="/v1/{entityType}/{entityId}/calendars")
@Component
@Tag(name="Calendar", description="")
public class CalendarsApiResource {
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "CALENDAR";
    private final PlatformSecurityContext context;
    private final CalendarReadPlatformService readPlatformService;
    private final DefaultToApiJsonSerializer<CalendarData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final CalendarDropdownReadPlatformService dropdownReadPlatformService;

    @GET
    @Path(value="{calendarId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CalendarData retrieveCalendar(@PathParam(value="calendarId") Long calendarId, @PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Integer entityTypeId = CalendarEntityType.valueOf((String)entityType.toUpperCase()).getValue();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        CalendarData calendarData = this.readPlatformService.retrieveCalendar(calendarId, entityId, entityTypeId);
        Collection recurringDates = this.readPlatformService.generateRecurringDates(calendarData, true, null);
        Collection nextTenRecurringDates = this.readPlatformService.generateNextTenRecurringDates(calendarData);
        calendarData.setRecurringDates(recurringDates);
        calendarData.setNextTenRecurringDates(nextTenRecurringDates);
        if (settings.isTemplate()) {
            calendarData = this.handleTemplate(calendarData);
        }
        return calendarData;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<CalendarData> retrieveCalendarsByEntity(@PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, @Context UriInfo uriInfo, @DefaultValue(value="all") @QueryParam(value="calendarType") String calendarType) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Set associationParameters = ApiParameterHelper.extractAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters());
        ArrayList calendarsData = new ArrayList();
        List calendarTypeOptions = CalendarUtils.createIntegerListFromQueryParameter((String)calendarType);
        if (!associationParameters.isEmpty() && associationParameters.contains("parentCalendars")) {
            calendarsData.addAll(this.readPlatformService.retrieveParentCalendarsByEntity(entityId, CalendarEntityType.valueOf((String)entityType.toUpperCase()).getValue(), calendarTypeOptions));
        }
        calendarsData.addAll(this.readPlatformService.retrieveCalendarsByEntity(entityId, CalendarEntityType.valueOf((String)entityType.toUpperCase()).getValue(), calendarTypeOptions));
        return this.readPlatformService.updateWithRecurringDates(calendarsData);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CalendarData retrieveNewCalendarDetails(@Context UriInfo uriInfo, @PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.handleTemplate(this.readPlatformService.retrieveNewCalendarDetails());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult createCalendar(@PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, CalendarRequest calendarRequest) {
        CalendarEntityType calendarEntityType = CalendarEntityType.getEntityType((String)entityType);
        if (calendarEntityType == null) {
            throw new CalendarEntityTypeNotSupportedException(entityType);
        }
        CommandWrapper resourceDetails = this.getResourceDetails(calendarEntityType, entityId);
        CommandWrapper commandRequest = new CommandWrapperBuilder().createCalendar(resourceDetails, entityType, entityId).withJson(this.toApiJsonSerializer.serialize((Object)calendarRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @PUT
    @Path(value="{calendarId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult updateCalendar(@PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, @PathParam(value="calendarId") Long calendarId, String jsonRequestBody) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateCalendar(entityType, entityId, calendarId).withJson(jsonRequestBody).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @DELETE
    @Path(value="{calendarId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult deleteCalendar(@PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, @PathParam(value="calendarId") Long calendarId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteCalendar(entityType, entityId, calendarId).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    private CalendarData handleTemplate(CalendarData calendarData) {
        List entityTypeOptions = this.dropdownReadPlatformService.retrieveCalendarEntityTypeOptions();
        List calendarTypeOptions = this.dropdownReadPlatformService.retrieveCalendarTypeOptions();
        List remindByOptions = this.dropdownReadPlatformService.retrieveCalendarRemindByOptions();
        List frequencyOptions = this.dropdownReadPlatformService.retrieveCalendarFrequencyTypeOptions();
        List repeatsOnDayOptions = this.dropdownReadPlatformService.retrieveCalendarWeekDaysTypeOptions();
        List frequencyNthDayTypeOptions = this.dropdownReadPlatformService.retrieveCalendarFrequencyNthDayTypeOptions();
        return calendarData.setEntityTypeOptions(entityTypeOptions).setCalendarTypeOptions(calendarTypeOptions).setRemindByOptions(remindByOptions).setFrequencyOptions(frequencyOptions).setRepeatsOnDayOptions(repeatsOnDayOptions).setFrequencyNthDayTypeOptions(frequencyNthDayTypeOptions);
    }

    private CommandWrapper getResourceDetails(CalendarEntityType type, Long entityId) {
        CommandWrapperBuilder resourceDetails = new CommandWrapperBuilder();
        return Map.of(CalendarEntityType.CENTERS, resourceDetails.withGroupId(entityId).build(), CalendarEntityType.CLIENTS, resourceDetails.withClientId(entityId).build(), CalendarEntityType.GROUPS, resourceDetails.withGroupId(entityId).build(), CalendarEntityType.LOANS, resourceDetails.withLoanId(entityId).build(), CalendarEntityType.SAVINGS, resourceDetails.withSavingsId(entityId).build()).getOrDefault(type, resourceDetails.build());
    }

    @Generated
    public CalendarsApiResource(PlatformSecurityContext context, CalendarReadPlatformService readPlatformService, DefaultToApiJsonSerializer<CalendarData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, CalendarDropdownReadPlatformService dropdownReadPlatformService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.dropdownReadPlatformService = dropdownReadPlatformService;
    }
}

