/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.office.starter;

import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrencyRepositoryWrapper;
import org.apache.fineract.organisation.monetary.service.CurrencyReadPlatformService;
import org.apache.fineract.organisation.office.domain.OfficeRepository;
import org.apache.fineract.organisation.office.domain.OfficeRepositoryWrapper;
import org.apache.fineract.organisation.office.domain.OfficeTransactionRepository;
import org.apache.fineract.organisation.office.mapper.OfficeDataMapper;
import org.apache.fineract.organisation.office.serialization.OfficeCommandFromApiJsonDeserializer;
import org.apache.fineract.organisation.office.serialization.OfficeTransactionCommandFromApiJsonDeserializer;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformServiceImpl;
import org.apache.fineract.organisation.office.service.OfficeWritePlatformService;
import org.apache.fineract.organisation.office.service.OfficeWritePlatformServiceJpaRepositoryImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class OrganisationOfficeConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OfficeReadPlatformService.class})
    public OfficeReadPlatformService officeReadPlatformService(JdbcTemplate jdbcTemplate, DatabaseSpecificSQLGenerator sqlGenerator, PlatformSecurityContext context, CurrencyReadPlatformService currencyReadPlatformService, ColumnValidator columnValidator, OfficeRepository officeRepository, OfficeDataMapper officeDataMapper) {
        return new OfficeReadPlatformServiceImpl(jdbcTemplate, sqlGenerator, context, currencyReadPlatformService, columnValidator, officeRepository, officeDataMapper);
    }

    @Bean
    @ConditionalOnMissingBean(value={OfficeWritePlatformService.class})
    public OfficeWritePlatformService officeWritePlatformService(PlatformSecurityContext context, OfficeCommandFromApiJsonDeserializer fromApiJsonDeserializer, OfficeTransactionCommandFromApiJsonDeserializer moneyTransferCommandFromApiJsonDeserializer, OfficeRepositoryWrapper officeRepositoryWrapper, OfficeTransactionRepository officeTransactionRepository, ApplicationCurrencyRepositoryWrapper applicationCurrencyRepository) {
        return new OfficeWritePlatformServiceJpaRepositoryImpl(context, fromApiJsonDeserializer, moneyTransferCommandFromApiJsonDeserializer, officeRepositoryWrapper, officeTransactionRepository, applicationCurrencyRepository);
    }
}

