/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.reportmailingjob.service;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.dataqueries.domain.Report;
import org.apache.fineract.infrastructure.dataqueries.domain.ReportRepositoryWrapper;
import org.apache.fineract.infrastructure.reportmailingjob.domain.ReportMailingJob;
import org.apache.fineract.infrastructure.reportmailingjob.domain.ReportMailingJobRepository;
import org.apache.fineract.infrastructure.reportmailingjob.domain.ReportMailingJobRepositoryWrapper;
import org.apache.fineract.infrastructure.reportmailingjob.service.ReportMailingJobWritePlatformService;
import org.apache.fineract.infrastructure.reportmailingjob.validation.ReportMailingJobValidator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReportMailingJobWritePlatformServiceImpl
implements ReportMailingJobWritePlatformService {
    private static final Logger LOG = LoggerFactory.getLogger(ReportMailingJobWritePlatformServiceImpl.class);
    private final ReportRepositoryWrapper reportRepositoryWrapper;
    private final ReportMailingJobValidator reportMailingJobValidator;
    private final ReportMailingJobRepositoryWrapper reportMailingJobRepositoryWrapper;
    private final ReportMailingJobRepository reportMailingJobRepository;
    private final PlatformSecurityContext platformSecurityContext;

    @Autowired
    public ReportMailingJobWritePlatformServiceImpl(ReportRepositoryWrapper reportRepositoryWrapper, ReportMailingJobValidator reportMailingJobValidator, ReportMailingJobRepositoryWrapper reportMailingJobRepositoryWrapper, PlatformSecurityContext platformSecurityContext) {
        this.reportRepositoryWrapper = reportRepositoryWrapper;
        this.reportMailingJobValidator = reportMailingJobValidator;
        this.reportMailingJobRepositoryWrapper = reportMailingJobRepositoryWrapper;
        this.reportMailingJobRepository = reportMailingJobRepositoryWrapper.getReportMailingJobRepository();
        this.platformSecurityContext = platformSecurityContext;
    }

    @Transactional
    public CommandProcessingResult createReportMailingJob(JsonCommand jsonCommand) {
        try {
            this.reportMailingJobValidator.validateCreateRequest(jsonCommand);
            AppUser appUser = this.platformSecurityContext.authenticatedUser();
            Report stretchyReport = this.reportRepositoryWrapper.findOneThrowExceptionIfNotFound(jsonCommand.longValueOfParameterNamed("stretchyReportId"));
            ReportMailingJob reportMailingJob = ReportMailingJob.newInstance((JsonCommand)jsonCommand, (Report)stretchyReport, (AppUser)appUser);
            this.reportMailingJobRepository.saveAndFlush((Object)reportMailingJob);
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId((Long)reportMailingJob.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(jsonCommand, throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult updateReportMailingJob(Long reportMailingJobId, JsonCommand jsonCommand) {
        try {
            LocalDateTime nextRecurringDateTime;
            LocalDateTime startDateTime;
            this.reportMailingJobValidator.validateUpdateRequest(jsonCommand);
            ReportMailingJob reportMailingJob = this.reportMailingJobRepositoryWrapper.findOneThrowExceptionIfNotFound(reportMailingJobId);
            Map changes = reportMailingJob.update(jsonCommand);
            String recurrence = reportMailingJob.getRecurrence();
            LocalDateTime nextRunDateTime = reportMailingJob.getNextRunDateTime();
            if (changes.containsKey("stretchyReportId")) {
                Long stretchyReportId = (Long)changes.get("stretchyReportId");
                Report stretchyReport = this.reportRepositoryWrapper.findOneThrowExceptionIfNotFound(stretchyReportId);
                reportMailingJob.setStretchyReport(stretchyReport);
            }
            if (changes.containsKey("recurrence")) {
                if (StringUtils.isNotBlank((CharSequence)recurrence)) {
                    startDateTime = DateUtils.getLocalDateTimeOfTenant();
                    if (changes.containsKey("startDateTime")) {
                        startDateTime = reportMailingJob.getStartDateTime();
                    }
                    startDateTime = reportMailingJob.getStartDateTime();
                    nextRecurringDateTime = this.createNextRecurringDateTime(recurrence, startDateTime);
                    reportMailingJob.setNextRunDateTime(nextRecurringDateTime);
                } else if (StringUtils.isBlank((CharSequence)recurrence) && nextRunDateTime != null) {
                    reportMailingJob.setNextRunDateTime(null);
                }
            }
            if (changes.containsKey("startDateTime")) {
                nextRecurringDateTime = startDateTime = reportMailingJob.getStartDateTime();
                if (StringUtils.isNotBlank((CharSequence)recurrence)) {
                    nextRecurringDateTime = this.createNextRecurringDateTime(recurrence, startDateTime);
                }
                reportMailingJob.setNextRunDateTime(nextRecurringDateTime);
            }
            if (!changes.isEmpty()) {
                this.reportMailingJobRepository.saveAndFlush((Object)reportMailingJob);
            }
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId((Long)reportMailingJob.getId()).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(jsonCommand, throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult deleteReportMailingJob(Long reportMailingJobId) {
        ReportMailingJob reportMailingJob = this.reportMailingJobRepositoryWrapper.findOneThrowExceptionIfNotFound(reportMailingJobId);
        reportMailingJob.delete();
        this.reportMailingJobRepository.save((Object)reportMailingJob);
        return new CommandProcessingResultBuilder().withEntityId(reportMailingJobId).build();
    }

    private LocalDateTime createNextRecurringDateTime(String recurrencePattern, LocalDateTime startDateTime) {
        LocalDateTime nextRecurringDateTime = null;
        if (StringUtils.isNotBlank((CharSequence)recurrencePattern) && startDateTime != null) {
            LocalDateTime nextDayLocalDate = startDateTime.plus(Duration.ofDays(1L));
            nextRecurringDateTime = CalendarUtils.getNextRecurringDate((String)recurrencePattern, (LocalDateTime)startDateTime, (LocalDateTime)nextDayLocalDate);
        }
        return nextRecurringDateTime;
    }

    private void handleDataIntegrityIssues(JsonCommand jsonCommand, Throwable realCause, NonTransientDataAccessException dve) {
        if (realCause.getMessage().contains("name")) {
            String name = jsonCommand.stringValueOfParameterNamed("name");
            throw new PlatformDataIntegrityException("error.msg.report.mailing.job.duplicate.name", "Report mailing job with name `" + name + "` already exists", "name", new Object[]{name});
        }
        LOG.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.charge.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }
}

