/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.reportmailingjob.service;

import java.util.ArrayList;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.reportmailingjob.data.ReportMailingJobRunHistoryData;
import org.apache.fineract.infrastructure.reportmailingjob.service.ReportMailingJobRunHistoryReadPlatformService;
import org.apache.fineract.infrastructure.reportmailingjob.service.ReportMailingJobRunHistoryReadPlatformServiceImpl;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class ReportMailingJobRunHistoryReadPlatformServiceImpl
implements ReportMailingJobRunHistoryReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final ReportMailingJobRunHistoryMapper reportMailingJobRunHistoryMapper;
    private final ColumnValidator columnValidator;
    private final PaginationHelper paginationHelper;

    @Autowired
    public ReportMailingJobRunHistoryReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, ColumnValidator columnValidator, DatabaseSpecificSQLGenerator sqlGenerator, PaginationHelper paginationHelper) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlGenerator = sqlGenerator;
        this.reportMailingJobRunHistoryMapper = new ReportMailingJobRunHistoryMapper();
        this.columnValidator = columnValidator;
        this.paginationHelper = paginationHelper;
    }

    public Page<ReportMailingJobRunHistoryData> retrieveRunHistoryByJobId(Long reportMailingJobId, SearchParameters searchParameters) {
        StringBuilder sqlStringBuilder = new StringBuilder(200);
        ArrayList<Long> queryParameters = new ArrayList<Long>();
        sqlStringBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlStringBuilder.append(this.reportMailingJobRunHistoryMapper.reportMailingJobRunHistorySchema());
        if (reportMailingJobId != null) {
            sqlStringBuilder.append(" where rmjrh.job_id = ? ");
            queryParameters.add(reportMailingJobId);
        }
        if (searchParameters.hasOrderBy()) {
            sqlStringBuilder.append(" order by ").append(searchParameters.getOrderBy());
            this.columnValidator.validateSqlInjection(sqlStringBuilder.toString(), new String[]{searchParameters.getOrderBy()});
            if (searchParameters.hasSortOrder()) {
                sqlStringBuilder.append(" ").append(searchParameters.getSortOrder());
                this.columnValidator.validateSqlInjection(sqlStringBuilder.toString(), new String[]{searchParameters.getSortOrder()});
            }
        }
        if (searchParameters.hasLimit()) {
            sqlStringBuilder.append(" ");
            if (searchParameters.hasOffset()) {
                sqlStringBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
            } else {
                sqlStringBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
            }
        }
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlStringBuilder.toString(), queryParameters.toArray(), (RowMapper)this.reportMailingJobRunHistoryMapper);
    }
}

