/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.hooks.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.infrastructure.hooks.data.Entity;
import org.apache.fineract.infrastructure.hooks.data.Grouping;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;

public class EventResultSetExtractor
implements ResultSetExtractor<List<Grouping>> {
    public List<Grouping> extractData(ResultSet rs) throws SQLException, DataAccessException {
        ArrayList<Grouping> groupings = new ArrayList<Grouping>();
        HashMap groupToEntityMapping = new HashMap();
        HashMap<String, ArrayList<String>> entityToActionMapping = new HashMap<String, ArrayList<String>>();
        while (rs.next()) {
            String groupingName = rs.getString("grouping");
            String entityName = rs.getString("entity_name");
            String actionName = rs.getString("action_name");
            HashMap entities = (HashMap)groupToEntityMapping.get(groupingName);
            ArrayList<String> actions = (ArrayList<String>)entityToActionMapping.get(entityName);
            if (entities == null) {
                entityToActionMapping = new HashMap();
            }
            if (actions == null) {
                actions = new ArrayList<String>();
            }
            actions.add(actionName);
            entityToActionMapping.put(entityName, actions);
            if (entities == null) {
                entities = new HashMap();
            }
            entities.putAll(entityToActionMapping);
            groupToEntityMapping.put(groupingName, entities);
        }
        for (Map.Entry groupingEntry : groupToEntityMapping.entrySet()) {
            ArrayList<Entity> entities = new ArrayList<Entity>();
            Grouping group = new Grouping();
            group.setName((String)groupingEntry.getKey());
            for (Map.Entry entityEntry : ((Map)groupingEntry.getValue()).entrySet()) {
                Entity entity = new Entity();
                entity.setName((String)entityEntry.getKey());
                ArrayList actions = new ArrayList((Collection)entityEntry.getValue());
                Collections.sort(actions);
                entity.setActions(actions);
                entities.add(entity);
            }
            entities.sort(Comparator.comparing(Entity::getName));
            group.setEntities(entities);
            groupings.add(group);
        }
        groupings.sort(Comparator.comparing(Grouping::getName));
        return groupings;
    }
}

