/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.PagedLocalRequest;
import org.apache.fineract.infrastructure.dataqueries.api.DatatablesApiResourceSwagger;
import org.apache.fineract.infrastructure.dataqueries.data.DatatableData;
import org.apache.fineract.infrastructure.dataqueries.data.GenericResultsetData;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableReadService;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableWriteService;
import org.apache.fineract.infrastructure.dataqueries.service.GenericDataService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.search.data.AdvancedQueryData;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;

@Path(value="/v1/datatables")
@Component
@Tag(name="Data Tables", description="The datatables API allows you to plug-in your own tables (MySql) that have a relationship to a Apache Fineract core table. For example, you might want to add some extra client fields and record information about each of the clients' family members. Via the API you can create, read, update and delete entries for each 'plugged-in' table. The API checks for permission and for 'data scoping' (only data within the users' office hierarchy can be managed by the user).\n\nThe Apache Fineract Reference App uses a JQuery plug-in called stretchydatatables (which in turn uses this datatables resource) to provide a pretty flexible CRUD (Create, Read, Update, Delete) User Interface.")
public class DatatablesApiResource {
    private final PlatformSecurityContext context;
    private final GenericDataService genericDataService;
    private final DatatableReadService datatableReadService;
    private final DatatableWriteService datatableWriteService;
    private final ToApiJsonSerializer<GenericResultsetData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Data Tables", description="Lists registered data tables and the Apache Fineract Core application table they are registered to.\n\nARGUMENTS\n\napptable  - optional\nThe Apache Fineract core application table.\n\nExample Requests:\n\ndatatables?apptable=m_client\n\n\ndatatables")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DatatablesApiResourceSwagger.GetDataTablesResponse.class)))})})
    public String getDatatables(@QueryParam(value="apptable") @Parameter(description="apptable") String apptable, @Context UriInfo uriInfo) {
        List result = this.datatableReadService.retrieveDatatableNames(apptable);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create Data Table", description="Create a new data table and registers it with the Apache Fineract Core application table.\n\nField Descriptions\n\nMandatory - datatableName : \n\nThe name of the Data Table.\n\nMandatory - apptableName\n\nApplication table name. Must be one of the following:\n\nm_client\n\nm_group\n\nm_loan\n\nm_office\n\nm_saving_account\n\nm_product_loan\n\nm_savings_product\n\nMandatory - columns  \nAn array of columns in the new Data Table.\n\nOptional - multiRow\n\nAllows to create multiple entries in the Data Table. Optional, defaults to false. If this property is not provided Data Table will allow only one entry.\n\nField Descriptions - columns\n\nMandatory - name\n\nName of the created column. Can contain only alphanumeric characters, underscores and spaces, but cannot start with a number. Cannot start or end with an underscore or space.\n\nMandatory - type\n\nColumn type. Must be one of the following:\n\nBoolean\n\nDate\n\nDateTime\n\nDecimal\n\nDropdown\n\n\nNumber\n\nString\n\nText\n\nMandatory [type = Dropdown] - code\n\nUsed in Code description fields. Column name becomes: code_cd_name. Mandatory if using type Dropdown, otherwise an error is returned.\n\nOptional - mandatory\n\nDetermines whether this column must have a value in every entry. Optional, defaults to false.\n\nMandatory [type = String] - length\n\nLength of the text field. Mandatory if type String is used, otherwise an error is returned.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=DatatablesApiResourceSwagger.PostDataTablesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=DatatablesApiResourceSwagger.PostDataTablesResponse.class))})})
    public String createDatatable(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createDBDatatable(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{datatableName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Data Table", description="Modifies fields of a data table. If the apptableName parameter is passed, data table is deregistered and registered with the new application table.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=DatatablesApiResourceSwagger.PutDataTablesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=DatatablesApiResourceSwagger.PutDataTablesResponse.class))})})
    public String updateDatatable(@PathParam(value="datatableName") @Parameter(description="datatableName") String datatableName, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateDBDatatable(datatableName, apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{datatableName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete Data Table", description="Deletes a data table and deregisters it from the Apache Fineract Core application table.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=DatatablesApiResourceSwagger.DeleteDataTablesResponse.class))})})
    public String deleteDatatable(@PathParam(value="datatableName") @Parameter(description="datatableName") String datatableName, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteDBDatatable(datatableName, apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="register/{datatable}/{apptable}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Register Data Table", description="Registers a data table with the Apache Fineract Core application table. This allows the data table to be maintained through the API. In case the datatable is a PPI (survey table), a parameter category should be pass along with the request. The API currently support one category (200)")
    @RequestBody(content={@Content(schema=@Schema(implementation=DatatablesApiResourceSwagger.PostDataTablesRegisterDatatableAppTable.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=DatatablesApiResourceSwagger.PutDataTablesResponse.class))})})
    public String registerDatatable(@PathParam(value="datatable") @Parameter(description="datatable") String datatable, @PathParam(value="apptable") @Parameter(description="apptable") String apptable, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().registerDBDatatable(datatable, apptable).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="deregister/{datatable}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Deregister Data Table", description="Deregisters a data table. It will no longer be available through the API.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=DatatablesApiResourceSwagger.PutDataTablesResponse.class))})})
    public String deregisterDatatable(@PathParam(value="datatable") @Parameter(description="datatable") String datatable) {
        this.datatableWriteService.deregisterDatatable(datatable);
        CommandProcessingResult result = new CommandProcessingResultBuilder().withResourceIdAsString(datatable).build();
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="{datatable}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Data Table Details", description="Lists a registered data table details and the Apache Fineract Core application table they are registered to.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=DatatablesApiResourceSwagger.GetDataTablesResponse.class))})})
    public String getDatatable(@PathParam(value="datatable") @Parameter(description="datatable") String datatable, @Context UriInfo uriInfo) {
        DatatableData result = this.datatableReadService.retrieveDatatable(datatable);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="{datatable}/query")
    @Produces(value={"application/json"})
    @Operation(summary="Query Data Table values", description="Query values from a registered data table.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=List.class))})})
    public String queryValues(@PathParam(value="datatable") @Parameter(description="datatable") String datatable, @QueryParam(value="columnFilter") @Parameter(description="columnFilter") String columnFilter, @QueryParam(value="valueFilter") @Parameter(description="valueFilter") String valueFilter, @QueryParam(value="resultColumns") @Parameter(description="resultColumns") String resultColumns, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasDatatableReadPermission(datatable);
        List result = this.datatableReadService.queryDataTable(datatable, columnFilter, valueFilter, resultColumns);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="{datatable}/query")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Query Data Table values", description="Query values from a registered data table.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=List.class))})})
    public String advancedQuery(@PathParam(value="datatable") @Parameter(description="datatable") String datatable, PagedLocalRequest<AdvancedQueryData> queryRequest, @Context UriInfo uriInfo) {
        Page result = this.datatableReadService.queryDataTableAdvanced(datatable, queryRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="{datatable}/{apptableId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Entry(s) from Data Table", description="Gets the entry (if it exists) for data tables that are one to one with the application table. \nGets the entries (if they exist) for data tables that are one to many with the application table.\n\nNote: The 'fields' parameter is not available for datatables.\n\nARGUMENTS\norderoptional Specifies the order in which data is returned.genericResultSetoptional, defaults to false If 'true' an optimised JSON format is returned suitable for tabular display of data. This format is used by the default data tables UI functionality.\nExample Requests:\n\ndatatables/extra_client_details/1\n\n\ndatatables/extra_family_details/1?order=`Date of Birth` desc\n\n\ndatatables/extra_client_details/1?genericResultSet=true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=HashMap.class))})})
    public String getDatatable(@PathParam(value="datatable") @Parameter(description="datatable") String datatable, @PathParam(value="apptableId") @Parameter(description="apptableId") Long apptableId, @QueryParam(value="order") @Parameter(description="order") String order, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasDatatableReadPermission(datatable);
        GenericResultsetData results = this.datatableReadService.retrieveDataTableGenericResultSet(datatable, apptableId, order, null);
        String json = "";
        boolean genericResultSet = ApiParameterHelper.genericResultSet((MultivaluedMap)uriInfo.getQueryParameters());
        json = genericResultSet ? this.toApiJsonSerializer.serialize((Object)results) : this.genericDataService.generateJsonFromGenericResultsetData(results);
        return json;
    }

    @GET
    @Path(value="{datatable}/{apptableId}/{datatableId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getDatatableManyEntry(@PathParam(value="datatable") String datatable, @PathParam(value="apptableId") Long apptableId, @PathParam(value="datatableId") Long datatableId, @QueryParam(value="order") String order, @DefaultValue(value="false") @QueryParam(value="genericResultSet") @Parameter(in=ParameterIn.QUERY, name="genericResultSet", description="Optional flag to format the response", required=false) boolean genericResultSet, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasDatatableReadPermission(datatable);
        GenericResultsetData results = this.datatableReadService.retrieveDataTableGenericResultSet(datatable, apptableId, order, datatableId);
        String json = "";
        json = genericResultSet ? this.toApiJsonSerializer.serialize((Object)results) : this.genericDataService.generateJsonFromGenericResultsetData(results);
        return json;
    }

    @POST
    @Path(value="{datatable}/{apptableId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create Entry in Data Table", description="Adds a row to the data table.\n\nNote that the default datatable UI functionality converts any field name containing spaces to underscores when using the API. This means the field name \"Business Description\" is considered the same as \"Business_Description\". So you shouldn't have both \"versions\" in any data table.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=String.class))}, description="{\n  \"BusinessDescription\": \"Livestock sales\",\n  \"Comment\": \"First comment made\",\n  \"Education_cv\": \"Primary\",\n  \"Gender_cd\": 6,\n  \"HighestRatePaid\": 8.5,\n  \"NextVisit\": \"01 October 2012\",\n  \"YearsinBusiness\": 5,\n  \"dateFormat\": \"dd MMMM yyyy\",\n  \"locale\": \"en\"\n}")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=DatatablesApiResourceSwagger.PostDataTablesAppTableIdResponse.class))})})
    public String createDatatableEntry(@PathParam(value="datatable") @Parameter(description="datatable") String datatable, @PathParam(value="apptableId") @Parameter(description="apptableId") Long apptableId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createDatatableEntry(datatable, apptableId, null).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{datatable}/{apptableId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Entry in Data Table (One to One)", description="Updates the row (if it exists) of the data table.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=String.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=DatatablesApiResourceSwagger.PutDataTablesAppTableIdResponse.class))})})
    public String updateDatatableEntryOnetoOne(@PathParam(value="datatable") @Parameter(description="datatable") String datatable, @PathParam(value="apptableId") @Parameter(description="apptableId") Long apptableId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateDatatableEntry(datatable, apptableId, null).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{datatable}/{apptableId}/{datatableId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Entry in Data Table (One to Many)", description="Updates the row (if it exists) of the data table.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=String.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=DatatablesApiResourceSwagger.PutDataTablesAppTableIdDatatableIdResponse.class))})})
    public String updateDatatableEntryOneToMany(@PathParam(value="datatable") @Parameter(description="datatable") String datatable, @PathParam(value="apptableId") @Parameter(description="apptableId") Long apptableId, @PathParam(value="datatableId") @Parameter(description="datatableId") Long datatableId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateDatatableEntry(datatable, apptableId, datatableId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{datatable}/{apptableId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete Entry(s) in Data Table", description="Deletes the entry (if it exists) for data tables that are one-to-one with the application table. \nDeletes the entries (if they exist) for data tables that are one-to-many with the application table.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=DatatablesApiResourceSwagger.DeleteDataTablesDatatableAppTableIdResponse.class))})})
    public String deleteDatatableEntries(@PathParam(value="datatable") @Parameter(description="datatable") String datatable, @PathParam(value="apptableId") @Parameter(description="apptableId") Long apptableId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteDatatableEntry(datatable, apptableId, null).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{datatable}/{apptableId}/{datatableId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete Entry in Datatable (One to Many)", description="Deletes the entry (if it exists) for data tables that are one to many with the application table.\n\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=DatatablesApiResourceSwagger.DeleteDataTablesDatatableAppTableIdDatatableIdResponse.class))})})
    public String deleteDatatableEntry(@PathParam(value="datatable") @Parameter(description="datatable", example="{}") String datatable, @PathParam(value="apptableId") @Parameter(description="apptableId") Long apptableId, @PathParam(value="datatableId") @Parameter(description="datatableId") Long datatableId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteDatatableEntry(datatable, apptableId, datatableId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public DatatablesApiResource(PlatformSecurityContext context, GenericDataService genericDataService, DatatableReadService datatableReadService, DatatableWriteService datatableWriteService, ToApiJsonSerializer<GenericResultsetData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.genericDataService = genericDataService;
        this.datatableReadService = datatableReadService;
        this.datatableWriteService = datatableWriteService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

