/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.portfolio.savings.data.SavingsAccountData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class SavingsAccountSheetPopulator
extends AbstractWorkbookPopulator {
    private List<SavingsAccountData> savingsAccountDataList;
    private static final int SAVINGS_ACCOUNT_ID_COL = 0;
    private static final int SAVING_ACCOUNT_NO = 1;
    private static final int CURRENCY_COL = 2;
    private static final int CLIENT_NAME = 3;

    public SavingsAccountSheetPopulator(List<SavingsAccountData> savingsAccountDataList) {
        this.savingsAccountDataList = savingsAccountDataList;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet savingsSheet = workbook.createSheet("SavingsAccounts");
        this.setLayout(savingsSheet);
        this.populateSavingsSheet(savingsSheet);
        savingsSheet.protectSheet("");
    }

    private void populateSavingsSheet(Sheet savingsSheet) {
        int rowIndex = 1;
        for (SavingsAccountData savings : this.savingsAccountDataList) {
            Row row = savingsSheet.createRow(rowIndex++);
            this.writeLong(0, row, savings.getId().longValue());
            this.writeString(1, row, savings.getAccountNo());
            this.writeString(2, row, savings.getCurrency().getCode());
            this.writeString(3, row, savings.getClientName());
        }
    }

    private void setLayout(Sheet savingsSheet) {
        Row rowHeader = savingsSheet.createRow(0);
        rowHeader.setHeight((short)500);
        savingsSheet.setColumnWidth(0, 6000);
        this.writeString(0, rowHeader, "Savings Account Id");
        savingsSheet.setColumnWidth(1, 6000);
        this.writeString(1, rowHeader, "Savings Account No");
        savingsSheet.setColumnWidth(2, 4000);
        this.writeString(2, rowHeader, "Currency Code");
        savingsSheet.setColumnWidth(3, 4000);
        this.writeString(3, rowHeader, "Client Name");
    }
}

