/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.fineract.organisation.staff.data.StaffData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class PersonnelSheetPopulator
extends AbstractWorkbookPopulator {
    private List<StaffData> personnel;
    private List<OfficeData> offices;
    private Map<String, List<StaffData>> officeToPersonnel;
    private Map<Integer, Integer[]> officeNameToBeginEndIndexesOfStaff;
    private static final int OFFICE_NAME_COL = 0;
    private static final int STAFF_NAME_COL = 1;
    private static final int STAFF_ID_COL = 2;

    public PersonnelSheetPopulator(List<StaffData> personnel, List<OfficeData> offices) {
        this.personnel = personnel;
        this.offices = offices;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet staffSheet = workbook.createSheet("Staff");
        this.setLayout(staffSheet);
        this.setOfficeToPersonnelMap();
        this.populateStaffByOfficeName(staffSheet);
        staffSheet.protectSheet("");
    }

    private void populateStaffByOfficeName(Sheet staffSheet) {
        int rowIndex = 1;
        int startIndex = 1;
        int officeIndex = 0;
        this.officeNameToBeginEndIndexesOfStaff = new HashMap();
        Row row = staffSheet.createRow(rowIndex);
        for (OfficeData office : this.offices) {
            startIndex = rowIndex + 1;
            this.writeString(0, row, office.getName().trim().replaceAll("[ )(]", "_"));
            List staffList = (List)this.officeToPersonnel.get(office.getName().trim().replaceAll("[ )(]", "_"));
            if (staffList != null) {
                if (staffList.isEmpty()) continue;
                for (StaffData staff : staffList) {
                    this.writeString(1, row, staff.getDisplayName());
                    this.writeLong(2, row, staff.getId().longValue());
                    row = staffSheet.createRow(++rowIndex);
                }
                this.officeNameToBeginEndIndexesOfStaff.put(officeIndex++, new Integer[]{startIndex, rowIndex});
                continue;
            }
            ++officeIndex;
        }
    }

    private void setOfficeToPersonnelMap() {
        this.officeToPersonnel = new HashMap();
        for (StaffData person : this.personnel) {
            this.add(person.getOfficeName().trim().replaceAll("[ )(]", "_"), person);
        }
    }

    private void add(String key, StaffData value) {
        ArrayList<StaffData> values = (ArrayList<StaffData>)this.officeToPersonnel.get(key);
        if (values == null) {
            values = new ArrayList<StaffData>();
        }
        values.add(value);
        this.officeToPersonnel.put(key, values);
    }

    private void setLayout(Sheet worksheet) {
        Integer i = 0;
        while (i < 3) {
            worksheet.setColumnWidth(i.intValue(), 6000);
            Integer n = i;
            i = i + 1;
        }
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        this.writeString(0, rowHeader, "Office Name");
        this.writeString(1, rowHeader, "Staff List");
        this.writeString(2, rowHeader, "Staff ID");
    }

    public Map<Integer, Integer[]> getOfficeNameToBeginEndIndexesOfStaff() {
        return this.officeNameToBeginEndIndexesOfStaff;
    }
}

