/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.data.ImportData;
import org.apache.fineract.infrastructure.bulkimport.exceptions.ImportTypeNotFoundException;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.documentmanagement.data.DocumentData;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.stereotype.Component;

@Path(value="/v1/imports")
@Component
@Tag(name="Bulk Import", description="")
public class BulkImportApiResource {
    private static final String RESOURCE_NAME_FOR_PERMISSION = "IMPORT";
    private final PlatformSecurityContext context;
    private final BulkImportWorkbookService bulkImportWorkbookService;
    private final DefaultToApiJsonSerializer<ImportData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveImportDocuments(@Context UriInfo uriInfo, @QueryParam(value="entityType") String entityType) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSION);
        Collection importData = new ArrayList();
        if (entityType.equals(GlobalEntityType.CLIENT.getCode())) {
            Collection importForClientEntity = this.bulkImportWorkbookService.getImports(GlobalEntityType.CLIENTS_ENTITY);
            Collection importForClientPerson = this.bulkImportWorkbookService.getImports(GlobalEntityType.CLIENTS_PERSON);
            if (importForClientEntity != null) {
                importData.addAll(importForClientEntity);
            }
            if (importForClientPerson != null) {
                importData.addAll(importForClientPerson);
            }
        } else {
            GlobalEntityType type = GlobalEntityType.fromCode((String)entityType);
            if (type == null) {
                throw new ImportTypeNotFoundException(entityType);
            }
            importData = this.bulkImportWorkbookService.getImports(type);
        }
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, importData);
    }

    @GET
    @Path(value="getOutputTemplateLocation")
    public String retriveOutputTemplateLocation(@QueryParam(value="importDocumentId") String importDocumentId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSION);
        DocumentData documentData = this.bulkImportWorkbookService.getOutputTemplateLocation(importDocumentId);
        return this.toApiJsonSerializer.serialize((Object)documentData.getLocation());
    }

    @GET
    @Path(value="downloadOutputTemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getOutputTemplate(@QueryParam(value="importDocumentId") String importDocumentId) {
        return this.bulkImportWorkbookService.getOutputTemplate(importDocumentId);
    }

    @Generated
    public BulkImportApiResource(PlatformSecurityContext context, BulkImportWorkbookService bulkImportWorkbookService, DefaultToApiJsonSerializer<ImportData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper) {
        this.context = context;
        this.bulkImportWorkbookService = bulkImportWorkbookService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
    }
}

