/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime.dto;

import java.util.Arrays;
import org.apache.felix.http.base.internal.handler.ListenerHandler;
import org.apache.felix.http.base.internal.runtime.ListenerInfo;
import org.osgi.service.servlet.runtime.dto.FailedListenerDTO;
import org.osgi.service.servlet.runtime.dto.ListenerDTO;

public final class ListenerDTOBuilder {
    public static ListenerDTO build(ListenerInfo info, int reason) {
        ListenerDTO dto = reason == -1 ? new ListenerDTO() : new FailedListenerDTO();
        dto.serviceId = info.getServiceId();
        dto.types = Arrays.copyOf(info.getDTOListenerTypes(), info.getDTOListenerTypes().length);
        if (reason != -1) {
            ((FailedListenerDTO)dto).failureReason = reason;
        }
        return dto;
    }

    public static ListenerDTO build(ListenerHandler handler, int reason) {
        ListenerDTO dto = ListenerDTOBuilder.build(handler.getListenerInfo(), reason);
        dto.servletContextId = handler.getContextServiceId();
        return dto;
    }
}

