/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.config;

import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.bootstrap.config.PropertyLoader;
import com.navercorp.pinpoint.bootstrap.config.SimpleLogConfigResolver;
import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.util.PropertyUtils;
import com.navercorp.pinpoint.common.util.SimpleProperty;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

class ProfilePropertyLoader
implements PropertyLoader {
    private final BootLogger logger = BootLogger.getLogger(this.getClass());
    private final SimpleProperty javaSystemProperty;
    private final SimpleProperty osEnvProperty;
    private final Path agentRootPath;
    private final Path profilesPath;
    private final String[] supportedProfiles;
    public static final String[] ALLOWED_PROPERTY_PREFIX = new String[]{"bytecode.", "profiler.", "pinpoint."};

    public ProfilePropertyLoader(SimpleProperty javaSystemProperty, SimpleProperty osEnvProperty, Path agentRootPath, Path profilesPath, String[] supportedProfiles) {
        this.javaSystemProperty = Objects.requireNonNull(javaSystemProperty, "javaSystemProperty");
        this.osEnvProperty = Objects.requireNonNull(osEnvProperty, "osEnvProperty");
        this.agentRootPath = Objects.requireNonNull(agentRootPath, "agentRootPath");
        this.profilesPath = Objects.requireNonNull(profilesPath, "profilesPath");
        this.supportedProfiles = Objects.requireNonNull(supportedProfiles, "supportedProfiles");
    }

    @Override
    public Properties load() {
        Path defaultConfigPath = this.agentRootPath.resolve("pinpoint-root.config");
        Properties defaultProperties = new Properties();
        this.logger.info(String.format("load default config:%s", defaultConfigPath));
        this.loadFileProperties(defaultProperties, defaultConfigPath);
        String activeProfile = this.getActiveProfile(defaultProperties);
        this.logger.info(String.format("active profile:%s", activeProfile));
        Path profilePath = Paths.get(this.profilesPath.toString(), activeProfile, "pinpoint.config");
        this.logger.info(String.format("load profile:%s", profilePath));
        this.loadFileProperties(defaultProperties, profilePath);
        defaultProperties.setProperty("pinpoint.profiler.profiles.active", activeProfile);
        String externalConfig = this.javaSystemProperty.getProperty("pinpoint.config");
        if (externalConfig != null) {
            this.logger.info(String.format("load external config:%s", externalConfig));
            this.loadFileProperties(defaultProperties, Paths.get(externalConfig, new String[0]));
        }
        this.loadProperties(defaultProperties, this.osEnvProperty);
        this.loadProperties(defaultProperties, this.javaSystemProperty);
        this.saveAgentRootPath(this.agentRootPath, defaultProperties);
        this.saveLogConfigLocation(activeProfile, defaultProperties);
        return defaultProperties;
    }

    private void saveAgentRootPath(Path agentRootPath, Properties properties) {
        properties.put("pinpoint.agent.root.path", agentRootPath);
        this.logger.info(String.format("agent root path:%s", agentRootPath));
    }

    private void saveLogConfigLocation(String activeProfile, Properties properties) {
        String log4jLocation = properties.getProperty("pinpoint.profiler.log.config.location");
        if (StringUtils.isEmpty((String)log4jLocation)) {
            SimpleLogConfigResolver logConfigResolver = new SimpleLogConfigResolver(this.agentRootPath);
            log4jLocation = logConfigResolver.getLogPath().toString();
            properties.put("pinpoint.profiler.log.config.location", log4jLocation);
        }
        this.logger.info(String.format("logConfig path:%s", log4jLocation));
    }

    private String getActiveProfile(Properties defaultProperties) {
        String profile = this.javaSystemProperty.getProperty("pinpoint.profiler.profiles.active");
        if (profile == null) {
            profile = defaultProperties.getProperty("pinpoint.profiler.profiles.active");
        }
        if (profile == null) {
            throw new RuntimeException("Failed to detect pinpoint profile. Please add -Dpinpoint.profiler.profiles.active=<profile> to VM option. Valid profiles are \"" + String.join((CharSequence)" | ", this.supportedProfiles) + "\"");
        }
        for (String supportedProfile : this.supportedProfiles) {
            if (!supportedProfile.equalsIgnoreCase(profile)) continue;
            return supportedProfile;
        }
        throw new IllegalStateException("unsupported profile:" + profile);
    }

    private void loadFileProperties(Properties properties, Path filePath) {
        try {
            PropertyUtils.loadProperty((Properties)properties, (Path)filePath);
        }
        catch (IOException e) {
            this.logger.info(String.format("%s load fail Caused by:%s", filePath, e.getMessage()));
            throw new IllegalStateException(String.format("%s load fail Caused by:%s", filePath, e.getMessage()));
        }
    }

    private void loadProperties(Properties dstProperties, SimpleProperty property) {
        Set stringPropertyNames = property.stringPropertyNames();
        for (String propertyName : stringPropertyNames) {
            if (!this.isAllowPinpointProperty(propertyName)) continue;
            String val = property.getProperty(propertyName);
            dstProperties.setProperty(propertyName, val);
        }
    }

    @VisibleForTesting
    boolean isAllowPinpointProperty(String propertyName) {
        for (String prefix : ALLOWED_PROPERTY_PREFIX) {
            if (!propertyName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

