/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter;

import java.util.List;
import zipkin2.reporter.BytesMessageEncoder;

public enum Encoding {
    JSON{

        @Override
        public int listSizeInBytes(int encodedSizeInBytes) {
            return 2 + encodedSizeInBytes;
        }

        @Override
        public int listSizeInBytes(List<byte[]> values) {
            int sizeInBytes = 2;
            int i = 0;
            int length = values.size();
            while (i < length) {
                sizeInBytes += values.get(i++).length;
                if (i >= length) continue;
                ++sizeInBytes;
            }
            return sizeInBytes;
        }

        @Override
        public byte[] encode(List<byte[]> encodedSpans) {
            return BytesMessageEncoder.JSON.encode(encodedSpans);
        }

        @Override
        public String mediaType() {
            return "application/json";
        }
    }
    ,
    THRIFT{

        @Override
        public int listSizeInBytes(int encodedSizeInBytes) {
            return 5 + encodedSizeInBytes;
        }

        @Override
        public int listSizeInBytes(List<byte[]> values) {
            int sizeInBytes = 5;
            int length = values.size();
            for (int i = 0; i < length; ++i) {
                sizeInBytes += values.get(i).length;
            }
            return sizeInBytes;
        }

        @Override
        public byte[] encode(List<byte[]> encodedSpans) {
            return BytesMessageEncoder.THRIFT.encode(encodedSpans);
        }

        @Override
        public String mediaType() {
            return "application/x-thrift";
        }
    }
    ,
    PROTO3{

        @Override
        public int listSizeInBytes(int encodedSizeInBytes) {
            return encodedSizeInBytes;
        }

        @Override
        public int listSizeInBytes(List<byte[]> values) {
            int sizeInBytes = 0;
            int i = 0;
            int length = values.size();
            while (i < length) {
                sizeInBytes += values.get(i++).length;
            }
            return sizeInBytes;
        }

        @Override
        public byte[] encode(List<byte[]> encodedSpans) {
            return BytesMessageEncoder.PROTO3.encode(encodedSpans);
        }

        @Override
        public String mediaType() {
            return "application/x-protobuf";
        }
    };


    public abstract byte[] encode(List<byte[]> var1);

    public abstract int listSizeInBytes(int var1);

    public abstract int listSizeInBytes(List<byte[]> var1);

    public abstract String mediaType();
}

