/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class ResetCountDownLatch {
    private final RestSync restSync;

    public ResetCountDownLatch(int count) {
        this.restSync = new RestSync(count);
    }

    public void await() throws InterruptedException {
        this.restSync.acquireSharedInterruptibly(1);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.restSync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    public void countDown() {
        this.restSync.releaseShared(1);
    }

    public int getCount() {
        return this.restSync.getCount();
    }

    public void reset() {
        this.restSync.reset();
    }

    private static final class RestSync
    extends AbstractQueuedSynchronizer {
        private final int initCount;

        RestSync(int count) {
            if (count < 0) {
                throw new IllegalArgumentException("count must be greater than or equal to 0");
            }
            this.initCount = count;
            this.setState(count);
        }

        protected void reset() {
            this.setState(this.initCount);
        }

        int getCount() {
            return this.getState();
        }

        @Override
        protected int tryAcquireShared(int acquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int releases) {
            int nextCount;
            int count;
            do {
                if ((count = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(count, nextCount = count - 1));
            return nextCount == 0;
        }
    }
}

