/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.vendor;

import com.alibaba.druid.pool.ValidConnectionChecker;
import com.alibaba.druid.pool.ValidConnectionCheckerAdapter;
import com.alibaba.druid.util.StringUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Properties;

public class OracleValidConnectionChecker
extends ValidConnectionCheckerAdapter
implements ValidConnectionChecker,
Serializable {
    private static final long serialVersionUID = -2227528634302168877L;
    private int timeout = 1;
    private String defaultValidateQuery = "SELECT 'x' FROM DUAL";

    public OracleValidConnectionChecker() {
        this.configFromProperties(System.getProperties());
    }

    @Override
    public void configFromProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        String property = properties.getProperty("druid.oracle.pingTimeout");
        if (property != null && property.length() > 0) {
            int value = Integer.parseInt(property);
            this.setTimeout(value);
        }
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    @Override
    public boolean isValidConnection(Connection conn, String validateQuery, int validationQueryTimeout) throws Exception {
        if (conn.isClosed()) {
            return false;
        }
        if (StringUtils.isEmpty(validateQuery)) {
            validateQuery = this.defaultValidateQuery;
        }
        int queryTimeout = validationQueryTimeout <= 0 ? this.timeout : validationQueryTimeout;
        return ValidConnectionCheckerAdapter.execValidQuery(conn, validateQuery, queryTimeout);
    }
}

