/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.rebalance;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.rebalance.EventMeshRebalanceStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshRebalanceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventMeshRebalanceService.class);
    private final EventMeshTCPServer eventMeshTCPServer;
    private final Integer rebalanceIntervalMills;
    private final EventMeshRebalanceStrategy rebalanceStrategy;
    private ScheduledExecutorService serviceRebalanceScheduler;

    public EventMeshRebalanceService(EventMeshTCPServer eventMeshTCPServer, EventMeshRebalanceStrategy rebalanceStrategy) {
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.rebalanceStrategy = rebalanceStrategy;
        this.rebalanceIntervalMills = eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshTcpRebalanceIntervalInMills();
    }

    public void init() {
        this.serviceRebalanceScheduler = ThreadPoolFactory.createScheduledExecutor((int)5, (ThreadFactory)new EventMeshThreadFactory("proxy-rebalance-sch", true));
        log.info("rebalance service inited ......");
    }

    public void start() throws Exception {
        this.rebalanceStrategy.doRebalance();
        this.serviceRebalanceScheduler.scheduleAtFixedRate(() -> {
            try {
                this.rebalanceStrategy.doRebalance();
            }
            catch (Exception ex) {
                log.error("RebalanceByService failed", (Throwable)ex);
            }
        }, this.rebalanceIntervalMills.intValue(), this.rebalanceIntervalMills.intValue(), TimeUnit.MILLISECONDS);
        log.info("rebalance service started......");
    }

    public void shutdown() {
        this.serviceRebalanceScheduler.shutdown();
        log.info("rebalance service shutdown......");
    }

    public int getRebalanceThreadPoolQueueSize() {
        return ((ThreadPoolExecutor)((Object)this.serviceRebalanceScheduler)).getQueue().size();
    }
}

