/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler.v2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.NameFilter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import inet.ipaddr.IPAddress;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.common.config.ConfigField;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.admin.response.Result;
import org.apache.eventmesh.runtime.admin.response.v2.GetConfigurationResponse;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.configuration.EventMeshGrpcConfiguration;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.configuration.EventMeshTCPConfiguration;
import org.apache.eventmesh.runtime.constants.EventMeshVersion;
import org.apache.eventmesh.runtime.util.HttpRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshHttpHandler(path="/v2/configuration")
public class ConfigurationHandler
extends AbstractHttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationHandler.class);
    private final CommonConfiguration commonConfiguration;
    private final EventMeshTCPConfiguration eventMeshTCPConfiguration;
    private final EventMeshHTTPConfiguration eventMeshHTTPConfiguration;
    private final EventMeshGrpcConfiguration eventMeshGrpcConfiguration;

    public ConfigurationHandler(CommonConfiguration commonConfiguration, EventMeshTCPConfiguration eventMeshTCPConfiguration, EventMeshHTTPConfiguration eventMeshHTTPConfiguration, EventMeshGrpcConfiguration eventMeshGrpcConfiguration) {
        this.commonConfiguration = commonConfiguration;
        this.eventMeshTCPConfiguration = eventMeshTCPConfiguration;
        this.eventMeshHTTPConfiguration = eventMeshHTTPConfiguration;
        this.eventMeshGrpcConfiguration = eventMeshGrpcConfiguration;
    }

    @Override
    protected void get(HttpRequest httpRequest, ChannelHandlerContext ctx) {
        String format = HttpRequestUtil.getQueryParam(httpRequest, "format", "properties");
        String configs = HttpRequestUtil.getQueryParam(httpRequest, "configs", "exclusive");
        ArrayList<Object> filters = new ArrayList<Object>();
        switch (configs) {
            case "exclusive": {
                filters.add(new SuperClassFieldFilter());
                break;
            }
            case "all": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid param 'configs': " + configs);
            }
        }
        switch (format) {
            case "properties": {
                filters.add(new ConfigFieldFilter());
                break;
            }
            case "bean": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid param 'format': " + format);
            }
        }
        filters.add(new IPAddressToStringFilter());
        GetConfigurationResponse getConfigurationResponse = new GetConfigurationResponse(this.commonConfiguration, this.eventMeshTCPConfiguration, this.eventMeshHTTPConfiguration, this.eventMeshGrpcConfiguration, EventMeshVersion.getCurrentVersionDesc());
        String json = JSON.toJSONString(Result.success(getConfigurationResponse), (Filter[])filters.toArray(new Filter[0]), (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        this.writeJson(ctx, json);
    }

    static class IPAddressToStringFilter
    implements ValueFilter {
        IPAddressToStringFilter() {
        }

        public Object apply(Object object, String name, Object value) {
            if ((name.equals("eventMeshIpv4BlackList") || name.equals("eventMeshIpv6BlackList")) && value instanceof List) {
                ArrayList<String> ipList = new ArrayList<String>();
                for (Object o : (List)value) {
                    if (!(o instanceof IPAddress)) continue;
                    ipList.add(((IPAddress)o).toNormalizedString());
                }
                return ipList;
            }
            return value;
        }
    }

    static class SuperClassFieldFilter
    implements PropertyFilter {
        SuperClassFieldFilter() {
        }

        public boolean apply(Object object, String name, Object value) {
            try {
                Field field = this.findFieldInClassNonHierarchy(object.getClass(), name);
                return field != null;
            }
            catch (NoSuchFieldException e) {
                log.error("Failed to get field {} from object {}", new Object[]{name, object, e});
                return true;
            }
        }

        private Field findFieldInClassNonHierarchy(Class<?> clazz, String fieldName) throws NoSuchFieldException {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                Class<?> superclass = clazz.getSuperclass();
                if (superclass == null) {
                    throw e;
                }
                return null;
            }
        }
    }

    static class ConfigFieldFilter
    implements NameFilter {
        ConfigFieldFilter() {
        }

        public String process(Object object, String name, Object value) {
            try {
                ConfigField configField;
                String fieldAnnotationValue;
                Field field = this.findFieldInClassHierarchy(object.getClass(), name);
                if (field != null && field.isAnnotationPresent(ConfigField.class) && !(fieldAnnotationValue = (configField = field.getAnnotation(ConfigField.class)).field()).isEmpty()) {
                    Config config = object.getClass().getAnnotation(Config.class);
                    String prefix = config.prefix();
                    return prefix + "." + fieldAnnotationValue;
                }
            }
            catch (NoSuchFieldException e) {
                log.error("Failed to get field {} from object {}", new Object[]{name, object, e});
            }
            return name;
        }

        private Field findFieldInClassHierarchy(Class<?> clazz, String fieldName) throws NoSuchFieldException {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                Class<?> superclass = clazz.getSuperclass();
                if (superclass == null) {
                    throw e;
                }
                return this.findFieldInClassHierarchy(superclass, fieldName);
            }
        }
    }
}

