/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.module;

import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.context.module.ApplicationContextModuleFactory;
import com.navercorp.pinpoint.profiler.context.module.ModuleFactory;
import com.navercorp.pinpoint.profiler.context.module.ModuleFactoryResolver;
import java.lang.reflect.Constructor;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultModuleFactoryResolver
implements ModuleFactoryResolver {
    private static final String DEFAULT_MODULE_FACTORY = ApplicationContextModuleFactory.class.getName();
    private final Logger logger = LogManager.getLogger(DefaultModuleFactoryResolver.class);
    private final String moduleFactoryClazzName;

    public DefaultModuleFactoryResolver() {
        this(DEFAULT_MODULE_FACTORY);
    }

    public DefaultModuleFactoryResolver(String moduleFactoryClazzName) {
        this.moduleFactoryClazzName = this.getDefaultModuleFactoryClassName(moduleFactoryClazzName);
    }

    private String getDefaultModuleFactoryClassName(String moduleFactoryClazzName) {
        if (StringUtils.isEmpty((String)moduleFactoryClazzName)) {
            return DEFAULT_MODULE_FACTORY;
        }
        return moduleFactoryClazzName;
    }

    private boolean isDefaultModuleFactory(String moduleFactoryClazzName) {
        if (StringUtils.isEmpty((String)moduleFactoryClazzName)) {
            return true;
        }
        return DEFAULT_MODULE_FACTORY.equals(moduleFactoryClazzName);
    }

    @Override
    public ModuleFactory resolve() {
        this.logger.info("{} ModuleFactory lookup", (Object)this.moduleFactoryClazzName);
        if (this.isDefaultModuleFactory(this.moduleFactoryClazzName)) {
            return new ApplicationContextModuleFactory();
        }
        ClassLoader classLoader = this.getClassLoader(DefaultModuleFactoryResolver.class.getClassLoader());
        try {
            Class<?> moduleFactoryClass = Class.forName(this.moduleFactoryClazzName, true, classLoader);
            Constructor<?> constructor = moduleFactoryClass.getConstructor(new Class[0]);
            return (ModuleFactory)constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            this.logger.warn("{} ModuleFactory initialize fail", (Object)this.moduleFactoryClazzName, (Object)ex);
            throw new PinpointException(this.moduleFactoryClazzName + " ModuleFactory initialize fail", (Throwable)ex);
        }
    }

    private ClassLoader getClassLoader(ClassLoader classLoader) {
        return Objects.requireNonNull(classLoader, "can't find classLoader");
    }
}

