/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.profiler.context.CloseListener;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHandle;
import com.navercorp.pinpoint.profiler.context.id.LocalTraceRoot;
import com.navercorp.pinpoint.profiler.context.id.Shared;
import com.navercorp.pinpoint.profiler.context.storage.UriStatStorage;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class DefaultCloseListener
implements CloseListener {
    private final LocalTraceRoot traceRoot;
    @Nullable
    private final ActiveTraceHandle activeTraceHandle;
    @Nullable
    private final UriStatStorage uriStatStorage;

    public DefaultCloseListener(LocalTraceRoot traceRoot, ActiveTraceHandle activeTraceHandle, UriStatStorage uriStatStorage) {
        this.traceRoot = Objects.requireNonNull(traceRoot, "traceRoot");
        this.activeTraceHandle = activeTraceHandle;
        this.uriStatStorage = uriStatStorage;
    }

    @Override
    public void close(long endTime) {
        this.recordUriTemplate(endTime);
        this.purgeActiveTrace(endTime);
    }

    private void recordUriTemplate(long afterTime) {
        UriStatStorage copy = this.uriStatStorage;
        if (copy == null) {
            return;
        }
        Shared shared = this.traceRoot.getShared();
        String uriTemplate = shared.getUriTemplate();
        String httpMethod = shared.getHttpMethod();
        long traceStartTime = this.traceRoot.getTraceStartTime();
        boolean status = this.getStatus(shared.getErrorCode());
        copy.store(uriTemplate, httpMethod, status, traceStartTime, afterTime);
    }

    private boolean getStatus(int errorCode) {
        return errorCode == 0;
    }

    private void purgeActiveTrace(long currentTime) {
        ActiveTraceHandle copy = this.activeTraceHandle;
        if (copy != null) {
            copy.purge(currentTime);
        }
    }
}

