/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.remote.payload;

import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.common.remote.payload.IPayload;

public class PayloadFactory {
    private final Map<String, Class<?>> registryPayload = new ConcurrentHashMap();
    private boolean initialized = false;

    private PayloadFactory() {
    }

    public static PayloadFactory getInstance() {
        return PayloadFactoryHolder.INSTANCE;
    }

    public void init() {
        this.scan();
    }

    private synchronized void scan() {
        if (this.initialized) {
            return;
        }
        ServiceLoader<IPayload> payloads = ServiceLoader.load(IPayload.class);
        for (IPayload payload : payloads) {
            this.register(payload.getClass().getSimpleName(), payload.getClass());
        }
        this.initialized = true;
    }

    public void register(String type, Class<?> clazz) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return;
        }
        if (this.registryPayload.containsKey(type)) {
            throw new RuntimeException(String.format("Fail to register, type:%s ,clazz:%s ", type, clazz.getName()));
        }
        this.registryPayload.put(type, clazz);
    }

    public Class<?> getClassByType(String type) {
        return this.registryPayload.get(type);
    }

    private static class PayloadFactoryHolder {
        private static final PayloadFactory INSTANCE = new PayloadFactory();

        private PayloadFactoryHolder() {
        }
    }
}

