/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import java.util.Enumeration;

public class DelegateEnumeration<E>
implements Enumeration<E> {
    private static final Object NULL_OBJECT = new Object();
    private final Enumeration<E> delegate;
    private final Filter<E> filter;
    private boolean hasMoreElements;
    private E nextElement;
    private Exception nextException;
    private static final Filter SKIP_FILTER = new Filter(){

        public boolean filter(Object o) {
            return false;
        }
    };

    public DelegateEnumeration(Enumeration<E> delegate) {
        this(delegate, SKIP_FILTER);
    }

    public DelegateEnumeration(Enumeration<E> delegate, Filter<E> filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public boolean hasMoreElements() {
        this.next(true);
        return this.hasMoreElements;
    }

    @Override
    public E nextElement() {
        this.next(false);
        if (this.nextException != null) {
            Exception exception = this.nextException;
            this.clearNext();
            this.throwException(exception);
        }
        E result = this.getNextElement();
        this.clearNext();
        return result;
    }

    private void clearNext() {
        this.nextException = null;
        this.nextElement = null;
    }

    private E getNextElement() {
        if (this.nextElement == NULL_OBJECT) {
            return null;
        }
        return this.nextElement;
    }

    private <T extends Exception> void throwException(Exception exception) throws T {
        throw exception;
    }

    private void next(boolean hasMoreElementMethod) {
        block5: {
            boolean nextExist;
            E nextElement;
            if (this.nextElement != null || this.nextException != null) {
                return;
            }
            do {
                if (!(nextExist = this.delegate.hasMoreElements()) && hasMoreElementMethod) {
                    this.hasMoreElements = false;
                    return;
                }
                try {
                    nextElement = this.delegate.nextElement();
                }
                catch (Exception e) {
                    this.hasMoreElements = nextExist;
                    this.nextException = e;
                    break block5;
                }
            } while (this.filter.filter(nextElement));
            this.hasMoreElements = nextExist;
            this.nextElement = nextElement == null ? NULL_OBJECT : nextElement;
        }
    }

    Exception _getNextException() {
        return this.nextException;
    }

    public static interface Filter<E> {
        public boolean filter(E var1);
    }
}

