/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.data.bean;

import java.util.Collection;
import java.util.List;
import org.apache.empire.commons.BeanPropertyUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.Entity;
import org.apache.empire.data.Record;
import org.apache.empire.data.bean.BeanClass;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.exceptions.PropertyReadOnlyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanRecordProxy<T>
implements Record {
    protected static final Logger log = LoggerFactory.getLogger(BeanRecordProxy.class);
    protected final Entity entity;
    protected final List<Column> columns;
    protected final Column[] keyColumns;
    protected T data;
    protected boolean[] modified;

    public BeanRecordProxy(T data, List<Column> columns, Column[] keyColumns, Entity entity) {
        this.data = data;
        this.columns = columns;
        this.keyColumns = keyColumns;
        this.entity = entity;
    }

    public BeanRecordProxy(List<Column> columns, Column[] keyColumns, Entity entity) {
        this(null, columns, keyColumns, entity);
    }

    public BeanRecordProxy(T data, BeanClass beanClass) {
        this(data, ObjectUtils.convert(Column.class, beanClass.getProperties()), beanClass.getKeyColumns(), beanClass);
    }

    public BeanRecordProxy(BeanClass beanClass) {
        this(null, beanClass);
    }

    public T getBean() {
        return this.data;
    }

    public void setBean(T data) {
        this.data = data;
    }

    @Override
    public Column getColumn(int index) {
        return this.columns.get(index);
    }

    @Override
    public Column[] getKeyColumns() {
        return this.keyColumns;
    }

    @Override
    public Object[] getKey() {
        if (this.keyColumns == null) {
            return null;
        }
        Object[] key = new Object[this.keyColumns.length];
        for (int i = 0; i < this.keyColumns.length; ++i) {
            key[i] = this.get(this.keyColumns[i]);
        }
        return key;
    }

    @Override
    public int getFieldCount() {
        return this.columns.size();
    }

    @Override
    public int getFieldIndex(ColumnExpr column) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).equals(column)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getFieldIndex(String columnName) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).getName().equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Options getFieldOptions(Column column) {
        return column.getOptions();
    }

    @Override
    public boolean isFieldVisible(Column column) {
        return true;
    }

    @Override
    public boolean isFieldReadOnly(Column column) {
        if (!this.isNew() && ObjectUtils.contains(this.keyColumns, column)) {
            return true;
        }
        if (column.isAutoGenerated()) {
            return true;
        }
        return column.isReadOnly();
    }

    @Override
    public boolean isFieldRequired(Column column) {
        return column.isRequired();
    }

    @Override
    public boolean isModified() {
        return this.modified != null;
    }

    @Override
    public boolean isNew() {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        if (this.keyColumns != null) {
            for (int i = 0; i < this.keyColumns.length; ++i) {
                Object value = this.get(this.keyColumns[i]);
                if (value instanceof Number && ((Number)value).longValue() == 0L) {
                    return true;
                }
                if (!ObjectUtils.isEmpty(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public boolean isValid() {
        return this.data != null;
    }

    @Override
    public boolean isReadOnly() {
        return !this.isValid();
    }

    @Override
    public final Object getValue(int index) {
        return this.get(this.getColumn(index));
    }

    @Override
    public final <V> V getValue(int index, Class<V> valueType) {
        return this.get(this.getColumn(index), valueType);
    }

    @Override
    public <V> V get(ColumnExpr column, Class<V> valueType) {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        Object value = this.getBeanProperty(this.data, column);
        return ObjectUtils.convertColumnValue(column, value, valueType);
    }

    @Override
    public final Object get(ColumnExpr column) {
        return this.get(column, Object.class);
    }

    @Override
    public boolean isNull(ColumnExpr column) {
        return ObjectUtils.isEmpty(this.get(column));
    }

    @Override
    public boolean isNull(int index) {
        return this.isNull(this.getColumn(index));
    }

    @Override
    public Object validateValue(Column column, Object value) {
        return column.validateValue(value);
    }

    @Override
    public BeanRecordProxy<T> set(Column column, Object value) {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        if (!ObjectUtils.compareEqual(this.get(column), value)) {
            if (this.modified == null) {
                this.modified = new boolean[this.columns.size()];
            }
            this.modified[this.getFieldIndex((ColumnExpr)column)] = true;
        }
        value = this.validateValue(column, value);
        this.setBeanProperty(this.data, column, value);
        return this;
    }

    @Override
    public final void setValue(int i, Object value) {
        this.set(this.getColumn(i), value);
    }

    @Override
    public boolean wasModified(Column column) {
        int index = this.getFieldIndex(column);
        if (index < 0) {
            throw new ItemNotFoundException((Object)column.getName());
        }
        return this.modified != null && this.modified[index];
    }

    public void clearModified() {
        this.modified = null;
    }

    public final String getText(ColumnExpr column) {
        Object value = this.get(column);
        return this.formatValue(column, value);
    }

    public int setBeanProperties(Object bean) {
        return this.setBeanProperties(bean, null);
    }

    @Override
    public int setBeanProperties(Object bean, Collection<? extends ColumnExpr> ignoreList) {
        int count = 0;
        for (int i = 0; i < this.getFieldCount(); ++i) {
            Column column = this.getColumn(i);
            if (column.isReadOnly() || ignoreList != null && ignoreList.contains(column)) continue;
            this.setBeanProperty(bean, column, this.getValue(i));
        }
        return count;
    }

    @Override
    public int setRecordValues(Object bean, Collection<Column> ignoreList) {
        int count = 0;
        for (int i = 0; i < this.getFieldCount(); ++i) {
            Column column = this.getColumn(i);
            if (column.isReadOnly() || ignoreList != null && ignoreList.contains(column)) continue;
            String property = column.getBeanPropertyName();
            Object value = this.getBeanProperty(bean, property);
            this.set(column, value);
            ++count;
        }
        return count;
    }

    @Override
    public int setRecordValues(Object bean) {
        return this.setRecordValues(bean, null);
    }

    protected final Object getBeanProperty(Object bean, ColumnExpr column) {
        if (bean == null) {
            throw new InvalidArgumentException("bean", bean);
        }
        if (column == null) {
            throw new InvalidArgumentException("column", column);
        }
        return this.getBeanProperty(bean, column.getBeanPropertyName());
    }

    protected Object getBeanProperty(Object bean, String property) {
        return BeanPropertyUtils.getProperty(bean, property);
    }

    protected void setBeanProperty(Object bean, Column column, Object value) {
        String property;
        Class<Enum<?>> enumType;
        if (value != null && (enumType = column.getEnumType()) != null) {
            value = ObjectUtils.getEnum(enumType, value);
        }
        if (!BeanPropertyUtils.setProperty(bean, property = column.getBeanPropertyName(), value)) {
            if (BeanPropertyUtils.hasProperty(bean, property, true) == 0) {
                throw new PropertyReadOnlyException(property);
            }
            log.info("The bean property \"{}\" does not exist on {} and will be ignored!", (Object)property, (Object)bean.getClass().getName());
        }
    }

    protected String formatValue(ColumnExpr column, Object value) {
        return ObjectUtils.formatColumnValue(column, value, null);
    }
}

