/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.BucketExceptions;
import java.time.Duration;
import java.time.Instant;

public class Refill {
    static final long UNSPECIFIED_TIME_OF_FIRST_REFILL = Long.MIN_VALUE;
    final long periodNanos;
    final long tokens;
    final boolean refillIntervally;
    final long timeOfFirstRefillMillis;
    final boolean useAdaptiveInitialTokens;

    private Refill(long tokens, Duration period, boolean refillIntervally, long timeOfFirstRefillMillis, boolean useAdaptiveInitialTokens) {
        if (period == null) {
            throw BucketExceptions.nullRefillPeriod();
        }
        if (tokens <= 0L) {
            throw BucketExceptions.nonPositivePeriodTokens(tokens);
        }
        this.periodNanos = period.toNanos();
        if (this.periodNanos <= 0L) {
            throw BucketExceptions.nonPositivePeriod(this.periodNanos);
        }
        if (tokens > this.periodNanos) {
            throw BucketExceptions.tooHighRefillRate(this.periodNanos, tokens);
        }
        this.tokens = tokens;
        this.refillIntervally = refillIntervally;
        this.timeOfFirstRefillMillis = timeOfFirstRefillMillis;
        this.useAdaptiveInitialTokens = useAdaptiveInitialTokens;
    }

    @Deprecated
    public static Refill of(long tokens, Duration period) {
        return Refill.greedy(tokens, period);
    }

    @Deprecated
    public static Refill smooth(long tokens, Duration period) {
        return Refill.greedy(tokens, period);
    }

    public static Refill greedy(long tokens, Duration period) {
        return new Refill(tokens, period, false, Long.MIN_VALUE, false);
    }

    public static Refill intervally(long tokens, Duration period) {
        return new Refill(tokens, period, true, Long.MIN_VALUE, false);
    }

    public static Refill intervallyAligned(long tokens, Duration period, Instant timeOfFirstRefill, boolean useAdaptiveInitialTokens) {
        long timeOfFirstRefillMillis = timeOfFirstRefill.toEpochMilli();
        if (timeOfFirstRefillMillis < 0L) {
            throw BucketExceptions.nonPositiveTimeOfFirstRefill(timeOfFirstRefill);
        }
        return new Refill(tokens, period, true, timeOfFirstRefillMillis, useAdaptiveInitialTokens);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Refill{");
        sb.append("periodNanos=").append(this.periodNanos);
        sb.append(", tokens=").append(this.tokens);
        sb.append(", refillIntervally=").append(this.refillIntervally);
        sb.append(", timeOfFirstRefillMillis=").append(this.timeOfFirstRefillMillis);
        sb.append(", useAdaptiveInitialTokens=").append(this.useAdaptiveInitialTokens);
        sb.append('}');
        return sb.toString();
    }
}

