/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Scanner;
import javax.inject.Inject;
import javax.inject.Named;
import org.schemarepo.AbstractBackendRepository;
import org.schemarepo.RepositoryUtil;
import org.schemarepo.SchemaEntry;
import org.schemarepo.SchemaValidationException;
import org.schemarepo.Subject;
import org.schemarepo.SubjectCache;
import org.schemarepo.SubjectConfig;
import org.schemarepo.ValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileSystemRepository
extends AbstractBackendRepository {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String LOCKFILE = ".repo.lock";
    private static final String SUBJECT_PROPERTIES = "subject.properties";
    private static final String SCHEMA_IDS = "schema_ids";
    private static final String SCHEMA_POSTFIX = ".schema";
    private final File rootDir;
    private final FileChannel lockChannel;
    private final FileLock fileLock;

    @Inject
    public LocalFileSystemRepository(@Named(value="schema-repo.local-file-system.path") String repoPath, ValidatorFactory validators) {
        super(validators);
        this.rootDir = new File(repoPath);
        if (!this.rootDir.exists() && !this.rootDir.mkdirs() || !this.rootDir.isDirectory()) {
            throw new RuntimeException("Unable to create repo directory, or not a directory: " + this.rootDir.getAbsolutePath());
        }
        try {
            File lockfile = new File(this.rootDir, LOCKFILE);
            lockfile.createNewFile();
            RandomAccessFile raf = new RandomAccessFile(lockfile, "rw");
            this.lockChannel = raf.getChannel();
            this.fileLock = this.lockChannel.tryLock();
            if (this.fileLock == null) {
                throw new IllegalStateException("Failed to lock file: " + lockfile.getAbsolutePath());
            }
            lockfile.deleteOnExit();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to lock repository directory: " + this.rootDir.getAbsolutePath(), e);
        }
        this.loadSubjects(this.rootDir, this.subjectCache);
    }

    private void loadSubjects(File repoDir, SubjectCache subjects) {
        for (File file : repoDir.listFiles()) {
            if (!file.isDirectory()) continue;
            subjects.add(new FileSubject(file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        try {
            this.fileLock.release();
        }
        catch (IOException e) {
            this.logger.debug("Failed to release the lock {}", (Object)this.fileLock, (Object)e);
        }
        finally {
            this.closed = true;
            try {
                this.lockChannel.close();
            }
            catch (IOException e) {
                this.logger.debug("Failed to close lockChannel {}", (Object)this.lockChannel, (Object)e);
            }
        }
        try {
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected Subject getSubjectInstance(String subjectName) {
        return new FileSubject(new File(this.rootDir, subjectName));
    }

    @Override
    protected void registerSubjectInBackend(String subjectName, SubjectConfig config) {
        File subjectDir = new File(this.rootDir, subjectName);
        if (subjectDir.exists()) {
            throw new RuntimeException("Cannot create a FileSubject, directory already exists: " + subjectDir.getAbsolutePath());
        }
        if (!subjectDir.mkdir()) {
            throw new RuntimeException("Cannot create a FileSubject dir: " + subjectDir.getAbsolutePath());
        }
        LocalFileSystemRepository.createNewFileInDir(subjectDir, SCHEMA_IDS);
        File subjectProperties = LocalFileSystemRepository.createNewFileInDir(subjectDir, SUBJECT_PROPERTIES);
        Properties props = new Properties();
        props.putAll(RepositoryUtil.safeConfig(config).asMap());
        LocalFileSystemRepository.writePropertyFile(subjectProperties, props);
    }

    private static File createNewFileInDir(File dir, String filename) {
        File result = new File(dir, filename);
        try {
            if (!result.createNewFile()) {
                throw new RuntimeException(result.getAbsolutePath() + " already exists");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create file: " + result.getAbsolutePath(), e);
        }
        return result;
    }

    private static void writeToFile(File file, WriteOp op, boolean append) {
        FileOutputStream out;
        try {
            out = new FileOutputStream(file, append);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not open file for write: " + file.getAbsolutePath());
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            BufferedWriter bwriter = new BufferedWriter(writer);
            op.write(bwriter);
            bwriter.flush();
            bwriter.close();
            writer.close();
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write and close file " + file.getAbsolutePath());
        }
    }

    private static void writePropertyFile(File file, final Properties prop) {
        LocalFileSystemRepository.writeToFile(file, new WriteOp(){

            @Override
            protected void write(Writer writer) throws IOException {
                prop.store(writer, "Schema Repository Subject Properties");
            }
        }, false);
    }

    private static void appendLineToFile(File file, final String line) {
        LocalFileSystemRepository.writeToFile(file, new WriteOp(){

            @Override
            protected void write(Writer writer) throws IOException {
                writer.append(line).append('\n');
            }
        }, true);
    }

    private static void dirExists(File dir) {
        if (!dir.exists() || !dir.isDirectory()) {
            throw new RuntimeException("directory does not exist or is not a directory: " + dir.toString());
        }
    }

    private static void fileReadable(File file) {
        if (!file.canRead()) {
            throw new RuntimeException("file does not exist or is not readable: " + file.toString());
        }
    }

    private static void fileWriteable(File file) {
        if (!file.canWrite()) {
            throw new RuntimeException("file does not exist or is not writeable: " + file.toString());
        }
    }

    @Override
    protected Map<String, String> exposeConfiguration() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(super.exposeConfiguration());
        properties.put("schema-repo.local-file-system.path", this.rootDir.getAbsolutePath());
        return properties;
    }

    private class FileSubject
    extends Subject {
        private final File subjectDir;
        private final File idFile;
        private final File propertyFile;
        private final SubjectConfig config;
        private int largestId;
        private SchemaEntry latest;

        private FileSubject(File dir) {
            super(dir.getName());
            this.largestId = -1;
            this.subjectDir = dir;
            this.idFile = new File(dir, LocalFileSystemRepository.SCHEMA_IDS);
            this.propertyFile = new File(dir, LocalFileSystemRepository.SUBJECT_PROPERTIES);
            LocalFileSystemRepository.dirExists(this.subjectDir);
            LocalFileSystemRepository.fileReadable(this.idFile);
            LocalFileSystemRepository.fileWriteable(this.idFile);
            LocalFileSystemRepository.fileReadable(this.propertyFile);
            LocalFileSystemRepository.fileWriteable(this.propertyFile);
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(this.propertyFile));
                this.config = RepositoryUtil.configFromProperties(props);
                Integer lastId = null;
                HashSet<String> schemaFileNames = this.getSchemaFiles();
                HashSet<Integer> foundIds = new HashSet<Integer>();
                for (Integer id : this.getSchemaIds()) {
                    if (id > this.largestId) {
                        this.largestId = id;
                    }
                    lastId = id;
                    if (!foundIds.add(id)) {
                        throw new RuntimeException("Corrupt id file, id '" + id + "' duplicated in " + this.idFile.getAbsolutePath());
                    }
                    LocalFileSystemRepository.fileReadable(this.getSchemaFile(id));
                    schemaFileNames.remove(this.getSchemaFileName(id));
                }
                if (schemaFileNames.size() > 0) {
                    throw new RuntimeException("Schema files found in subject directory " + this.subjectDir.getAbsolutePath() + " that are not referenced in the " + LocalFileSystemRepository.SCHEMA_IDS + " file: " + schemaFileNames.toString());
                }
                if (lastId != null) {
                    this.latest = new SchemaEntry(lastId.toString(), this.readSchemaForId(lastId.toString()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("error initializing subject: " + this.subjectDir.getAbsolutePath(), e);
            }
        }

        @Override
        public SubjectConfig getConfig() {
            return this.config;
        }

        @Override
        public synchronized SchemaEntry register(String schema) throws SchemaValidationException {
            LocalFileSystemRepository.this.isValid();
            RepositoryUtil.validateSchemaOrSubject(schema);
            SchemaEntry entry = this.lookupBySchema(schema);
            if (entry == null) {
                entry = this.createNewSchemaFile(schema);
                LocalFileSystemRepository.appendLineToFile(this.idFile, entry.getId());
                this.latest = entry;
            }
            return entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized SchemaEntry createNewSchemaFile(String schema) {
            try {
                int newId = this.largestId + 1;
                File f = this.getSchemaFile(String.valueOf(newId));
                if (!f.exists() && f.createNewFile()) {
                    BufferedWriter output = new BufferedWriter(new FileWriter(f));
                    try {
                        output.write(schema);
                        ((Writer)output).flush();
                    }
                    finally {
                        ((Writer)output).close();
                    }
                    this.latest = new SchemaEntry(String.valueOf(newId), schema);
                    ++this.largestId;
                    return this.latest;
                }
                throw new RuntimeException("Unable to register schema, schema file either exists already  or couldn't create new file");
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Unable to register schema, invalid schema latest schema id ", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to register schema, couldn't create schema file ", e);
            }
        }

        @Override
        public synchronized SchemaEntry registerIfLatest(String schema, SchemaEntry latest) throws SchemaValidationException {
            LocalFileSystemRepository.this.isValid();
            if (latest == this.latest || latest != null && latest.equals(this.latest)) {
                return this.register(schema);
            }
            return null;
        }

        @Override
        public synchronized SchemaEntry lookupBySchema(String schema) {
            LocalFileSystemRepository.this.isValid();
            RepositoryUtil.validateSchemaOrSubject(schema);
            for (Integer id : this.getSchemaIds()) {
                String idStr = id.toString();
                String schemaInFile = this.readSchemaForIdOrNull(idStr);
                if (!schema.equals(schemaInFile)) continue;
                return new SchemaEntry(idStr, schema);
            }
            return null;
        }

        @Override
        public synchronized SchemaEntry lookupById(String id) {
            LocalFileSystemRepository.this.isValid();
            String schema = this.readSchemaForIdOrNull(id);
            if (schema != null) {
                return new SchemaEntry(id, schema);
            }
            return null;
        }

        @Override
        public synchronized SchemaEntry latest() {
            LocalFileSystemRepository.this.isValid();
            return this.latest;
        }

        @Override
        public synchronized Iterable<SchemaEntry> allEntries() {
            LocalFileSystemRepository.this.isValid();
            ArrayList<SchemaEntry> entries = new ArrayList<SchemaEntry>();
            for (Integer id : this.getSchemaIds()) {
                String idStr = id.toString();
                String schema = this.readSchemaForId(idStr);
                entries.add(new SchemaEntry(idStr, schema));
            }
            Collections.reverse(entries);
            return entries;
        }

        @Override
        public boolean integralKeys() {
            return true;
        }

        private String readSchemaForIdOrNull(String id) {
            try {
                return this.readSchemaForId(id);
            }
            catch (Exception e) {
                return null;
            }
        }

        private String readSchemaForId(String id) {
            File schemaFile = this.getSchemaFile(id);
            return this.readSchemaFile(schemaFile);
        }

        private String readSchemaFile(File schemaFile) {
            try {
                return this.readAllAsString(schemaFile);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not read schema contents at: " + schemaFile.getAbsolutePath(), e);
            }
        }

        private String readAllAsString(File file) throws FileNotFoundException {
            Scanner s = new Scanner(file, "UTF-8").useDelimiter("\\A");
            try {
                String string = s.next();
                return string;
            }
            catch (NoSuchElementException e) {
                throw new RuntimeException("file is empty: " + file.getAbsolutePath(), e);
            }
            finally {
                s.close();
            }
        }

        private HashSet<String> getSchemaFiles() {
            String[] files = this.subjectDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return null != name && name.endsWith(LocalFileSystemRepository.SCHEMA_POSTFIX);
                }
            });
            return new HashSet<String>(Arrays.asList(files));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Integer> getSchemaIds() {
            Scanner s = this.getIdFileScanner();
            ArrayList<Integer> ids = new ArrayList<Integer>();
            try {
                while (s.hasNextLine()) {
                    if (s.hasNext()) {
                        ids.add(s.nextInt());
                    }
                    s.nextLine();
                }
                ArrayList<Integer> arrayList = ids;
                return arrayList;
            }
            finally {
                s.close();
            }
        }

        private Scanner getIdFileScanner() {
            try {
                return new Scanner(this.idFile, "UTF-8");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Unable to read schema id file: " + this.idFile.getAbsolutePath(), e);
            }
        }

        private File getSchemaFile(String id) {
            return new File(this.subjectDir, this.getSchemaFileName(id));
        }

        private File getSchemaFile(int id) {
            return this.getSchemaFile(String.valueOf(id));
        }

        private String getSchemaFileName(String id) {
            return id + LocalFileSystemRepository.SCHEMA_POSTFIX;
        }

        private String getSchemaFileName(int id) {
            return this.getSchemaFileName(String.valueOf(id));
        }
    }

    private static abstract class WriteOp {
        private WriteOp() {
        }

        protected abstract void write(Writer var1) throws IOException;
    }
}

