/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo.api;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.schemarepo.Repository;
import org.schemarepo.SchemaEntry;
import org.schemarepo.SchemaValidationException;
import org.schemarepo.Subject;
import org.schemarepo.SubjectConfig;
import org.schemarepo.api.converter.Converter;

public class TypedSchemaRepository<ID, SCHEMA, SUBJECT> {
    private Repository repo;
    private Converter<ID> convertId;
    private Converter<SCHEMA> convertSchema;
    private Converter<SUBJECT> convertSubject;
    private SubjectConfig.Builder defaultSubjectConfigBuilder;
    private Map<SUBJECT, BiMap<ID, SCHEMA>> subjectToIdToSchemaCache;

    public TypedSchemaRepository(Repository repo, Converter<ID> idConverter, Converter<SCHEMA> schemaConverter, Converter<SUBJECT> subjectConverter, SubjectConfig.Builder defaultSubjectConfigBuilder) {
        this.repo = repo;
        this.convertId = idConverter;
        this.convertSchema = schemaConverter;
        this.convertSubject = subjectConverter;
        this.defaultSubjectConfigBuilder = defaultSubjectConfigBuilder;
        this.subjectToIdToSchemaCache = new HashMap<SUBJECT, BiMap<ID, SCHEMA>>();
    }

    public TypedSchemaRepository(Repository repo, Converter<ID> idConverter, Converter<SCHEMA> schemaConverter, Converter<SUBJECT> subjectConverter) {
        this(repo, idConverter, schemaConverter, subjectConverter, new SubjectConfig.Builder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BiMap<ID, SCHEMA> getIdToSchemaCache(SUBJECT subjectName) {
        HashBiMap idToSchemaCache = this.subjectToIdToSchemaCache.get(subjectName);
        if (idToSchemaCache == null) {
            TypedSchemaRepository typedSchemaRepository = this;
            synchronized (typedSchemaRepository) {
                idToSchemaCache = this.subjectToIdToSchemaCache.get(subjectName);
                if (idToSchemaCache == null) {
                    idToSchemaCache = HashBiMap.create();
                    this.subjectToIdToSchemaCache.put(subjectName, (BiMap<ID, SCHEMA>)idToSchemaCache);
                }
            }
        }
        return idToSchemaCache;
    }

    private BiMap<SCHEMA, ID> getSchemaToIdCache(SUBJECT subjectName) {
        return this.getIdToSchemaCache(subjectName).inverse();
    }

    public SCHEMA getSchema(SUBJECT subjectName, ID id) {
        SchemaEntry schemaEntry;
        Subject subject;
        Object schema = null;
        Map idToSchemaCache = (Map)this.subjectToIdToSchemaCache.get(subjectName);
        if (idToSchemaCache != null) {
            schema = idToSchemaCache.get(id);
        }
        if (schema == null && (subject = this.repo.lookup(this.convertSubject.toString(subjectName))) != null && (schemaEntry = subject.lookupById(this.convertId.toString(id))) != null) {
            schema = this.convertSchema.fromString(schemaEntry.getSchema());
            this.getIdToSchemaCache(subjectName).put(id, schema);
        }
        return (SCHEMA)schema;
    }

    public SCHEMA getLatestSchema(SUBJECT subjectName) {
        Object id;
        BiMap<ID, SCHEMA> idToSchemaCache;
        SchemaEntry schemaEntry;
        Object schema = null;
        Subject subject = this.repo.lookup(this.convertSubject.toString(subjectName));
        if (subject != null && (schemaEntry = subject.latest()) != null && (schema = (Object)(idToSchemaCache = this.getIdToSchemaCache(subjectName)).get(id = this.convertId.fromString(schemaEntry.getId()))) == null) {
            schema = this.convertSchema.fromString(schemaEntry.getSchema());
            idToSchemaCache.put((Object)id, (Object)schema);
        }
        return (SCHEMA)schema;
    }

    public ID getSchemaId(SUBJECT subjectName, SCHEMA schema) {
        SchemaEntry schemaEntry;
        Subject subject;
        Object id = null;
        BiMap<ID, SCHEMA> idToSchemaCache = this.subjectToIdToSchemaCache.get(subjectName);
        if (idToSchemaCache != null) {
            id = idToSchemaCache.inverse().get(schema);
        }
        if (id == null && (subject = this.repo.lookup(this.convertSubject.toString(subjectName))) != null && (schemaEntry = subject.lookupBySchema(this.convertSchema.toString(schema))) != null) {
            id = this.convertId.fromString(schemaEntry.getId());
            this.getSchemaToIdCache(subjectName).put(schema, id);
        }
        return (ID)id;
    }

    public ID registerSchema(SUBJECT subjectName, SCHEMA schema) throws SchemaValidationException {
        BiMap<SCHEMA, ID> schemaToIdCache = this.getSchemaToIdCache(subjectName);
        Object id = schemaToIdCache.get(schema);
        if (id == null) {
            Subject subject = this.repo.lookup(this.convertSubject.toString(subjectName));
            if (subject == null) {
                subject = this.repo.register(this.convertSubject.toString(subjectName), this.defaultSubjectConfigBuilder.build());
            }
            SchemaEntry schemaEntry = subject.register(this.convertSchema.toString(schema));
            id = this.convertId.fromString(schemaEntry.getId());
            schemaToIdCache.put(schema, id);
        }
        return (ID)id;
    }

    public SubjectConfig getConfig(SUBJECT subjectName) {
        Subject subject = this.repo.lookup(this.convertSubject.toString(subjectName));
        if (subject != null) {
            return subject.getConfig();
        }
        return null;
    }

    public void setConfig(SUBJECT subjectName, SubjectConfig subjectConfig) {
        this.repo.register(this.convertSubject.toString(subjectName), subjectConfig);
    }

    public List<SUBJECT> getSubjects() {
        ArrayList subjects = Lists.newArrayList();
        for (Subject subject : this.repo.subjects()) {
            subjects.add(this.convertSubject.fromString(subject.getName()));
        }
        return subjects;
    }
}

