/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskQueue;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.autoscaling.ScalingStats;
import org.apache.druid.indexing.overlord.supervisor.SupervisorManager;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.metrics.TaskCountStatsProvider;
import org.apache.druid.server.metrics.TaskSlotCountStatsProvider;

public class TaskMaster
implements TaskCountStatsProvider,
TaskSlotCountStatsProvider {
    private final TaskActionClientFactory taskActionClientFactory;
    private final SupervisorManager supervisorManager;
    private volatile TaskRunner taskRunner;
    private volatile TaskQueue taskQueue;
    private final AtomicReference<LeadershipState> leadershipState = new AtomicReference<LeadershipState>(LeadershipState.NOT_LEADER);

    @Inject
    public TaskMaster(TaskActionClientFactory taskActionClientFactory, SupervisorManager supervisorManager) {
        this.taskActionClientFactory = taskActionClientFactory;
        this.supervisorManager = supervisorManager;
    }

    public void becomeHalfLeader(TaskRunner taskRunner, TaskQueue taskQueue) {
        this.taskRunner = taskRunner;
        this.taskQueue = taskQueue;
        this.leadershipState.set(LeadershipState.HALF_LEADER);
    }

    public void downgradeToHalfLeader() {
        this.leadershipState.compareAndSet(LeadershipState.FULL_LEADER, LeadershipState.HALF_LEADER);
    }

    public void becomeFullLeader() {
        this.leadershipState.set(LeadershipState.FULL_LEADER);
    }

    public void stopBeingLeader() {
        this.leadershipState.set(LeadershipState.NOT_LEADER);
        this.taskQueue = null;
        this.taskRunner = null;
    }

    public Optional<TaskRunner> getTaskRunner() {
        if (this.isHalfOrFullLeader()) {
            return Optional.of((Object)this.taskRunner);
        }
        return Optional.absent();
    }

    public Optional<TaskQueue> getTaskQueue() {
        if (this.isHalfOrFullLeader()) {
            return Optional.of((Object)this.taskQueue);
        }
        return Optional.absent();
    }

    public Optional<TaskActionClient> getTaskActionClient(Task task) {
        if (this.isHalfOrFullLeader()) {
            return Optional.of((Object)this.taskActionClientFactory.create(task));
        }
        return Optional.absent();
    }

    public Optional<ScalingStats> getScalingStats() {
        if (this.isHalfOrFullLeader()) {
            return this.taskRunner.getScalingStats();
        }
        return Optional.absent();
    }

    public Optional<SupervisorManager> getSupervisorManager() {
        if (this.isFullLeader()) {
            return Optional.of((Object)this.supervisorManager);
        }
        return Optional.absent();
    }

    public Map<RowKey, Long> getSuccessfulTaskCount() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getSuccessfulTaskCount();
        }
        return null;
    }

    public Map<RowKey, Long> getFailedTaskCount() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getFailedTaskCount();
        }
        return null;
    }

    public Map<RowKey, Long> getRunningTaskCount() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getRunningTaskCount();
        }
        return null;
    }

    public Map<RowKey, Long> getPendingTaskCount() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getPendingTaskCount();
        }
        return null;
    }

    public Map<RowKey, Long> getWaitingTaskCount() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getWaitingTaskCount();
        }
        return null;
    }

    public CoordinatorRunStats getStats() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getQueueStats();
        }
        return CoordinatorRunStats.empty();
    }

    @Nullable
    public Map<String, Long> getTotalTaskSlotCount() {
        Optional<TaskRunner> taskRunner = this.getTaskRunner();
        if (taskRunner.isPresent()) {
            return ((TaskRunner)taskRunner.get()).getTotalTaskSlotCount();
        }
        return null;
    }

    @Nullable
    public Map<String, Long> getIdleTaskSlotCount() {
        Optional<TaskRunner> taskRunner = this.getTaskRunner();
        if (taskRunner.isPresent()) {
            return ((TaskRunner)taskRunner.get()).getIdleTaskSlotCount();
        }
        return null;
    }

    @Nullable
    public Map<String, Long> getUsedTaskSlotCount() {
        Optional<TaskRunner> taskRunner = this.getTaskRunner();
        if (taskRunner.isPresent()) {
            return ((TaskRunner)taskRunner.get()).getUsedTaskSlotCount();
        }
        return null;
    }

    @Nullable
    public Map<String, Long> getLazyTaskSlotCount() {
        Optional<TaskRunner> taskRunner = this.getTaskRunner();
        if (taskRunner.isPresent()) {
            return ((TaskRunner)taskRunner.get()).getLazyTaskSlotCount();
        }
        return null;
    }

    @Nullable
    public Map<String, Long> getBlacklistedTaskSlotCount() {
        Optional<TaskRunner> taskRunner = this.getTaskRunner();
        if (taskRunner.isPresent()) {
            return ((TaskRunner)taskRunner.get()).getBlacklistedTaskSlotCount();
        }
        return null;
    }

    public boolean isHalfOrFullLeader() {
        LeadershipState state = this.leadershipState.get();
        return state == LeadershipState.HALF_LEADER || state == LeadershipState.FULL_LEADER;
    }

    public boolean isFullLeader() {
        return this.leadershipState.get() == LeadershipState.FULL_LEADER;
    }

    static enum LeadershipState {
        NOT_LEADER,
        HALF_LEADER,
        FULL_LEADER;

    }
}

