/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.SegmentAllocationRequest;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskReport;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHolder;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.rpc.IgnoreHttpResponseHandler;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class ParallelIndexSupervisorTaskClientImpl
implements ParallelIndexSupervisorTaskClient {
    private final ServiceClient client;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final Duration httpTimeout;

    public ParallelIndexSupervisorTaskClientImpl(ServiceClient client, ObjectMapper jsonMapper, ObjectMapper smileMapper, Duration httpTimeout) {
        this.client = client;
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.httpTimeout = httpTimeout;
    }

    @Override
    public SegmentIdWithShardSpec allocateSegment(DateTime timestamp) throws IOException {
        return (SegmentIdWithShardSpec)this.jsonMapper.readValue(((BytesFullResponseHolder)FutureUtils.getUnchecked((ListenableFuture)this.client.asyncRequest(new RequestBuilder(HttpMethod.POST, "/segment/allocate").smileContent(this.smileMapper, (Object)timestamp).timeout(this.httpTimeout), (HttpResponseHandler)new BytesFullResponseHandler()), (boolean)true)).getContent(), SegmentIdWithShardSpec.class);
    }

    @Override
    public SegmentIdWithShardSpec allocateSegment(DateTime timestamp, String sequenceName, @Nullable String prevSegmentId) throws IOException {
        return (SegmentIdWithShardSpec)this.jsonMapper.readValue(((BytesFullResponseHolder)FutureUtils.getUnchecked((ListenableFuture)this.client.asyncRequest(new RequestBuilder(HttpMethod.POST, "/segment/allocate").smileContent(this.smileMapper, (Object)new SegmentAllocationRequest(timestamp, sequenceName, prevSegmentId)).timeout(this.httpTimeout), (HttpResponseHandler)new BytesFullResponseHandler()), (boolean)true)).getContent(), SegmentIdWithShardSpec.class);
    }

    @Override
    public void report(SubTaskReport report) {
        FutureUtils.getUnchecked((ListenableFuture)this.client.asyncRequest(new RequestBuilder(HttpMethod.POST, "/report").smileContent(this.smileMapper, (Object)report).timeout(this.httpTimeout), (HttpResponseHandler)IgnoreHttpResponseHandler.INSTANCE), (boolean)true);
    }
}

